/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.util;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;

import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;

public class ValidateSymptomDBEditListener extends ValidateEditListener {

	
	public ValidateSymptomDBEditListener(IWorkbenchPart part, ResourceStateValidator aValidator) {
		super(part, aValidator);
	}

	/**
	 * @see ValidateEditListener#partActivated(IWorkbenchPart)
	 */
	public void partActivated(IWorkbenchPart part) {
		super.partActivated(part);
		if(part==getWorkbenchPart() && getWorkbenchPart() instanceof SymptomDBEditor){ 
			((SymptomDBEditor)part).setGlobalFindActionHandler(((SymptomDBEditor)part).getGlobalFindActionHandler());
			
			if(((SymptomDBEditor)part).getSearchDialog()!=null){
				((SymptomDBEditor)part).getSearchDialog().setTarget(((SymptomDBEditor)part).getPage(1));
				
				if(((SymptomDBEditor)part).getActivePage()==1)
					((SymptomDBEditor)part).getSearchDialog().enableButton(true);
				else
					((SymptomDBEditor)part).getSearchDialog().enableButton(false);
			}
		}
					
	}
	
	/**
	 * @see IPartListener#partBroughtToTop(IWorkbenchPart)
	 */
	public void partBroughtToTop(IWorkbenchPart part) {
		if(part==getWorkbenchPart() && getWorkbenchPart() instanceof SymptomDBEditor){
			((SymptomDBEditor)part).setGlobalFindActionHandler(((SymptomDBEditor)part).getGlobalFindActionHandler());
		}
	}
	
	/**
	 * @see ValidateEditListener#partClosed(IWorkbenchPart)
	 */
	public void partClosed(IWorkbenchPart part) {
		super.partClosed(part);
		if (part == getWorkbenchPart()){
			IEditorPart editor = getWorkbenchPart().getSite().getPage().getActiveEditor();
			if(editor instanceof SymptomDBEditor){
				((SymptomDBEditor)editor).setGlobalFindActionHandler(((SymptomDBEditor)editor).getGlobalFindActionHandler());
			}
			else{
				((SymptomDBEditor)part).setGlobalFindActionHandler(null);
			}
			
			if(((SymptomDBEditor)part).getSearchDialog()!=null && !isAnyOtherSymptomDBEditorOpen(part)){
				((SymptomDBEditor)part).getSearchDialog().close();
			}
			
		}
	}

	/**
	 * @see IPartListener#partDeactivated(IWorkbenchPart)
	 */
	public void partDeactivated(IWorkbenchPart part) {
		super.partDeactivated(part);
		if (part == getWorkbenchPart()) {
			((SymptomDBEditor)part).setGlobalFindActionHandler(null);
			if(((SymptomDBEditor)part).getSearchDialog()!=null){
				((SymptomDBEditor)part).getSearchDialog().enableButton(false);
			}			
		}
	}
	
	private boolean isAnyOtherSymptomDBEditorOpen(IWorkbenchPart part){
		IEditorReference[] editors = getWorkbenchPart().getSite().getPage().getEditorReferences();
		boolean found = false;
		for(int i=0; i<editors.length; i++){
			IEditorPart editor = editors[i].getEditor(false);
			if(editor instanceof SymptomDBEditor && editor !=part){
				found = true;
				break;
			}
		}
		return found;
	}

}
