/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.ui.actions;

import java.io.FileInputStream;
import java.io.IOException;

import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderLaunchWizard;
import org.eclipse.hyades.internal.execution.recorder.ui.actions.AbstractNewRecordingAction;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 * @author jnevicos
 *
 */
public class NewHttpRecordingAction
	extends AbstractNewRecordingAction
	implements IWorkbenchWindowActionDelegate {


	protected ImageDescriptor image = null;
	
	/**
	 * 
	 */
	public NewHttpRecordingAction()
	{
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param text
	 */
	public NewHttpRecordingAction(String text)
	{
		super(text);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param text
	 * @param image
	 */
	public NewHttpRecordingAction(String text, ImageDescriptor image)
	{
		super(text, image);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param text
	 * @param style
	 */
	public NewHttpRecordingAction(String text, int style)
	{
		super(text, style);
		// TODO Auto-generated constructor stub
	}

	public RecorderWizard loadWizard()
	{
		return new HttpRecorderLaunchWizard();
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor()
	{
		if (image == null)
		{	
			image = new ImageDescriptor()
			{	
				public ImageData getImageData()
				{
					try
					{
						String path = Platform.resolve(HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL()).toString()+"icons/http.gif"; //$NON-NLS-1$
						path = path.substring(5,path.length());
						return new ImageData(new FileInputStream(path));
					}
					catch (IOException e)
					{
						e.printStackTrace();
					}
					return null;
				}
		
			};
		}
		return image;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.Action#getToolTipText()
	 */
	public String getToolTipText()
	{	
		return HttpRecorderPlugin.getResourceString("HTTP_RECORDER_NEW_WIZARD_DESCRIPTION");
	}

}
