/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.junit.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.http.internal.util.HttpConstants;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.test.ui.internal.editor.extension.IWriteAccessChangeListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;


/**
 * @author marcelop
 * @since 1.0.2
 */
public class HttpTestCaseDetailPage
extends DetailSection.DetailPage implements ModifyListener, IWriteAccessChangeListener, SelectionListener
{
	public static final int COLUMNS_IN_LAYOUT = 2;
	
	private CCombo methodCombo;

	private StyledText httpVersionText;
	private StyledText hostText;
	private StyledText portText;
	private StyledText absolutePathText;
	private StyledText bodyText;
	private HttpHeaderViewer headerViewer;
	// aberns:
	private CCombo     m_thinkTimeCo;

	private RequestHelper requestHelper;

/*	private StyledText	m_pageNumText;
	private CCombo		m_pageOrderCo; //TODO: change this to Combo
*/	
	private Button		m_sslButton;

    /**
     * Constructor for HttpTestCaseDetailPage
     */
    public HttpTestCaseDetailPage()
    {
		requestHelper = new RequestHelper();
    }

	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		getEditorForm().getBaseEditorExtension().removeListener(this);
		requestHelper.dispose();
		headerViewer.dispose();
	}

    /**
     * @see org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection.DetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
     */
	public Control createControl(Composite parent, FormWidgetFactory factory)
	{
		getEditorForm().getBaseEditorExtension().addListener(this);

		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		GridLayout gridLayout = new GridLayout(COLUMNS_IN_LAYOUT, true);
		gridLayout.horizontalSpacing = 10;
		composite.setLayout(gridLayout);

		widgetFactory.createLabel(composite, TestHttpPlugin.getString("HTTP_Version_Label"));
		httpVersionText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);		
		GridData gd = new GridData(); gd.horizontalSpan = 2;
		httpVersionText.setLayoutData(gd);
		
		widgetFactory.createLabel(composite, TestHttpPlugin.getString("RQ_METH_TEXT"));
		methodCombo = widgetFactory.createCCombo(composite, SWT.FLAT);
		methodCombo.setLayoutData(getFullRowLayoutData());
		methodCombo.setItems(HttpConstants.SUPPORTED_REQUEST_METHODS);

		widgetFactory.createLabel(composite, TestHttpPlugin.getString("HOST_TEXT"));
		hostText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		hostText.setLayoutData(getFullRowLayoutData());

		widgetFactory.createLabel(composite, TestHttpPlugin.getString("PORT_TEXT"));
		portText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		portText.setLayoutData(getFullRowLayoutData());

// aberns -->
	    widgetFactory.createLabel( composite, TestHttpPlugin.getString("THINK_TIME"));
		m_thinkTimeCo = widgetFactory.createCCombo( composite, SWT.FLAT );
		m_thinkTimeCo.setLayoutData( getFullRowLayoutData());
		m_thinkTimeCo.setItems( new String[] {
			TestHttpPlugin.getString( "THNK_TIME_DEF" ),
			TestHttpPlugin.getString( "THNK_TIME_QRY" )
		} );

// aberns --<

		widgetFactory.createLabel(composite, TestHttpPlugin.getString("ABS_PATH_TEXT"));
		absolutePathText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		absolutePathText.setLayoutData(getFullRowLayoutData());

//page		
		//TODO jnevicos: fix layout
		
/*		widgetFactory.createLabel(composite, TestHttpPlugin.getString("PAGE_NUM"));
		widgetFactory.createLabel(composite, TestHttpPlugin.getString("PAGE_ORDER"));

		m_pageNumText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		m_pageNumText.setLayoutData(GridDataUtil.createHorizontalFill());
	
		m_pageOrderCo = widgetFactory.createCCombo(composite, SWT.FLAT);
		m_pageOrderCo.setLayoutData(GridDataUtil.createHorizontalFill());
	
		String[] ENUM = {TestHttpPlugin.getString("ENUM_START"),
						TestHttpPlugin.getString("ENUM_ONLY"),
						TestHttpPlugin.getString("ENUM_MID"),
						TestHttpPlugin.getString("ENUM_END"),
						TestHttpPlugin.getString("ENUM_UNDEFINED")};

		m_pageOrderCo.setItems(ENUM);
*/	
		m_sslButton = widgetFactory.createButton(composite, TestHttpPlugin.getString("SSL_LABEL"), SWT.CHECK);
		m_sslButton.setLayoutData(getFullRowLayoutData());


		widgetFactory.createLabel(composite, TestHttpPlugin.getString("BODY_TEXT"));
		bodyText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		GridData gridData = getFullRowLayoutData();
		gridData.heightHint = 4*hostText.getLineHeight();
		bodyText.setLayoutData(gridData);

		headerViewer = new HttpHeaderViewer();
		headerViewer.createControl(composite, widgetFactory);
		headerViewer.setReadOnly(isReadOnly());
		
		widgetFactory.paintBordersFor(composite);
		return composite;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection.DetailPage#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		requestHelper.dispose();

		methodCombo.removeModifyListener(this);
		httpVersionText.removeVerifyKeyListener(this);
		httpVersionText.removeModifyListener(this);
		hostText.removeVerifyKeyListener(this);
		hostText.removeModifyListener(this);
		absolutePathText.removeVerifyKeyListener(this);
		absolutePathText.removeModifyListener(this);
		bodyText.removeVerifyKeyListener(this);
		bodyText.removeModifyListener(this);
		portText.removeVerifyKeyListener(this);
		portText.removeModifyListener(this);

		// aberns:
		m_thinkTimeCo.removeModifyListener( this );
		m_thinkTimeCo.removeSelectionListener( this );
/*
		m_pageNumText.removeVerifyKeyListener(this);
		m_pageNumText.removeModifyListener(this);
		m_pageOrderCo.removeModifyListener( this );
		m_pageOrderCo.removeSelectionListener( this );
*/
		m_sslButton.removeSelectionListener(this);
	
		httpVersionText.setText("");
		hostText.setText("");
		bodyText.setText("");
		portText.setText("");
		absolutePathText.setText("");
		methodCombo.setText("");

		// aberns:
		m_thinkTimeCo.setText( "" );
/*
		m_pageNumText.setText( "");
		m_pageOrderCo.setText("");
*/
		m_sslButton.setSelection(false);
		
		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		if(object instanceof ITestCase)
		{
			methodCombo.setEnabled(!isReadOnly());

			httpVersionText.setEditable(false);
			hostText.setEditable(true);
			bodyText.setEditable(true);
			absolutePathText.setEditable(true);
			portText.setEditable(true);

			// aberns:
			m_thinkTimeCo.setEnabled( !isReadOnly());

//			m_pageNumText.setEditable(true);
			
			requestHelper.setTestCase((ITestCase)object);
			httpVersionText.setText(HttpConstants.HTTP_VERSION);
			absolutePathText.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_ABS_PATH)));
			bodyText.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_BODY)));
			hostText.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_HOST)));
			portText.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_PORT)));
			methodCombo.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_METHOD)));

			// aberns:
			String attr = requestHelper.getAttribute( RequestHelper.ATT_THINK_TIME );
			if( attr == null || attr.charAt(0) == '-' ){
				m_thinkTimeCo.setText( "" );
				m_thinkTimeCo.setSelection( new Point( 1, 1 ));
				m_thinkTimeCo.select(1);
			} else {
				m_thinkTimeCo.setText( attr );
			}

//			m_pageNumText.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_PAGE_NUM)));			
			m_sslButton.setSelection("true".equalsIgnoreCase((HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_IS_SSL)))));
			String strEnum; int nEnum; 			
			try {
				nEnum = Integer.parseInt(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_PAGE_ORDER)));
				switch (nEnum) 
				{
					case HttpRequest.PAGE_START:
						strEnum = TestHttpPlugin.getString("ENUM_START");
						break;
					case HttpRequest.PAGE_MID:
						strEnum = TestHttpPlugin.getString("ENUM_MID");
						break;
					case HttpRequest.PAGE_END:
						strEnum = TestHttpPlugin.getString("ENUM_END");
						break;
					case HttpRequest.PAGE_ONLY:
						strEnum = TestHttpPlugin.getString("ENUM_ONLY");
						break;
					default:
						strEnum = TestHttpPlugin.getString("ENUM_UNDEFINED");
						break;						
				}
			}
			catch (NumberFormatException e) 
			{
				strEnum = TestHttpPlugin.getString("ENUM_UNDEFINED");
			}
//			m_pageOrderCo.setText(strEnum);
			
			headerViewer.setEnabled(true);
			headerViewer.setInput(requestHelper);
		}
		else
		{
			httpVersionText.setEditable(false);
			hostText.setEditable(false);
			bodyText.setEditable(false);
			absolutePathText.setEditable(false);
			methodCombo.setEnabled(false);
			portText.setEditable(false);

			//	aberns:
			m_thinkTimeCo.setEnabled( false );

//			m_pageNumText.setEnabled(false);
//			m_pageOrderCo.setEnabled(false);
			m_sslButton.setEnabled(false);
			headerViewer.setEnabled(false);
			
		}

		methodCombo.addModifyListener(this);
		httpVersionText.addVerifyKeyListener(this);
		httpVersionText.addModifyListener(this);
		hostText.addVerifyKeyListener(this);
		hostText.addModifyListener(this);
		absolutePathText.addVerifyKeyListener(this);
		absolutePathText.addModifyListener(this);
		bodyText.addVerifyKeyListener(this);
		bodyText.addModifyListener(this);
		portText.addVerifyKeyListener(this);
		portText.addModifyListener(this);
		
		// aberns:
		m_thinkTimeCo.addModifyListener( this );
		m_thinkTimeCo.addSelectionListener( this );
		
/*		m_pageNumText.addVerifyKeyListener(this);
		m_pageNumText.addModifyListener(this);
		m_pageOrderCo.addModifyListener( this );
		m_pageOrderCo.addSelectionListener( this );
*/
		m_sslButton.addSelectionListener(this);
		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getInput()
	 */
	public Object getInput()
	{
		return requestHelper.getTestCase();
	}

	/**
	 * @see org.eclipse.swt.custom.VerifyKeyListener#verifyKey(org.eclipse.swt.events.VerifyEvent)
	 */
	public void verifyKey(VerifyEvent event)
	{
		super.verifyKey(event);
		if(event.widget == portText)
			UIUtil.integerStyledTextVerifyKey(event);
	}

	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		if(e.widget == absolutePathText)
			requestHelper.setAttribute(RequestHelper.ATT_ABS_PATH, absolutePathText.getText());

		else if(e.widget == bodyText)
			requestHelper.setAttribute(RequestHelper.ATT_BODY, bodyText.getText());

		else if(e.widget == hostText)
			requestHelper.setAttribute(RequestHelper.ATT_HOST, hostText.getText());

		else if(e.widget == portText)
			requestHelper.setAttribute(RequestHelper.ATT_PORT, portText.getText());

		else if(e.widget == methodCombo)
			requestHelper.setAttribute(RequestHelper.ATT_METHOD, methodCombo.getText());
				
		else if( e.widget == m_thinkTimeCo ){
			try{
				Long.parseLong( m_thinkTimeCo.getText() );
				requestHelper.setAttribute(RequestHelper.ATT_THINK_TIME, m_thinkTimeCo.getText());
				m_thinkTimeCo.setForeground( null );
			} catch ( Exception ex ){
				m_thinkTimeCo.setForeground( new Color( m_thinkTimeCo.getShell().getDisplay(), 255, 0, 0));
			}
		}

/*
 		else if(e.widget == m_pageNumText)
			requestHelper.setAttribute(RequestHelper.ATT_PAGE_NUM, m_pageNumText.getText());

		else if(e.widget == m_pageOrderCo)
		{
			if (TestHttpPlugin.getString("ENUM_START").equals(m_pageOrderCo.getText()))
				requestHelper.setAttribute(RequestHelper.ATT_PAGE_ORDER, Integer.toString(HttpRequest.PAGE_START));
			else if (TestHttpPlugin.getString("ENUM_MID").equals(m_pageOrderCo.getText()))
				requestHelper.setAttribute(RequestHelper.ATT_PAGE_ORDER, Integer.toString(HttpRequest.PAGE_MID));
			else if (TestHttpPlugin.getString("ENUM_END").equals(m_pageOrderCo.getText()))
				requestHelper.setAttribute(RequestHelper.ATT_PAGE_ORDER, Integer.toString(HttpRequest.PAGE_END));
			else if (TestHttpPlugin.getString("ENUM_ONLY").equals(m_pageOrderCo.getText()))
				requestHelper.setAttribute(RequestHelper.ATT_PAGE_ORDER, Integer.toString(HttpRequest.PAGE_ONLY));
			else
				requestHelper.setAttribute(RequestHelper.ATT_PAGE_ORDER, Integer.toString(HttpRequest.PAGE_UNDEFINED));
		}
*/
		if(requestHelper.isDirty())
			getEditorForm().getBaseEditorExtension().markDirty();
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.extension.IWriteAccessChangeListener#writeAccessChanged(org.eclipse.core.resources.IFile, boolean)
	 */
	public void writeAccessChanged(IFile file, boolean isReadOnly)
	{
		methodCombo.setEnabled(!isReadOnly);
		headerViewer.setReadOnly(isReadOnly);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e)
	{
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e)
	{
		if( e.widget == m_thinkTimeCo )
		{
		   String text = null;
		   switch( m_thinkTimeCo.getSelectionIndex())
		   {
			   case -1: // nothing selected
				   text = m_thinkTimeCo.getText(); break; // no selection, use text part
			   case  0: // remember default
				   text = HttpPreferenceUtil.getInstance().getDefaultThinkTime();  
				   m_thinkTimeCo.setText( text );
					break;
			   case  1: // query for default
				   text = "-1"; break;
		   }
		   requestHelper.setAttribute( RequestHelper.ATT_THINK_TIME, text );
		   m_thinkTimeCo.setForeground( null );
		}
		else if (e.widget == m_sslButton)
		{
			if (m_sslButton.getSelection())
				requestHelper.setAttribute(RequestHelper.ATT_IS_SSL, "true");
			else
				requestHelper.setAttribute(RequestHelper.ATT_IS_SSL, "false");		
		}

		if(requestHelper.isDirty())
			getEditorForm().getBaseEditorExtension().markDirty();

	}
	
	protected GridData getFullRowLayoutData()
	{
		GridData gd = GridDataUtil.createHorizontalFill();
		gd.horizontalSpan = COLUMNS_IN_LAYOUT;
		return gd;
	}
	
}
