/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;

public class HttpPreferencePage extends PreferencePage implements IWorkbenchPreferencePage
{
	private Text MSII;
	private Text MSIT;
	private Text MTCG;

	private Text defaultHostNameText;
	private StyledText defaultHostPortText;
	private Text defaultAbsolutePathText;
	private StyledText defaultThinkTime;
	private StyledText	defaultVariance;
	

	/**
	 * Constructor for PluginPreferencePage.
	 */
	public HttpPreferencePage()
	{
		super();
	}

	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults()
	{
		MSII.setText(HttpPreferenceUtil.getInstance().getSavedInfileHistorySize(true) + "");
		MSIT.setText(HttpPreferenceUtil.getInstance().getSavedTargetHistorySize(true) + "");
		MTCG.setText(HttpPreferenceUtil.getInstance().getMaxThreads(true) + "");

		defaultAbsolutePathText.setText(HttpPreferenceUtil.getInstance().getDefaultAbsolutePath(true));
		defaultHostNameText.setText(HttpPreferenceUtil.getInstance().getDefaultHostName(true));
		defaultHostPortText.setText(HttpPreferenceUtil.getInstance().getDefaultHostPort(true));

		//aberns
		defaultThinkTime.setText( HttpPreferenceUtil.getInstance().getDefaultThinkTime( true ));
	}

	protected void storeValues()
	{
		try
		{
			HttpPreferenceUtil.getInstance().setSavedInfileHistorySize(new Integer(MSII.getText()).intValue());
		}
		catch (NumberFormatException e)
		{
		}
		
		try
		{
			HttpPreferenceUtil.getInstance().setSavedTargetHistorySize(new Integer(MSIT.getText()).intValue());
		}
		catch (NumberFormatException e)
		{
			e.printStackTrace();
		}
		
		try
		{
			HttpPreferenceUtil.getInstance().setMaxThreads(new Integer(MTCG.getText()).intValue());
		}
		catch (NumberFormatException e)
		{
		}

		HttpPreferenceUtil.getInstance().setDefaultAbsolutePath(defaultAbsolutePathText.getText());
		HttpPreferenceUtil.getInstance().setDefaultHostName(defaultHostNameText.getText());
		HttpPreferenceUtil.getInstance().setDefaultHostPort(defaultHostPortText.getText());
		//aberns
		HttpPreferenceUtil.getInstance().setDefaultThinkTime( defaultThinkTime.getText() );
		HttpPreferenceUtil.getInstance().setDefaultVariance( defaultVariance.getText() );

		TestHttpPlugin.getInstance().savePluginPreferences();
	}

	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent)
	{
		WorkbenchHelp.setHelp(parent, TestHttpPlugin.getID() + ".ctst0011");
		
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		GridData gridData;

		layout.marginWidth = 0;
		layout.marginHeight = 10;
		layout.numColumns = 1;
		composite.setLayout(layout);

		Group importGroup = new Group(composite, SWT.NONE);

		layout = new GridLayout();
		layout.marginWidth = 5;
		layout.marginHeight = 10;
		layout.numColumns = 2;

		importGroup.setLayout(layout);

		gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.grabExcessHorizontalSpace = true;
		importGroup.setLayoutData(gridData);

		importGroup.setText(TestHttpPlugin.getString("ImportControls.Label"));

		Label label = new Label(importGroup, SWT.NONE);
		label.setText(TestHttpPlugin.getString("MaxSavedImportInfile.Label"));

		MSII = new Text(importGroup, SWT.BORDER);
		MSII.setLayoutData(GridDataUtil.createHorizontalFill());

		label = new Label(importGroup, SWT.NONE);
		label.setText(TestHttpPlugin.getString("MaxSavedImportTarget.Label"));

		MSIT = new Text(importGroup, SWT.BORDER);
		MSIT.setLayoutData(GridDataUtil.createHorizontalFill());

		Group codegenGroup = new Group(composite, SWT.NONE);

		layout = new GridLayout();
		layout.marginWidth = 5;
		layout.marginHeight = 10;
		layout.numColumns = 2;

		codegenGroup.setLayout(layout);

		gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.grabExcessHorizontalSpace = true;
		codegenGroup.setLayoutData(gridData);

		codegenGroup.setText(TestHttpPlugin.getString("Codegen.Label"));

		label = new Label(codegenGroup, SWT.NONE);
		label.setText(TestHttpPlugin.getString("MaxThreads.Label"));

		MTCG = new Text(codegenGroup, SWT.BORDER);
		MTCG.setLayoutData(GridDataUtil.createHorizontalFill());

		Group defaultGroup = new Group(composite, SWT.NONE);

		layout = new GridLayout();
		layout.marginWidth = 5;
		layout.marginHeight = 10;
		layout.numColumns = 4; // aberns

		defaultGroup.setLayout(layout);
		defaultGroup.setLayoutData(GridDataUtil.createHorizontalFill());

		defaultGroup.setText(TestHttpPlugin.getString("control.default.Values"));

		label = new Label(defaultGroup, SWT.NONE);
		label.setText(TestHttpPlugin.getString("Host_Name_Label"));
		defaultHostNameText = new Text(defaultGroup, SWT.BORDER);
		gridData = GridDataUtil.createHorizontalFill();
		gridData.horizontalSpan = 3;
		defaultHostNameText.setLayoutData( gridData );

		label = new Label(defaultGroup, SWT.NONE);
		label.setText(TestHttpPlugin.getString("Port_Label"));
		defaultHostPortText = new StyledText(defaultGroup, SWT.BORDER);
		gridData = GridDataUtil.createHorizontalFill();

		GC gc = new GC( defaultHostNameText );
		gc.setFont( defaultHostNameText.getFont() );
		FontMetrics fm = gc.getFontMetrics();
		int hint = Dialog.convertHeightInCharsToPixels( fm, 1 ) + 3;
		gc.dispose();

		gridData.heightHint = hint;
		gridData.horizontalSpan = 3;
		defaultHostPortText.setLayoutData(gridData);
		defaultHostPortText.addVerifyKeyListener(new VerifyKeyListener()
		{
			public void verifyKey(VerifyEvent event)
			{
				UIUtil.integerStyledTextVerifyKey(event);
			}
		});
		
		label = new Label(defaultGroup, SWT.NONE);
		label.setText(TestHttpPlugin.getString("Abs_Path_Label"));
		defaultAbsolutePathText = new Text(defaultGroup, SWT.BORDER);
		gridData = GridDataUtil.createHorizontalFill();
		gridData.horizontalSpan = 3;
		defaultAbsolutePathText.setLayoutData( gridData );

		// aberns -->
		label = new Label(defaultGroup, SWT.NONE);
		label.setText( TestHttpPlugin.getString("Think_Time"));
		defaultThinkTime = new StyledText(defaultGroup, SWT.BORDER);
		gridData = GridDataUtil.createHorizontalFill();
		gridData.heightHint = hint;
		defaultThinkTime.setLayoutData(gridData);
		defaultThinkTime.addVerifyKeyListener(new VerifyKeyListener()
		{
			public void verifyKey(VerifyEvent event)
			{
				UIUtil.integerStyledTextVerifyKey(event);
			}
		});
		label = new Label(defaultGroup, SWT.NONE);
		label.setText( TestHttpPlugin.getString( "Variance" ));
		defaultVariance = new StyledText( defaultGroup, SWT.BORDER | SWT.SINGLE );
		gridData = GridDataUtil.createHorizontalFill();
		defaultVariance.setLayoutData( gridData ); 
		defaultVariance.setTextLimit( 2 );
		defaultVariance.addVerifyKeyListener( new VerifyKeyListener()
		{
			public void verifyKey(VerifyEvent event)
			{
				UIUtil.integerStyledTextVerifyKey(event);
			}
		});
		
		// aberns --<


		loadSavedValues();

		return composite;
	}

	private void loadSavedValues()
	{
		MSII.setText(HttpPreferenceUtil.getInstance().getSavedInfileHistorySize() + "");
		MSIT.setText(HttpPreferenceUtil.getInstance().getSavedTargetHistorySize() + "");
		MTCG.setText(HttpPreferenceUtil.getInstance().getMaxThreads() + "");

		defaultAbsolutePathText.setText(HttpPreferenceUtil.getInstance().getDefaultAbsolutePath());
		defaultHostNameText.setText(HttpPreferenceUtil.getInstance().getDefaultHostName());
		defaultHostPortText.setText(HttpPreferenceUtil.getInstance().getDefaultHostPort());
		defaultThinkTime.setText( HttpPreferenceUtil.getInstance().getDefaultThinkTime() );
		defaultVariance.setText( HttpPreferenceUtil.getInstance().getDefaultVariance() );
		
	}

	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk()
	{
		storeValues();
		
		return true;
	}

	/**
	 * @see IWorkbenchPreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
	
}