/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/*
 * Created on Mar 4, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class SDLogcPluginImages {
	private static URL fgIconBaseURL = null;

	static {
		String pathSuffix = "icons/full/"; //$NON-NLS-1$
		try {
			fgIconBaseURL =
				new URL(SDLogcPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
		} catch (MalformedURLException e) {
		}
	}

	/*
	 * Set of predefined Image Descriptors.
	 * the following Strings are all $NON-NLS-1$
	 */
	public static final String T_OBJ = "obj16"; //$NON-NLS-1$
	public static final String IMG_THREAD 	= "thread_obj.gif";//$NON-NLS-1$
	public static final String IMG_LOG 		= "log_obj.gif";//$NON-NLS-1$

	public static final ImageDescriptor DESC_IMG_THREAD 	= createManaged(T_OBJ,IMG_THREAD);
	public static final ImageDescriptor DESC_IMG_LOG 	= createManaged(T_OBJ,IMG_LOG);
    
		
	protected static Map _images;
	protected static Map _imageDescriptors;

	public static IImage getImage(String name)
	{
		return (IImage)_images.get(name);
	}

	public static ImageDescriptor getImageDescriptor(String name) {
		return (ImageDescriptor) _imageDescriptors.get(name);
	}

	private static ImageDescriptor createManaged(String prefix, String name) {
		try {
			ImageDescriptor result =
				ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));

			if (_images == null || _imageDescriptors == null) {
				_images = new Hashtable();
				_imageDescriptors = new Hashtable();
			}

			_imageDescriptors.put(name, result);
			_images.put(name, new ImageImpl(result.createImage()));
			return result;

		} catch (MalformedURLException e) {
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}

	private static URL makeIconFileURL(String prefix, String name)
		throws MalformedURLException {
		if (fgIconBaseURL == null)
			throw new MalformedURLException();

		StringBuffer buffer;
		if (prefix != null) {
			buffer = new StringBuffer(prefix);
			buffer.append('/');
			buffer.append(name);
		} else {
			buffer = new StringBuffer(name);
		}
		return new URL(fgIconBaseURL, buffer.toString());
	}

	private static ImageDescriptor create(String prefix, String name) {
		try {
			return ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
		} catch (MalformedURLException e) {
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}
	public static void shutdown() {
		if (_images == null)
			return;

		for (Iterator e = _images.values().iterator(); e.hasNext();) {
			Object next = e.next();
			if (next instanceof IImage && !((Image)((IImage) next).getImage()).isDisposed()) {
				((IImage) next).dispose();
			}
		}

		_images.clear();
		_images = null;
		_imageDescriptors.clear();
		_imageDescriptors = null;

	}
	
	public static void dispose(String name){
		IImage image = (IImage)_images.get(name);
		if(image!=null){
			_images.remove(image);
			image.dispose();
		}
	}

}
