/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Feb 3, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.sd.logc.internal.loader;


import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.LogFilterCriteria;
import org.eclipse.hyades.log.ui.internal.actions.provider.LogFindCriteria;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.FiltersDialog;
import org.eclipse.hyades.log.ui.internal.util.LogRecordSearch;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.util.RecordFilterSearchUtil;
import org.eclipse.hyades.log.ui.internal.util.SearchRecordDialog;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl;
import org.eclipse.hyades.sd.logc.SDLogcConstants;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.sd.logc.internal.uml2sd.SourceOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.TargetOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.util.ContextIds;
import org.eclipse.hyades.sd.logc.internal.util.LogCorrelationSelectionDialog;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogInteractions 
	implements IUml2SDLoader, ISelectionListener, ISelectionChangedListener, IViewSelectionChangedListener,
			   ISDAdvancedPagingProvider,
			   IExtendedFilterProvider, IExtendedFindProvider,
			   ILogFilterProvider, ILogFindProvider, IProfileEventListener {
	
	public class LogInteractionsFrame extends Frame{
		
			/* (non-Javadoc)
		 * @see org.eclipse.hyades.uml2sd.ui.core.Frame#getMaxEventOccurrence()
		 */
		public int getMaxEventOccurrence() {			
			return super.getMaxEventOccurrence();
		}
		

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.uml2sd.ui.core.Frame#getLifelines()
		 */
		public List getLifelines() {
			// TODO Auto-generated method stub
			return super.getLifelines();
		}

	}
	
	public class TraceLifeline extends Lifeline {
		public EObject model;
		public int start, end;
		
	}
	

	protected class LogRecordComparator implements Comparator{

		public int compare(Object o1, Object o2){	
			if(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o1)>CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o2)){
				return 1;
			}else if(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o1)==CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o2)){ 
				if(((CBECommonBaseEvent)o1).getSequenceNumber()>((CBECommonBaseEvent)o2).getSequenceNumber()){
					return 1;
				}else if(((CBECommonBaseEvent)o1).getSequenceNumber()==((CBECommonBaseEvent)o2).getSequenceNumber()){
					return 0;
				}else
					return -1;
			}
			else{
				return -1;
			}
		}
	
	}
	protected CorrelationContainerProxy correlationContainerProxy;
	protected EObject inputObject;
	protected Map graphNodes = new HashMap();

	protected Map lifelinesMap = new HashMap();	
	protected List eventsList = new ArrayList();
	protected Map currentPageEvents = new HashMap();
	protected List agentsList = new ArrayList();
	protected SDView view;
	//protected Map targetEvents = new HashMap();
	private Map sourceOutOfPageMessages;
	private Map targetOutOfPageMessages;	
	//protected Map temp = new HashMap();
	private IConfigurationElement correlationType; 
	private LogRecordComparator comparator;
	private CBECommonBaseEvent currentSelection;
	/**
	 * Paging related attributes
	 */
	private int currentPageIndex = 0;
	private int nrOfPages = 0;
	private int PAGE_SIZE = 0;
	private int MAX_NR_OF_RECORDS = 99999; //don't change this value, it is limited in the UI.
	private int totalSize = 0;
	
	/**
	 * Find and Filter related attributes
	 */
	private ArrayList filterTableElements = null;
	private ArrayList findTableElements = null;
	private RecordFilterSearchUtil recordFilterSearch = null;
	private boolean displayOnlyCorrelations = true;
	
	private Object[] pageCache;

	private LogRecordSearch logRecordSearch = null;
	private Label lblMessage;
	private Object lastMatch = null;
	
	/**
	 * The frame containing the current page
	 */
	protected LogInteractionsFrame frame;
	protected static LifelineCategories[] traceCategories;
	protected static IImage image; 
	public static final int CATEGORY_LOGS = 0;
	static{		
		traceCategories = new LifelineCategories[1];
		traceCategories[CATEGORY_LOGS] = new LifelineCategories();
		traceCategories[CATEGORY_LOGS].setName(""); 
		image = SDLogcPluginImages.getImage(SDLogcPluginImages.IMG_LOG);
		traceCategories[CATEGORY_LOGS].setImage(image); 
	}

	public LogInteractions() {
		UIPlugin.getDefault().addSelectionListener(this);
		UIPlugin.getDefault().addViewSelectionChangedListener(this);
		UIPlugin.getDefault().addProfileEventListener(this);		
		recordFilterSearch = new RecordFilterSearchUtil();
	}

	/**
	 * Implementation of IUml2SDLoader
	 */
	public void setViewer(SDView view) {
		this.view = view;
		view.setSDPagingProvider(this);
		
		view.setExtendedFilterProvider(this);
		view.setExtendedFindProvider(this);
		view.getSDWidget().getSelectionProvider().addSelectionChangedListener(this);
		
		WorkbenchHelp.setHelp(this.view.getSDWidget(),ContextIds.INTERACTION_VIEW);
	}
	public void aboutToBeReplaced() {
		UIPlugin.getDefault().removeSelectionListener(this);
		UIPlugin.getDefault().removeViewSelectionChangedListener(this);
		UIPlugin.getDefault().removeProfileEventListener(this);
		if (view != null) {
			view.getSDWidget().getSelectionProvider().removeSelectionChangedListener(this);
		}
		clearDiagramCaches();		
		recordFilterSearch=null;
	}
	
	public void generateLogInteractions(final EObject eObject, final boolean displayDialog){		
		view.setFrame(parseModel(eObject, displayDialog));
	}
	
	public void generateLogInteractions(final EObject eObject, final IConfigurationElement config){
		setCorrelationType(config);
		view.setFrame(parseModel(CorrelationHelper.getInstance().createCorrelationContainer(correlationType, eObject,correlationType.getAttribute("name")), false));
	}
	
	public LogInteractionsFrame parseModel(final EObject eObject, final boolean displayDialog){
		
		inputObject = eObject; 	
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		displayOnlyCorrelations = store.getString(LogUIConstants.PD_FILTER_SHOW_CORRELATION_ONLY).equals("1");
		
		correlationContainerProxy = null;
		clearDiagramCaches();

		BusyIndicator.showWhile(Display.getDefault(),new Runnable(){
			public void run(){	
				loadCorrelations(displayDialog);
				createPartition();
				frame = createPage();

			}
		});

		return frame;
 
	}
	
	public LogInteractionsFrame parseModel(EObject eObject) {
		return parseModel(eObject, false);		
	}
	
	protected List getFilteredEvents(List input){
		if (input==null) return input;
		
		List filteredList = new ArrayList();
		for (int i = 0; i < input.size(); i++) {
			Object entry = input.get(i);
			if (isFilterApplied((EObject)entry))
				filteredList.add(entry);
		}		
		Collections.sort(filteredList, getComparator());
		return filteredList;
	}
	
	/**
	 * @param event for checking if current filter applied.
	 * @return true if event match the filter, false when not matched.
	 * 
	 * if there is no filter, return true always.
	 */
	private boolean isFilterApplied(EObject event){
		if (filterTableElements==null || filterTableElements.size()==0) return true;
		return recordFilterSearch.isAdvFilterApply(event, filterTableElements);
	}
	
	protected void clearTemporaryCaches(){		
		
		graphNodes.clear();
		//targetEvents.clear();
		//temp.clear();
		lifelinesMap.clear();
		currentPageEvents.clear();
		
		if(sourceOutOfPageMessages!=null)	
			sourceOutOfPageMessages.clear();		
		if(targetOutOfPageMessages!=null)
			targetOutOfPageMessages.clear();
	}
	
	protected void clearDiagramCaches(){
		clearTemporaryCaches();			
		agentsList.clear();
		if(eventsList!=null)	
			eventsList.clear();		
		if(pageCache!=null){
			for (int i = 0; i < pageCache.length; i++) {
				pageCache[i] = null;
			}
			pageCache = null;
		}
	}

	protected void loadCorrelations(boolean displayDialog){
		
		if(inputObject instanceof CorrelationContainerProxy)
		{
			correlationContainerProxy = (CorrelationContainerProxy)inputObject;
		}else{
			if(displayDialog)	{
				showCorrelationDialog();
					
			}			
		}
		
		if(correlationContainerProxy!=null){
			agentsList.addAll(((CorrelationContainerProxy)correlationContainerProxy).getCorrelatedAgents()); 
		}else{
			agentsList.addAll(HyadesUtil.getLogAgents(inputObject));
		}
		loadEvents();

		eventsList = getFilteredEvents(eventsList);		
	}
	
	protected void loadEvents(){
	
		if(!displayOnlyCorrelations){
			for (Iterator iter = agentsList.iterator(); iter.hasNext();) {
				TRCAgentProxy trcAgentProxy = (TRCAgentProxy) iter.next();
				if (trcAgentProxy != null && !trcAgentProxy.eIsProxy())
				{		
					addEvents(trcAgentProxy);
				}
			}
		}else{
			loadEventsFromCorrelations();
		}
	}
	
	protected void loadEventsFromCorrelations(){
		
		if (correlationContainerProxy==null) return;
		EMap correlations  = correlationContainerProxy.getCorrelationContainer().getCorrelations();
		CorrelationEntryImpl element;
		eventsList = new UniqueEList();
		List targetList;
		
		for (Iterator iter = correlations.iterator(); iter.hasNext();) {
			element = (CorrelationEntryImpl) iter.next();
			eventsList.add(element.getKey());
			targetList = (List)element.getValue();
			if(targetList!=null && targetList.size()>0)	
				eventsList.addAll(targetList);
		}	
	}
	
	protected Comparator getComparator(){
		if(comparator==null){
			comparator = new LogRecordComparator();
		}
		return comparator;
	}
	
	protected void generateDiagram(){
		
		BusyIndicator.showWhile(Display.getCurrent(), new Runnable(){
			public void run(){
				generateGraphNodes();
				//temp.clear();
				//targetEvents.clear();
				generateGraphConnections();				
			}
		});		
		//TODO move selection listeners to the sd view and remove them on dispose
	}
	
	protected void generateGraphNodes(){
		
		EObject key = null;
		CBECommonBaseEvent element = null;
		
		TraceLifeline lifeline = null;
		LogGraphNode node = null;
		LogGraphNode previousNode = null;
		LogGraphNode syncNode = null;
		
		
		int k = getMaxCurrentPageRangeIndex();
		int startPageIndex = currentPageIndex*PAGE_SIZE;
		int endPageIndex = currentPageIndex*PAGE_SIZE + k;
				
		for (int i=startPageIndex; i<endPageIndex; i++) {
			
			key = (EObject)eventsList.get(i);
			if(!(key instanceof CBECommonBaseEvent)){
				continue;
			}
			element = (CBECommonBaseEvent)key ;
			lifeline = (TraceLifeline)lifelinesMap.get(getLifelinesMapKey(element));
			if(graphNodes.get(element)==null){				
				node = createLogGraphNode(lifeline,element, previousNode, syncNode);
				cacheLogGraphNode(node);
				if(previousNode!=null && getComparator().compare(node.getElement(), previousNode.getElement())==0 && 
				 ((CBECommonBaseEvent)previousNode.getElement()).getAgent().getAgentProxy()==((CBECommonBaseEvent)node.getElement()).getAgent().getAgentProxy()){	
				 	syncNode = previousNode;
				 }
				previousNode = node;
			}			
		}
	}
	
	protected Object getLifelinesMapKey(CBECommonBaseEvent element){
		return element.getAgent().getAgentProxy();
	}
	
	protected void cacheLogGraphNode(LogGraphNode node){
		
		if(correlationContainerProxy==null){
			return;
		}
		
		CBECommonBaseEvent element = (CBECommonBaseEvent)node.getElement();		
		graphNodes.put(element, node);
	}
	
	protected void generateGraphConnections(){

		if(correlationContainerProxy==null){
			return;
		}
		CBECommonBaseEvent source = null;
		List targetList = null;

		CorrelationEntryImpl entry = null;
		Object key = null;
 
		EMap correlations  = correlationContainerProxy.getCorrelationContainer().getCorrelations();
		
		CBECommonBaseEvent target;
		for (Iterator iter = correlations.iterator(); iter.hasNext();) {
			entry = (CorrelationEntryImpl) iter.next();
			key = entry.getKey();
			
			if(!(key instanceof CBECommonBaseEvent)){
				continue;
			}
			source = (CBECommonBaseEvent)key;
			targetList = (List)entry.getValue();
			if(targetList==null)
				continue;
			int s = targetList.size();
			for(int i = 0;i < s;i++){
				target = (CBECommonBaseEvent)targetList.get(i);
				if(currentPageEvents.get(source)==null){	
					if(currentPageEvents.get(target)!=null){
						createSourceOutOfPageMessage(source, target);
					}
				}else{
					if(currentPageEvents.get(target)!=null){
						createAsyncMessage(source, target);
					}else{					
						createTargetOutOfPageMessage(source, target);
					}
				}
			}
		}

	}

	private void createSourceOutOfPageMessage(CBECommonBaseEvent source, CBECommonBaseEvent target){
		
		SourceOutOfPageMessage message = getSourceMessage(target);
		List sources = null;
			
		if(message==null){				
			sources = new ArrayList();
			sources.add(source);
			message = new SourceOutOfPageMessage();
				
			message.setEndLifeline((TraceLifeline)lifelinesMap.get(getLifelinesMapKey(target)));
			LogGraphNode targetNode = (LogGraphNode)graphNodes.get(target);
			message.setEndOccurrence(targetNode.getEndOccurrence());
			((SourceOutOfPageMessage)message).setSource(sources);
			
			sourceOutOfPageMessages.put(target,message);			
				 
		}else{
			sources = ((SourceOutOfPageMessage)message).getSource();
			sources.add(source);
		}
				
		frame.addMessage(message);

	}
	
	protected LogInteractionsFrame createPage(){
		
		
		if(currentPageIndex>pageCache.length-1){
			frame = new LogInteractionsFrame();
		}else{		
			LogInteractionsFrame currentFrame = (LogInteractionsFrame)pageCache[currentPageIndex];
		
			if(currentFrame!=null){
				frame = currentFrame;
				return frame;
			}else{
				frame = new LogInteractionsFrame();
			}
		}
		frame.setLifelineCategories(traceCategories);
		clearTemporaryCaches();
		
		generateLifelines();
				
		int k = getMaxCurrentPageRangeIndex();
		
		int startPageIndex = currentPageIndex*PAGE_SIZE;
		int endPageIndex = currentPageIndex*PAGE_SIZE + k;
		
		if(endPageIndex>eventsList.size()){			
			currentPageIndex = 0;
			k = getMaxCurrentPageRangeIndex();			
			startPageIndex = 0;
			endPageIndex = k;
		}
		EObject element;
		for (int i=startPageIndex;i<endPageIndex;i++) {
			
			element = (EObject)eventsList.get(i);
			if(!(element instanceof CBECommonBaseEvent)){
				continue;
			}
			currentPageEvents.put(element,((CBECommonBaseEvent)element).getGlobalInstanceId());			
		}
		frame.setName(getFrameTitle());		
		generateDiagram();
		
		pageCache[currentPageIndex] = frame;
		
		return frame;
	}
	
	protected String getFrameTitle(){
		return SDLogcPlugin.getString("STR_MENU_LOR")+ ":      " + getFrameName();
	}
	
	protected void generateLifelines(){
		for (Iterator iter = getLifelineArtifactsList().iterator(); iter.hasNext();) {
			TRCAgentProxy trcAgentProxy = (TRCAgentProxy) iter.next();
			TraceLifeline lifeLine = new TraceLifeline();
			lifeLine.setName(trcAgentProxy.getName());
			lifeLine.setCategory(CATEGORY_LOGS);
			lifelinesMap.put(trcAgentProxy, lifeLine);
			frame.addLifeLine(lifeLine);			
		}
	
	}
	
	protected List getLifelineArtifactsList(){
		return agentsList;
	}

	private int getMaxCurrentPageRangeIndex(){
		
		int r = totalSize%PAGE_SIZE;
		if(totalSize==0){
			return 0;
		}
		if(currentPageIndex+1<nrOfPages){
			return PAGE_SIZE;
		}else if(r==0){
			return PAGE_SIZE;
		}else{
			return r; 	
		}
	}
	
	protected LogGraphNode createLogGraphNode(TraceLifeline lifeline, CBECommonBaseEvent object, LogGraphNode previousNode, LogGraphNode syncNode){

		LogGraphNode node = new LogGraphNode(object);
		if(previousNode!=null){
			if(getComparator().compare(object,previousNode.getElement())==1){
				lifeline.setCurrentEventOccurrence(frame.getMaxEventOccurrence());
				node.setStartOccurrence(lifeline.getNewEventOccurrence());
				node.setEndOccurrence(lifeline.getNewEventOccurrence());
		
			}else{			
				if(((CBECommonBaseEvent)previousNode.getElement()).getAgent()==object.getAgent()){					
					node.setStartOccurrence(lifeline.getNewEventOccurrence());
					node.setEndOccurrence(lifeline.getNewEventOccurrence());
				}else{
					if(syncNode!=null){
						lifeline.setCurrentEventOccurrence(syncNode.getStartOccurrence());
					}
					else{
						lifeline.setCurrentEventOccurrence(previousNode.getStartOccurrence());
					}
					node.setStartOccurrence(lifeline.getEventOccurrence());
					node.setEndOccurrence(lifeline.getNewEventOccurrence());	
				}			
			}
		}else{
			node.setStartOccurrence(lifeline.getNewEventOccurrence());
			node.setEndOccurrence(lifeline.getNewEventOccurrence());		
		}
		node.setName(object.getMsg());
		node.setBackgroundColor();
		lifeline.addExecution(node);
		return node;

	}
	
		
	private void createAsyncMessage(CBECommonBaseEvent source, CBECommonBaseEvent target){
		
		TraceLifeline sourceLifeline = (TraceLifeline)lifelinesMap.get(getLifelinesMapKey(source));
		TraceLifeline targetLifeline = (TraceLifeline)lifelinesMap.get(getLifelinesMapKey(target));

		LogGraphNode sourceNode = (LogGraphNode)graphNodes.get(source);
		LogGraphNode targetNode = (LogGraphNode)graphNodes.get(target);
		
		AsyncMessage message = new AsyncMessage();
		message.setStartLifeline(sourceLifeline);		
		message.setEndLifeline(targetLifeline);
		message.setStartOccurrence(sourceNode.getStartOccurrence());
		message.setEndOccurrence(targetNode.getStartOccurrence());	
		
		frame.addMessage(message);
	}

	private void createTargetOutOfPageMessage(CBECommonBaseEvent source, CBECommonBaseEvent target){
	
		TraceLifeline sourceLifeline = (TraceLifeline)lifelinesMap.get(getLifelinesMapKey(source));
		LogGraphNode sourceNode = (LogGraphNode)graphNodes.get(source);
		List targets = null;
		
		TargetOutOfPageMessage message = getTargetMessage(source);		
		if(message==null){				
			targets = new ArrayList();
			targets.add(target);
			message = new TargetOutOfPageMessage();
			
			message.setStartLifeline(sourceLifeline);
			message.setStartOccurrence(sourceNode.getEndOccurrence());
			
			((TargetOutOfPageMessage)message).setTarget(targets);
			targetOutOfPageMessages.put(source,message);
			frame.addMessage(message);			
			 
		}else{
			targets = ((TargetOutOfPageMessage)message).getTarget();
			targets.add(target);
		}
	}
	
	protected void addEvents(TRCAgentProxy trcAgentProxy){

		eventsList.addAll(trcAgentProxy.getAgent().getDefaultEvents());
	}
	
	protected LogGraphNode getGraphNodeFromArtifact(CBECommonBaseEvent artifact){

		LogGraphNode graphNode=null;
		LogGraphNode source=null;
		source = (LogGraphNode)graphNodes.get(artifact);
		if(source!=null){
			return source;
		}
		//TraceLifeline lifeline = (TraceLifeline)lifelinesMap.get(getLifelinesMapKey(artifact));
		TraceLifeline lifeline = null;
		for(int i=0; i<frame.getLifelines().size(); i++) {
			lifeline = (TraceLifeline)frame.getLifelines().get(i);
			for(int k=0; k<lifeline.getExecutions().size();k++){
				graphNode = (LogGraphNode)lifeline.getExecutions().get(k);
			   if(graphNode!=null && artifact==graphNode.getElement()){
				  source = graphNode;
				  break;
			   }
			}
		}
		if(source!=null){
			graphNodes.put(artifact, source);
		}
		return source;
	}
	

	/**
	 * Implementation of ISelectionListener
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {

		if( part instanceof INavigator) {
			if (!((INavigator)part).isLinkingEnabled()) {
				return;
			}
		}
		
		if (view != null &&
			view.getSDWidget() != null &&
			!view.getSDWidget().isDisposed()) {			
			EObject sel = HyadesUtil.getMofObject();			
			if(sel!=null && sel!=inputObject)	
				view.setFrame(parseModel(sel));

		}
	}

	/**
	 * Implementation of ISelectionChangedListener
	 */
	public void selectionChanged(SelectionChangedEvent e) {
		if (e.getSelection() == null ||
			(((IStructuredSelection)e.getSelection()).size() == 0)) {
			return;
		}
		Object sel = ((IStructuredSelection)e.getSelection()).getFirstElement();
		if(sel instanceof LogGraphNode){			
			LogUtil.notifyViewSelectionChanged(this,((LogGraphNode)sel).getElement());
			currentSelection = (CBECommonBaseEvent)((LogGraphNode)sel).getElement();									
		}
			
	}

	public boolean isDisplayingOnlyCorrelations(){
		return displayOnlyCorrelations;
	}
	/**
	 * Implementation of ISDGraphNodeSupporter
	 */
	public boolean isLifelineSupported() {
		return true;
	}
	public boolean isSyncMessageSupported() {
		return true;
	}
	public boolean isSyncMessageReturnSupported() {
		return true;
	}
	public boolean isAsyncMessageSupported() {
		return true;
	}
	public boolean isAsyncMessageReturnSupported() {
		return false;
	}
	public boolean isStopSupported() {
		return false;
	}
	
	/**
	 * implementation of ISDPagingProvider
	 */
	public boolean hasNextPage() {
		return currentPageIndex+1<nrOfPages;
	}
	
	public boolean hasPrevPage() {
		return 	currentPageIndex>0;
	}
	
	public void nextPage() {
		if(currentPageIndex+1<nrOfPages){
			++currentPageIndex;
			view.setFrame(createPage());
		}		
	}
	
	public void prevPage() {
		if(currentPageIndex>0){
			--currentPageIndex;
			view.setFrame(createPage());
		}			
	}
	
	protected void createPartition(){
		
	 	totalSize = eventsList.size();
		
		PAGE_SIZE = (int)SDLogcPlugin.getDefault().getPreferenceStore().getLong(SDLogcConstants.PAGE_SIZE);
		nrOfPages = totalSize%PAGE_SIZE > 0 ? totalSize/PAGE_SIZE + 1:totalSize/PAGE_SIZE;		
		if(nrOfPages==0){	
			pageCache = new Object[1];
		}else{
			pageCache = new Object[nrOfPages];
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getTitleString() {

		String title = SDLogcPlugin.getString("STR_VIEW_TITLE")+ ": " + SDLogcPlugin.getString("STR_MENU_LOR");
		if(correlationContainerProxy!=null){
			title = title +" <"+correlationContainerProxy.getCorrelationEngine().getName()+"> ";
		}
		return  title;
	
	}


	/* (non-Javadoc)
	 * @see org.eclipse.hyades.trace.ui.IViewSelectionChangedListener#handleViewSelectionChangedEvent(org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent)
	 */
	public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
		Object  source = event.getSource();
		if(source!=this){	
			Object sel = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement();
			if (sel instanceof CBECommonBaseEvent)
				setSelection((CBECommonBaseEvent)sel);
		}
	}

	private void showCorrelationDialog() {
		
		LogCorrelationSelectionDialog logCorrelationSelectionDialog = new LogCorrelationSelectionDialog(null, CorrelationHelper.getInstance().getCorrelationExtensions());
		logCorrelationSelectionDialog.open();

		if (logCorrelationSelectionDialog.getReturnCode() == Window.OK) {

			setCorrelationType(logCorrelationSelectionDialog.getSelectedCorrelation());
			correlationContainerProxy = CorrelationHelper.getInstance().createCorrelationContainer(correlationType, inputObject, correlationType.getAttribute("name"));
			
			inputObject = correlationContainerProxy;		

			LogUtil.selectInLogNavigator(correlationContainerProxy);
			
		}

	}

	public void setSelection(CBECommonBaseEvent sel){

		view.getSDWidget().clearSelection();
		if(eventsList!=null){
			int i = eventsList.indexOf(sel);
			int pageIndex=0;
			if(i>-1){			
				pageIndex = i/PAGE_SIZE;	
			}
			goToPage(pageIndex);
			LogGraphNode node = getGraphNodeFromArtifact(sel);
			view.getSDWidget().addSelection(node);	
			view.getSDWidget().ensureVisible(node);
			currentSelection = sel;
		}
				
	}
	
	private void goToPage(int page){
		
		currentPageIndex = page;		
		view.setFrame(createPage());
		view.updateCoolBar();
	}
	
	/**
	 * @return
	 */
	public IConfigurationElement getCorrelationType() {
		return correlationType;
	}

	/**
	 * @param element
	 */
	public void setCorrelationType(IConfigurationElement element) {
		correlationType = element;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFilterProvider#getFilterAction()
	 */
	public Action getFilterAction() {
		String STR_FILTER_RECORD =	SDLogcPlugin.getString("STR_FILTER_RECORD");
			Action advfilter = new Action(STR_FILTER_RECORD) {
				public void run() {
						filter();
				}
			};
			advfilter.setText(STR_FILTER_RECORD);
			advfilter.setDescription(STR_FILTER_RECORD);
			advfilter.setToolTipText(STR_FILTER_RECORD);
		return advfilter;	
	}

	public void filter() {
		FiltersDialog dialog = new FiltersDialog(
										view.getViewSite().getShell(),
										SDLogcPlugin.getString("STR_ST_FILTER_SETTINGS"),
										null,
										this,
										true);
		dialog.open();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFindProvider#getFindAction()
	 */
	public Action getFindAction() {
		String STR_FIND_RECORD = SDLogcPlugin.getString("STR_FIND_RECORD");
		Action searchRecord = new Action(STR_FIND_RECORD) {
			public void run() {
				find();
			}
		};
		searchRecord.setText(STR_FIND_RECORD);
		searchRecord.setDescription(STR_FIND_RECORD);
		searchRecord.setToolTipText(STR_FIND_RECORD);
		return searchRecord;
	}

	public void find() {
		SearchRecordDialog dialog =	new SearchRecordDialog(
											view.getViewSite().getShell(),
											SDLogcPlugin.getString("STR_ST_FIND_SETTINGS"),
											null,
											this);
		dialog.open();

	}
	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider#filterRecord(org.eclipse.hyades.log.ui.internal.actions.provider.LogFilterCriteria)
	 */
	public boolean filterRecord(LogFilterCriteria criteria) {
		filterTableElements = criteria.getFilters();
		displayOnlyCorrelations = criteria.isShowCorrelationOnly();
		generateLogInteractions(inputObject,false);
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider#findRecord(org.eclipse.hyades.log.ui.internal.actions.provider.LogFindCriteria)
	 */
	public boolean findRecord(LogFindCriteria criteria) {
		lblMessage = criteria.getFindMessage();
		Object sel = getRecordSearchEngine().search(criteria.getFilters(),criteria.isForwardDirection()?1:-1,currentSelection);
		selectFindRecord(sel);
		return true;
	}
	
	public LogRecordSearch getRecordSearchEngine(){
		if(logRecordSearch==null){
			logRecordSearch = new LogRecordSearch();
		}

		Object start = getStartNode();
		logRecordSearch.initialize(eventsList, start);
		return logRecordSearch;	 
	}

	private Object getStartNode() {
		return currentSelection;
	}
	
	private void selectFindRecord(Object sel){
		if(sel==null){
			lblMessage.setText(SDLogcPlugin.getString("STR_STRING_NOT_FOUND"));
			return;
		}
		setSelection((CBECommonBaseEvent)sel);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider#storeFindOptions(org.eclipse.hyades.log.ui.internal.actions.provider.LogFindCriteria)
	 */
	public boolean storeFindOptions(LogFindCriteria criteria) {
		FilterTableElement.saveFilters(criteria.getFilters(),SDLogcConstants.UML2SD_EXTEND_FIND_OPTIONS,SDLogcPlugin.getDefault().getPreferenceStore());
		SDLogcPlugin.getDefault().getPreferenceStore().setValue(SDLogcConstants.UML2SD_FIND_DIRECTION_OPTIONS, criteria.isForwardDirection()?"1":"-1");
		return true;
	}	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider#loadFindPreferenceString()
	 */
	public String loadFindPreferenceString() {
		IPreferenceStore store = SDLogcPlugin.getDefault().getPreferenceStore();
		return store.getString(SDLogcConstants.UML2SD_EXTEND_FIND_OPTIONS);
	}	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider#loadFindDirection()
	 */
	public boolean loadFindDirection() {
		return SDLogcPlugin.getDefault().getPreferenceStore().getString(SDLogcConstants.UML2SD_FIND_DIRECTION_OPTIONS).equals("1");
	}	/**
	 * @return
	 */
	private SourceOutOfPageMessage getSourceMessage(CBECommonBaseEvent event) {
		if(sourceOutOfPageMessages==null){
			sourceOutOfPageMessages = new HashMap();
		}
		return (SourceOutOfPageMessage)sourceOutOfPageMessages.get(event);
	}

	/**
	 * @return
	 */
	private TargetOutOfPageMessage getTargetMessage(CBECommonBaseEvent event) {
		if(targetOutOfPageMessages==null){
			targetOutOfPageMessages = new HashMap();
		}		
		return (TargetOutOfPageMessage)targetOutOfPageMessages.get(event);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.trace.ui.IProfileEventListener#handleProfileEvent(org.eclipse.hyades.trace.ui.ProfileEvent)
	 */
	public void handleProfileEvent(ProfileEvent event) {
		if ((event.getType() == ProfileEvent.REFRESH_VIEWS || event.getType() == ProfileEvent.UPDATE_MODEL) && event.getSource() instanceof EObject) {
			parseModel(inputObject);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#currentPage()
	 */
	public int currentPage() {
		if(nrOfPages==0)
			return -1;
		
		return currentPageIndex;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#itemsText()
	 */
	public String itemsText() {
		
		return SDLogcPlugin.getString("STR_ITEMS");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#itemsTotalCount()
	 */
	public int itemsTotalCount() {
		
		return eventsList.size();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#maxItemsByPageCount()
	 */
	public int maxItemsByPageCount() {
		
		return PAGE_SIZE;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#noItemsText()
	 */
	public String noItemsText() {
				
		return SDLogcPlugin.getString("STR_ITEMS");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#oneItemText()
	 */
	public String oneItemText() {
		
		return SDLogcPlugin.getString("STR_ITEM");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#pagesCount()
	 */
	public int pagesCount() {
		
		return nrOfPages;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#pageSettingsChanged(int, int)
	 */
	public void pageSettingsChanged(int maxItemsByPage_, int pageNumber_) {
		
		if(0<=pageNumber_ && pageNumber_<nrOfPages){
			goToPage(pageNumber_);
		}
		if(maxItemsByPage_>MAX_NR_OF_RECORDS){
			maxItemsByPage_ = MAX_NR_OF_RECORDS;		
		}
		if(PAGE_SIZE!=maxItemsByPage_){	
			SDLogcPlugin.getDefault().getPreferenceStore().setValue(SDLogcConstants.PAGE_SIZE, maxItemsByPage_);
			PAGE_SIZE = maxItemsByPage_;
		}

		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#pageNumberChanged(int)
	 */
	public void pageNumberChanged(int pageNumber_) {
		goToPage(pageNumber_);
		
	}

	public CorrelationContainerProxy getCorrelationContainerProxy() {
		return correlationContainerProxy;
	}

	public String getFrameName() {

		return MessageFormat.format(SDLogcPlugin.getString("STR_PAGE_INFO"),  new String[] {String.valueOf(currentPage()+1), String.valueOf(nrOfPages)});		
		
	}
	
}


