/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.sd.logc.internal.uml2sd;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.logc.internal.util.LogcUtil;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;

/**
 * @author ewchan
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class LogGraphNode extends ExecutionOccurrence {

		private EObject element;
		
		public LogGraphNode(EObject element){
			this.element = element;
		}
		public EObject getElement(){
			return element;
		}
		
		public int getStartOccurrence(){
			return startOccurrence;
		}
		
		public int getEndOccurrence(){
			return endOccurrence;
		}
		
		public void setBackgroundColor(){
			if(element==null)
				return;
				
			short sev = ((CBECommonBaseEvent)element).getSeverity();
	   	      
			if(sev >=0 && sev <=70)
			{
			   if(sev >=50)
			   {
				   setColor(LogcUtil.redFill[0],LogcUtil.redFill[1],LogcUtil.redFill[2]);
				   		          	   	      	 				          
			   }
			   else if(sev >=30 && sev < 50)
			   {
					setColor(LogcUtil.yellowFill[0],LogcUtil.yellowFill[1],LogcUtil.yellowFill[2]);
		          	   	      	 				          
			   }
			   else if(sev< 30)		   	      	 
			   {   	
					setColor(LogcUtil.blueFill[0],LogcUtil.blueFill[1],LogcUtil.blueFill[2]);
			          	   	      	 				          
			   }
		
			}
		}
}
