/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.junit;

import java.util.Collection;

import junit.framework.TestSuite;

import org.eclipse.hyades.test.common.event.VerdictEvent;

/**
 * This interface defines an arbiter that can be used with a 
 * {@link org.eclipse.hyades.test.java.junit.HyadesTestSuite}.
 * 
 * @author marcelop
 * @since 1.0.1
 */
public interface IHyadesTestArbiter
{
	/**
	 * Returns the verdict event for a the associated test suite.  This
	 * method is invoked at the end of the execution of the test suite.
	 * 
	 * @param testSuite.  The test suite this arbiter should generate verdict
	 * for.
	 * 
	 * @param successes.  An unmodifiable collection with the associated test suite's 
	 * test cases that have succeed.  All test cases are instances of {@link IHyadesTest}.
	 * 
	 * @param errors.  An unmodifiable collection with the associated test suite's test cases
	 * that have ended because of an error.  All test cases are instances of
	 * {@link IHyadesTest}.
	 * 
	 * @param failures.  An unmodifiable collection with the associated test suite's test cases
	 * that have ended because of a failure. All test cases are instances of
	 * {@link IHyadesTest}.
	 * 
	 * @return VerdictEvent
	 */
	public VerdictEvent analyse(TestSuite testSuite, Collection successes, Collection errors, Collection failures, String errorCauses, String failureCauses); 
}
