/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Correlation Container</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This is a root in a correlation instance resource. For example the correlation instance is created when a correlation operation/action is used or by the loaders when an AssciationEngine event is received.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationContainer#getCorrelations <em>Correlations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationContainer#getCorrelationContainerProxy <em>Correlation Container Proxy</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationContainer()
 * @model 
 * @generated
 */
public interface CorrelationContainer extends EObject{
	/**
	 * Returns the value of the '<em><b>Correlations</b></em>' map.
	 * The key is of type {@link org.eclipse.emf.ecore.EObject},
	 * and the value is of type list of {@link org.eclipse.emf.ecore.EObject},
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Correlations</em>' map isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Correlations</em>' map.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationContainer_Correlations()
	 * @model mapType="org.eclipse.hyades.models.hierarchy.CorrelationEntry" keyType="org.eclipse.emf.ecore.EObject" valueType="org.eclipse.emf.ecore.EObject"
	 * @generated
	 */
	EMap getCorrelations();

	/**
	 * Returns the value of the '<em><b>Correlation Container Proxy</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCorrelationContainer <em>Correlation Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Correlation Container Proxy</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Correlation Container Proxy</em>' reference.
	 * @see #setCorrelationContainerProxy(CorrelationContainerProxy)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationContainer_CorrelationContainerProxy()
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCorrelationContainer
	 * @model opposite="correlationContainer"
	 * @generated
	 */
	CorrelationContainerProxy getCorrelationContainerProxy();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainer#getCorrelationContainerProxy <em>Correlation Container Proxy</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Correlation Container Proxy</em>' reference.
	 * @see #getCorrelationContainerProxy()
	 * @generated
	 */
	void setCorrelationContainerProxy(CorrelationContainerProxy value);

} // CorrelationContainer
