package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * JUnit test case for the <code>DependencySituationImpl</code> class.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1 
 */
public class DependencySituationImplTest extends TestCase {

    /** Target instance for the tests. */
    private DependencySituation sit;

    /**
     * Constructor for DependencySituationImplTest.
     * @param testcase
     */
    public DependencySituationImplTest(String testcase) {
        super(testcase);
    }

    /**
     * Tests whether <code>toString</code> doesn't blow up.
     */
    public void testToString() {
        assertNotNull(sit.toString());
    }

    /**
     * Tests presence of attributes in the public interface
     */
    public void testInterface() {
        sit.getDependencyDisposition();
        sit.getReasoningScope();
        // setters show on other tests

        assertTrue(sit instanceof SituationType);
    }

    /**
     * Tests the serialization for <code>DependencySituation</code>.
     */
    public void testSerialization() {
        Util.testEObjectSerialization(sit);
    }

    /**
     * Tests the <code>equals</code> operator.
     */
    public void testEquals() {
        DependencySituation sit2 = (DependencySituation) Util.clone(sit);
        assertEquals(sit, sit2);

        sit.setDependencyDisposition("d");
        sit.setReasoningScope("r");
        sit2 = (DependencySituation) Util.clone(sit);
        assertEquals(sit, sit2);

        sit2.setDependencyDisposition("difference");
        assertFalse(sit.equals(sit2));
    }

    /**
     * Tests validation for <code>DependencySituation</code>.
     */
    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(sit, "all");

        sit.setDependencyDisposition("d");
        sit.setReasoningScope("r");
        sit.validate();

        sit.setDependencyDisposition(null);
        Util.assertMissingAttributes(sit, "dependencyDisposition");

        sit.setDependencyDisposition("d");
        sit.setReasoningScope(null);
        Util.assertMissingAttributes(sit, "reasoningScope");
    }

    /**
     * Tests validation for <code>DependencySituation</code>.
     */
    public void testValidationInvalidLengths() {
        sit.setDependencyDisposition(Util.getPaddedString(64));
        sit.setReasoningScope(Util.getPaddedString(64));
        try {
            sit.validate();
        }
        catch (ValidationException e) {
            fail("Strings have correct length");
        }

        sit.setDependencyDisposition(Util.getPaddedString(65));
        sit.setReasoningScope(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(sit, "dependencyDisposition");

        sit.setDependencyDisposition(Util.getPaddedString(64));
        sit.setReasoningScope(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(sit, "reasoningScope");
    }

    /**
     * 
     */
    public void testAdapter() {
        Util.assertAdapterNotification(sit);
    }

    /**
     * 
     */
    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(sit);
    }

    /*
     * Protected methods.
     */

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eFx = EventFactory.eINSTANCE;
        sit = eFx.createDependencySituation();

    }

}
