package org.eclipse.hyades.logging.events.cbe.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.util.EventMessages;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 *
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class CompletionExceptionTest extends TestCase {
    /**
     * Constructor for CompletionExceptionTest.
     * @param arg0
     */
    public CompletionExceptionTest(String arg0) {
        super(arg0);
    }

    /*
     * Test for void CompletionException()
     */
    public void testCompletionException() {
        new CompletionException();
    }

    /*
     * Test for void CompletionException(String)
     */
    public void testCompletionExceptionString() {
        String msg = "test";
        CompletionException e = new CompletionException(msg);
        assertEquals(msg, e.getMessage());
    }

    /*
     * Test for void CompletionException(String, String)
     */
    public void testCompletionExceptionStringString() {
        CompletionException e = new CompletionException(EventMessages.LOG_INVALID_JNDI_REFERENCE_EXC_, EventMessages.CLASS_NAME);

        EventExceptionTest.assertExceptionMsg(e, EventMessages.LOG_INVALID_JNDI_REFERENCE_EXC_, null);
    }

    /*
     * Test for void CompletionException(String, String, Object[])
     */
    public void testCompletionExceptionStringStringObjectArray() {
        Object[] params = new Object[] { "a" };
        String msgKey = EventMessages.LOG_INVALID_JNDI_REFERENCE_EXC_;
        CompletionException e = new CompletionException(msgKey, EventMessages.CLASS_NAME, params);
        EventExceptionTest.assertExceptionMsg(e, msgKey, params);
    }

    /*
     * Test for void CompletionException(String, String, Object[], Throwable)
     */
    public void testCompletionExceptionStringStringObjectArrayThrowable() {
        Object[] params = new Object[] { "a" };
        String msgKey = EventMessages.LOG_INVALID_JNDI_REFERENCE_EXC_;
        Exception linkedException = new Exception();
        CompletionException e = new CompletionException(msgKey, EventMessages.CLASS_NAME, params, linkedException);
        EventExceptionTest.assertExceptionMsg(e, msgKey, params);
        assertEquals(linkedException, e.getCause());
    }

}
