/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
package org.eclipse.hyades.models.common.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>CFG Category Selection Multiplicity</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGCategorySelectionMultiplicity()
 * @model
 * @generated
 */
public final class CFGCategorySelectionMultiplicity extends AbstractEnumerator {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The '<em><b>Zero</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ZERO_LITERAL
	 * @model name="zero"
	 * @generated
	 * @ordered
	 */
	public static final int ZERO = 0;

	/**
	 * The '<em><b>Zero To One</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ZERO_TO_ONE_LITERAL
	 * @model name="zeroToOne"
	 * @generated
	 * @ordered
	 */
	public static final int ZERO_TO_ONE = 1;

	/**
	 * The '<em><b>Zero To N</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ZERO_TO_N_LITERAL
	 * @model name="zeroToN"
	 * @generated
	 * @ordered
	 */
	public static final int ZERO_TO_N = 2;

	/**
	 * The '<em><b>Zero To Many</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ZERO_TO_MANY_LITERAL
	 * @model name="zeroToMany"
	 * @generated
	 * @ordered
	 */
	public static final int ZERO_TO_MANY = 3;

	/**
	 * The '<em><b>One</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ONE_LITERAL
	 * @model name="one"
	 * @generated
	 * @ordered
	 */
	public static final int ONE = 4;

	/**
	 * The '<em><b>One To N</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ONE_TO_N_LITERAL
	 * @model name="oneToN"
	 * @generated
	 * @ordered
	 */
	public static final int ONE_TO_N = 5;

	/**
	 * The '<em><b>One To Many</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ONE_TO_MANY_LITERAL
	 * @model name="oneToMany"
	 * @generated
	 * @ordered
	 */
	public static final int ONE_TO_MANY = 6;

	/**
	 * The '<em><b>N</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #N_LITERAL
	 * @model name="n"
	 * @generated
	 * @ordered
	 */
	public static final int N = 7;

	/**
	 * The '<em><b>Zero</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Zero</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ZERO
	 * @generated
	 * @ordered
	 */
	public static final CFGCategorySelectionMultiplicity ZERO_LITERAL = new CFGCategorySelectionMultiplicity(ZERO, "zero");

	/**
	 * The '<em><b>Zero To One</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Zero To One</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ZERO_TO_ONE
	 * @generated
	 * @ordered
	 */
	public static final CFGCategorySelectionMultiplicity ZERO_TO_ONE_LITERAL = new CFGCategorySelectionMultiplicity(ZERO_TO_ONE, "zeroToOne");

	/**
	 * The '<em><b>Zero To N</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Zero To N</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ZERO_TO_N
	 * @generated
	 * @ordered
	 */
	public static final CFGCategorySelectionMultiplicity ZERO_TO_N_LITERAL = new CFGCategorySelectionMultiplicity(ZERO_TO_N, "zeroToN");

	/**
	 * The '<em><b>Zero To Many</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Zero To Many</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ZERO_TO_MANY
	 * @generated
	 * @ordered
	 */
	public static final CFGCategorySelectionMultiplicity ZERO_TO_MANY_LITERAL = new CFGCategorySelectionMultiplicity(ZERO_TO_MANY, "zeroToMany");

	/**
	 * The '<em><b>One</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>One</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ONE
	 * @generated
	 * @ordered
	 */
	public static final CFGCategorySelectionMultiplicity ONE_LITERAL = new CFGCategorySelectionMultiplicity(ONE, "one");

	/**
	 * The '<em><b>One To N</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>One To N</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ONE_TO_N
	 * @generated
	 * @ordered
	 */
	public static final CFGCategorySelectionMultiplicity ONE_TO_N_LITERAL = new CFGCategorySelectionMultiplicity(ONE_TO_N, "oneToN");

	/**
	 * The '<em><b>One To Many</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>One To Many</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ONE_TO_MANY
	 * @generated
	 * @ordered
	 */
	public static final CFGCategorySelectionMultiplicity ONE_TO_MANY_LITERAL = new CFGCategorySelectionMultiplicity(ONE_TO_MANY, "oneToMany");

	/**
	 * The '<em><b>N</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>N</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #N
	 * @generated
	 * @ordered
	 */
	public static final CFGCategorySelectionMultiplicity N_LITERAL = new CFGCategorySelectionMultiplicity(N, "n");

	/**
	 * An array of all the '<em><b>CFG Category Selection Multiplicity</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final CFGCategorySelectionMultiplicity[] VALUES_ARRAY =
		new CFGCategorySelectionMultiplicity[] {
			ZERO_LITERAL,
			ZERO_TO_ONE_LITERAL,
			ZERO_TO_N_LITERAL,
			ZERO_TO_MANY_LITERAL,
			ONE_LITERAL,
			ONE_TO_N_LITERAL,
			ONE_TO_MANY_LITERAL,
			N_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>CFG Category Selection Multiplicity</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>CFG Category Selection Multiplicity</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static CFGCategorySelectionMultiplicity get(String name)
	{
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			CFGCategorySelectionMultiplicity result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>CFG Category Selection Multiplicity</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static CFGCategorySelectionMultiplicity get(int value)
	{
		switch (value) {
			case ZERO: return ZERO_LITERAL;
			case ZERO_TO_ONE: return ZERO_TO_ONE_LITERAL;
			case ZERO_TO_N: return ZERO_TO_N_LITERAL;
			case ZERO_TO_MANY: return ZERO_TO_MANY_LITERAL;
			case ONE: return ONE_LITERAL;
			case ONE_TO_N: return ONE_TO_N_LITERAL;
			case ONE_TO_MANY: return ONE_TO_MANY_LITERAL;
			case N: return N_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private CFGCategorySelectionMultiplicity(int value, String name)
	{
		super(value, name);
	}

} //CFGCategorySelectionMultiplicity
