/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Property Group</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGPropertyGroupImpl#getPropertyGroupID <em>Property Group ID</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGPropertyGroupImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGPropertyGroupImpl#getDefiningProperty <em>Defining Property</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGPropertyGroupImpl#getConfigurableObject <em>Configurable Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CFGPropertyGroupImpl extends CMNNamedElementImpl implements CFGPropertyGroup {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The default value of the '{@link #getPropertyGroupID() <em>Property Group ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPropertyGroupID()
	 * @generated
	 * @ordered
	 */
	protected static final String PROPERTY_GROUP_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPropertyGroupID() <em>Property Group ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPropertyGroupID()
	 * @generated
	 * @ordered
	 */
	protected String propertyGroupID = PROPERTY_GROUP_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EList properties = null;

	/**
	 * The cached value of the '{@link #getDefiningProperty() <em>Defining Property</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefiningProperty()
	 * @generated
	 * @ordered
	 */
	protected CFGComparableProperty definingProperty = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CFGPropertyGroupImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPropertyGroupID()
	{
		return propertyGroupID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPropertyGroupID(String newPropertyGroupID)
	{
		String oldPropertyGroupID = propertyGroupID;
		propertyGroupID = newPropertyGroupID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTY_GROUP_ID, oldPropertyGroupID, propertyGroupID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getProperties()
	{
		if (properties == null) {
			properties = new EObjectContainmentEList(CFGComparableProperty.class, this, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGComparableProperty getDefiningProperty()
	{
		if (definingProperty != null && definingProperty.eIsProxy()) {
			CFGComparableProperty oldDefiningProperty = definingProperty;
			definingProperty = (CFGComparableProperty)EcoreUtil.resolve(definingProperty, this);
			if (definingProperty != oldDefiningProperty) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY, oldDefiningProperty, definingProperty));
			}
		}
		return definingProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGComparableProperty basicGetDefiningProperty()
	{
		return definingProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefiningProperty(CFGComparableProperty newDefiningProperty)
	{
		CFGComparableProperty oldDefiningProperty = definingProperty;
		definingProperty = newDefiningProperty;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY, oldDefiningProperty, definingProperty));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGConfigurableObject getConfigurableObject()
	{
		if (eContainerFeatureID != Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT) return null;
		return (CFGConfigurableObject)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfigurableObject(CFGConfigurableObject newConfigurableObject)
	{
		if (newConfigurableObject != eContainer || (eContainerFeatureID != Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT && newConfigurableObject != null)) {
			if (EcoreUtil.isAncestor(this, newConfigurableObject))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newConfigurableObject != null)
				msgs = ((InternalEObject)newConfigurableObject).eInverseAdd(this, Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS, CFGConfigurableObject.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newConfigurableObject, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT, newConfigurableObject, newConfigurableObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES:
					return ((InternalEList)getProperties()).basicRemove(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
					return eBasicSetContainer(null, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS, CFGConfigurableObject.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__ID:
				return getId();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DESCRIPTION:
				return getDescription();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__NAME:
				return getName();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTY_GROUP_ID:
				return getPropertyGroupID();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES:
				return getProperties();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY:
				if (resolve) return getDefiningProperty();
				return basicGetDefiningProperty();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				return getConfigurableObject();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__ID:
				setId((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__NAME:
				setName((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTY_GROUP_ID:
				setPropertyGroupID((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection)newValue);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY:
				setDefiningProperty((CFGComparableProperty)newValue);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				setConfigurableObject((CFGConfigurableObject)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTY_GROUP_ID:
				setPropertyGroupID(PROPERTY_GROUP_ID_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES:
				getProperties().clear();
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY:
				setDefiningProperty((CFGComparableProperty)null);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				setConfigurableObject((CFGConfigurableObject)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTY_GROUP_ID:
				return PROPERTY_GROUP_ID_EDEFAULT == null ? propertyGroupID != null : !PROPERTY_GROUP_ID_EDEFAULT.equals(propertyGroupID);
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY:
				return definingProperty != null;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				return getConfigurableObject() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (propertyGroupID: ");
		result.append(propertyGroupID);
		result.append(')');
		return result.toString();
	}

} //CFGPropertyGroupImpl
