/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.models.common.configuration.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.common.configuration.CFGCategory;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayWidthEnumeration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Hyades Display Width Enumeration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.HyadesDisplayWidthEnumerationImpl#getDW_1 <em>DW 1</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.HyadesDisplayWidthEnumerationImpl#getDW_2 <em>DW 2</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.HyadesDisplayWidthEnumerationImpl#getDW_3 <em>DW 3</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.HyadesDisplayWidthEnumerationImpl#getDW_4 <em>DW 4</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.HyadesDisplayWidthEnumerationImpl#getDW_5 <em>DW 5</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.HyadesDisplayWidthEnumerationImpl#getDW_6 <em>DW 6</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.HyadesDisplayWidthEnumerationImpl#getDW_7 <em>DW 7</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.HyadesDisplayWidthEnumerationImpl#getDW_8 <em>DW 8</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class HyadesDisplayWidthEnumerationImpl extends CFGPsudoEnumerationImpl implements HyadesDisplayWidthEnumeration {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The default value of the '{@link #getDW_1() <em>DW 1</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_1()
	 * @generated
	 * @ordered
	 */
	protected static final String DW_1_EDEFAULT = "640";

	/**
	 * The cached value of the '{@link #getDW_1() <em>DW 1</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_1()
	 * @generated
	 * @ordered
	 */
	protected String dW_1 = DW_1_EDEFAULT;

	/**
	 * The default value of the '{@link #getDW_2() <em>DW 2</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_2()
	 * @generated
	 * @ordered
	 */
	protected static final String DW_2_EDEFAULT = "800";

	/**
	 * The cached value of the '{@link #getDW_2() <em>DW 2</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_2()
	 * @generated
	 * @ordered
	 */
	protected String dW_2 = DW_2_EDEFAULT;

	/**
	 * The default value of the '{@link #getDW_3() <em>DW 3</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_3()
	 * @generated
	 * @ordered
	 */
	protected static final String DW_3_EDEFAULT = "1024";

	/**
	 * The cached value of the '{@link #getDW_3() <em>DW 3</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_3()
	 * @generated
	 * @ordered
	 */
	protected String dW_3 = DW_3_EDEFAULT;

	/**
	 * The default value of the '{@link #getDW_4() <em>DW 4</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_4()
	 * @generated
	 * @ordered
	 */
	protected static final String DW_4_EDEFAULT = "1280";

	/**
	 * The cached value of the '{@link #getDW_4() <em>DW 4</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_4()
	 * @generated
	 * @ordered
	 */
	protected String dW_4 = DW_4_EDEFAULT;

	/**
	 * The default value of the '{@link #getDW_5() <em>DW 5</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_5()
	 * @generated
	 * @ordered
	 */
	protected static final String DW_5_EDEFAULT = "1400";

	/**
	 * The cached value of the '{@link #getDW_5() <em>DW 5</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_5()
	 * @generated
	 * @ordered
	 */
	protected String dW_5 = DW_5_EDEFAULT;

	/**
	 * The default value of the '{@link #getDW_6() <em>DW 6</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_6()
	 * @generated
	 * @ordered
	 */
	protected static final String DW_6_EDEFAULT = "1600";

	/**
	 * The cached value of the '{@link #getDW_6() <em>DW 6</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_6()
	 * @generated
	 * @ordered
	 */
	protected String dW_6 = DW_6_EDEFAULT;

	/**
	 * The default value of the '{@link #getDW_7() <em>DW 7</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_7()
	 * @generated
	 * @ordered
	 */
	protected static final String DW_7_EDEFAULT = "1920";

	/**
	 * The cached value of the '{@link #getDW_7() <em>DW 7</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_7()
	 * @generated
	 * @ordered
	 */
	protected String dW_7 = DW_7_EDEFAULT;

	/**
	 * The default value of the '{@link #getDW_8() <em>DW 8</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_8()
	 * @generated
	 * @ordered
	 */
	protected static final String DW_8_EDEFAULT = "2048";

	/**
	 * The cached value of the '{@link #getDW_8() <em>DW 8</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDW_8()
	 * @generated
	 * @ordered
	 */
	protected String dW_8 = DW_8_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected HyadesDisplayWidthEnumerationImpl()
	{
		super();
		this.setCategory(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayWidthCategory());				
		this.getValues().add(dW_1);
		this.getValues().add(dW_2);
		this.getValues().add(dW_3);
		this.getValues().add(dW_4);
		this.getValues().add(dW_5);
		this.getValues().add(dW_6);
		this.getValues().add(dW_7);
		this.getValues().add(dW_8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_ConfigurationPackage.eINSTANCE.getHyadesDisplayWidthEnumeration();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDW_1()
	{
		return dW_1;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDW_1(String newDW_1)
	{
		String oldDW_1 = dW_1;
		dW_1 = newDW_1;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_1, oldDW_1, dW_1));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDW_2()
	{
		return dW_2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDW_2(String newDW_2)
	{
		String oldDW_2 = dW_2;
		dW_2 = newDW_2;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_2, oldDW_2, dW_2));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDW_3()
	{
		return dW_3;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDW_3(String newDW_3)
	{
		String oldDW_3 = dW_3;
		dW_3 = newDW_3;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_3, oldDW_3, dW_3));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDW_4()
	{
		return dW_4;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDW_4(String newDW_4)
	{
		String oldDW_4 = dW_4;
		dW_4 = newDW_4;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_4, oldDW_4, dW_4));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDW_5()
	{
		return dW_5;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDW_5(String newDW_5)
	{
		String oldDW_5 = dW_5;
		dW_5 = newDW_5;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_5, oldDW_5, dW_5));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDW_6()
	{
		return dW_6;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDW_6(String newDW_6)
	{
		String oldDW_6 = dW_6;
		dW_6 = newDW_6;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_6, oldDW_6, dW_6));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDW_7()
	{
		return dW_7;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDW_7(String newDW_7)
	{
		String oldDW_7 = dW_7;
		dW_7 = newDW_7;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_7, oldDW_7, dW_7));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDW_8()
	{
		return dW_8;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDW_8(String newDW_8)
	{
		String oldDW_8 = dW_8;
		dW_8 = newDW_8;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_8, oldDW_8, dW_8));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__CATEGORY:
					return basicSetCategory(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__VALUES:
				return getValues();
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__CATEGORY:
				return getCategory();
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_1:
				return getDW_1();
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_2:
				return getDW_2();
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_3:
				return getDW_3();
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_4:
				return getDW_4();
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_5:
				return getDW_5();
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_6:
				return getDW_6();
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_7:
				return getDW_7();
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_8:
				return getDW_8();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__VALUES:
				getValues().clear();
				getValues().addAll((Collection)newValue);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__CATEGORY:
				setCategory((CFGCategory)newValue);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_1:
				setDW_1((String)newValue);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_2:
				setDW_2((String)newValue);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_3:
				setDW_3((String)newValue);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_4:
				setDW_4((String)newValue);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_5:
				setDW_5((String)newValue);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_6:
				setDW_6((String)newValue);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_7:
				setDW_7((String)newValue);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_8:
				setDW_8((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__VALUES:
				getValues().clear();
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__CATEGORY:
				setCategory((CFGCategory)null);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_1:
				setDW_1(DW_1_EDEFAULT);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_2:
				setDW_2(DW_2_EDEFAULT);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_3:
				setDW_3(DW_3_EDEFAULT);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_4:
				setDW_4(DW_4_EDEFAULT);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_5:
				setDW_5(DW_5_EDEFAULT);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_6:
				setDW_6(DW_6_EDEFAULT);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_7:
				setDW_7(DW_7_EDEFAULT);
				return;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_8:
				setDW_8(DW_8_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__VALUES:
				return values != null && !values.isEmpty();
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__CATEGORY:
				return category != null;
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_1:
				return DW_1_EDEFAULT == null ? dW_1 != null : !DW_1_EDEFAULT.equals(dW_1);
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_2:
				return DW_2_EDEFAULT == null ? dW_2 != null : !DW_2_EDEFAULT.equals(dW_2);
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_3:
				return DW_3_EDEFAULT == null ? dW_3 != null : !DW_3_EDEFAULT.equals(dW_3);
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_4:
				return DW_4_EDEFAULT == null ? dW_4 != null : !DW_4_EDEFAULT.equals(dW_4);
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_5:
				return DW_5_EDEFAULT == null ? dW_5 != null : !DW_5_EDEFAULT.equals(dW_5);
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_6:
				return DW_6_EDEFAULT == null ? dW_6 != null : !DW_6_EDEFAULT.equals(dW_6);
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_7:
				return DW_7_EDEFAULT == null ? dW_7 != null : !DW_7_EDEFAULT.equals(dW_7);
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION__DW_8:
				return DW_8_EDEFAULT == null ? dW_8 != null : !DW_8_EDEFAULT.equals(dW_8);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (DW_1: ");
		result.append(dW_1);
		result.append(", DW_2: ");
		result.append(dW_2);
		result.append(", DW_3: ");
		result.append(dW_3);
		result.append(", DW_4: ");
		result.append(dW_4);
		result.append(", DW_5: ");
		result.append(dW_5);
		result.append(", DW_6: ");
		result.append(dW_6);
		result.append(", DW_7: ");
		result.append(dW_7);
		result.append(", DW_8: ");
		result.append(dW_8);
		result.append(')');
		return result.toString();
	}

} //HyadesDisplayWidthEnumerationImpl
