/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.common.CMNNodeInstance;
import org.eclipse.hyades.models.common.common.CMNNodeType;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGCategory;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachine;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.CFGMachineInstance;
import org.eclipse.hyades.models.common.configuration.CFGOperation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.CFGPsudoEnumeration;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.configuration.HyadesBrowserEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesBrowserTypeCategory;
import org.eclipse.hyades.models.common.configuration.HyadesBrowserVersionCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDatabaseCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDatabaseEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesDatabaseVersionCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayColorDepthCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayColorDepthEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayHeightCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayHeightEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayNumberCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayWidthCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayWidthEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesHostnameCategory;
import org.eclipse.hyades.models.common.configuration.HyadesMajorVersionCategory;
import org.eclipse.hyades.models.common.configuration.HyadesMemorySizeCategory;
import org.eclipse.hyades.models.common.configuration.HyadesMinorVersionCategory;
import org.eclipse.hyades.models.common.configuration.HyadesOperatingSystemCategory;
import org.eclipse.hyades.models.common.configuration.HyadesOperatingSystemEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesPasswordCategory;
import org.eclipse.hyades.models.common.configuration.HyadesProcessorNumberCategory;
import org.eclipse.hyades.models.common.configuration.HyadesProcessorSpeedCategory;
import org.eclipse.hyades.models.common.configuration.HyadesProcessorTypeCategory;
import org.eclipse.hyades.models.common.configuration.HyadesProcessorTypeEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesServicePackCategory;
import org.eclipse.hyades.models.common.configuration.HyadesServicePackEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesUsernameCategory;
import org.eclipse.hyades.models.common.configuration.HyadesWindowsDomainCategory;
import org.eclipse.hyades.models.common.interactions.BVRProperty;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage
 * @generated
 */
public class Common_ConfigurationSwitch {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static Common_ConfigurationPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Common_ConfigurationSwitch()
	{
		if (modelPackage == null) {
			modelPackage = Common_ConfigurationPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject)
	{
		EClass theEClass = theEObject.eClass();
		if (theEClass.eContainer() == modelPackage) {
			switch (theEClass.getClassifierID()) {
				case Common_ConfigurationPackage.CFG_LOCATION: {
					CFGLocation cfgLocation = (CFGLocation)theEObject;
					Object result = caseCFGLocation(cfgLocation);
					if (result == null) result = caseCFGConfigurableObject(cfgLocation);
					if (result == null) result = caseCMNNamedElement(cfgLocation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_OPERATION: {
					CFGOperation cfgOperation = (CFGOperation)theEObject;
					Object result = caseCFGOperation(cfgOperation);
					if (result == null) result = caseCMNNamedElement(cfgOperation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_ARTIFACT: {
					CFGArtifact cfgArtifact = (CFGArtifact)theEObject;
					Object result = caseCFGArtifact(cfgArtifact);
					if (result == null) result = caseCFGConfigurableObject(cfgArtifact);
					if (result == null) result = caseCMNNamedElement(cfgArtifact);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_INSTANCE: {
					CFGInstance cfgInstance = (CFGInstance)theEObject;
					Object result = caseCFGInstance(cfgInstance);
					if (result == null) result = caseCMNNamedElement(cfgInstance);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_COMPARABLE_PROPERTY: {
					CFGComparableProperty cfgComparableProperty = (CFGComparableProperty)theEObject;
					Object result = caseCFGComparableProperty(cfgComparableProperty);
					if (result == null) result = caseBVRProperty(cfgComparableProperty);
					if (result == null) result = caseCMNNamedElement(cfgComparableProperty);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_PROPERTY_GROUP: {
					CFGPropertyGroup cfgPropertyGroup = (CFGPropertyGroup)theEObject;
					Object result = caseCFGPropertyGroup(cfgPropertyGroup);
					if (result == null) result = caseCMNNamedElement(cfgPropertyGroup);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_OPERATING_SYSTEM_ENUMERATION: {
					HyadesOperatingSystemEnumeration hyadesOperatingSystemEnumeration = (HyadesOperatingSystemEnumeration)theEObject;
					Object result = caseHyadesOperatingSystemEnumeration(hyadesOperatingSystemEnumeration);
					if (result == null) result = caseCFGPsudoEnumeration(hyadesOperatingSystemEnumeration);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_OPERATING_SYSTEM_CATEGORY: {
					HyadesOperatingSystemCategory hyadesOperatingSystemCategory = (HyadesOperatingSystemCategory)theEObject;
					Object result = caseHyadesOperatingSystemCategory(hyadesOperatingSystemCategory);
					if (result == null) result = caseCFGCategory(hyadesOperatingSystemCategory);
					if (result == null) result = caseCMNNamedElement(hyadesOperatingSystemCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_PROCESSOR_TYPE_CATEGORY: {
					HyadesProcessorTypeCategory hyadesProcessorTypeCategory = (HyadesProcessorTypeCategory)theEObject;
					Object result = caseHyadesProcessorTypeCategory(hyadesProcessorTypeCategory);
					if (result == null) result = caseCFGCategory(hyadesProcessorTypeCategory);
					if (result == null) result = caseCMNNamedElement(hyadesProcessorTypeCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_MEMORY_SIZE_CATEGORY: {
					HyadesMemorySizeCategory hyadesMemorySizeCategory = (HyadesMemorySizeCategory)theEObject;
					Object result = caseHyadesMemorySizeCategory(hyadesMemorySizeCategory);
					if (result == null) result = caseCFGCategory(hyadesMemorySizeCategory);
					if (result == null) result = caseCMNNamedElement(hyadesMemorySizeCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_PROCESSOR_SPEED_CATEGORY: {
					HyadesProcessorSpeedCategory hyadesProcessorSpeedCategory = (HyadesProcessorSpeedCategory)theEObject;
					Object result = caseHyadesProcessorSpeedCategory(hyadesProcessorSpeedCategory);
					if (result == null) result = caseCFGCategory(hyadesProcessorSpeedCategory);
					if (result == null) result = caseCMNNamedElement(hyadesProcessorSpeedCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_PROCESSOR_TYPE_ENUMERATION: {
					HyadesProcessorTypeEnumeration hyadesProcessorTypeEnumeration = (HyadesProcessorTypeEnumeration)theEObject;
					Object result = caseHyadesProcessorTypeEnumeration(hyadesProcessorTypeEnumeration);
					if (result == null) result = caseCFGPsudoEnumeration(hyadesProcessorTypeEnumeration);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_BROWSER_TYPE_CATEGORY: {
					HyadesBrowserTypeCategory hyadesBrowserTypeCategory = (HyadesBrowserTypeCategory)theEObject;
					Object result = caseHyadesBrowserTypeCategory(hyadesBrowserTypeCategory);
					if (result == null) result = caseCFGCategory(hyadesBrowserTypeCategory);
					if (result == null) result = caseCMNNamedElement(hyadesBrowserTypeCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_BROWSER_VERSION_CATEGORY: {
					HyadesBrowserVersionCategory hyadesBrowserVersionCategory = (HyadesBrowserVersionCategory)theEObject;
					Object result = caseHyadesBrowserVersionCategory(hyadesBrowserVersionCategory);
					if (result == null) result = caseCFGCategory(hyadesBrowserVersionCategory);
					if (result == null) result = caseCMNNamedElement(hyadesBrowserVersionCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_BROWSER_ENUMERATION: {
					HyadesBrowserEnumeration hyadesBrowserEnumeration = (HyadesBrowserEnumeration)theEObject;
					Object result = caseHyadesBrowserEnumeration(hyadesBrowserEnumeration);
					if (result == null) result = caseCFGPsudoEnumeration(hyadesBrowserEnumeration);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_PROCESSOR_NUMBER_CATEGORY: {
					HyadesProcessorNumberCategory hyadesProcessorNumberCategory = (HyadesProcessorNumberCategory)theEObject;
					Object result = caseHyadesProcessorNumberCategory(hyadesProcessorNumberCategory);
					if (result == null) result = caseCFGCategory(hyadesProcessorNumberCategory);
					if (result == null) result = caseCMNNamedElement(hyadesProcessorNumberCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_DISPLAY_COLOR_DEPTH_CATEGORY: {
					HyadesDisplayColorDepthCategory hyadesDisplayColorDepthCategory = (HyadesDisplayColorDepthCategory)theEObject;
					Object result = caseHyadesDisplayColorDepthCategory(hyadesDisplayColorDepthCategory);
					if (result == null) result = caseCFGCategory(hyadesDisplayColorDepthCategory);
					if (result == null) result = caseCMNNamedElement(hyadesDisplayColorDepthCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_DISPLAY_COLOR_DEPTH_ENUMERATION: {
					HyadesDisplayColorDepthEnumeration hyadesDisplayColorDepthEnumeration = (HyadesDisplayColorDepthEnumeration)theEObject;
					Object result = caseHyadesDisplayColorDepthEnumeration(hyadesDisplayColorDepthEnumeration);
					if (result == null) result = caseCFGPsudoEnumeration(hyadesDisplayColorDepthEnumeration);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_DISPLAY_HEIGHT_CATEGORY: {
					HyadesDisplayHeightCategory hyadesDisplayHeightCategory = (HyadesDisplayHeightCategory)theEObject;
					Object result = caseHyadesDisplayHeightCategory(hyadesDisplayHeightCategory);
					if (result == null) result = caseCFGCategory(hyadesDisplayHeightCategory);
					if (result == null) result = caseCMNNamedElement(hyadesDisplayHeightCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_CATEGORY: {
					HyadesDisplayWidthCategory hyadesDisplayWidthCategory = (HyadesDisplayWidthCategory)theEObject;
					Object result = caseHyadesDisplayWidthCategory(hyadesDisplayWidthCategory);
					if (result == null) result = caseCFGCategory(hyadesDisplayWidthCategory);
					if (result == null) result = caseCMNNamedElement(hyadesDisplayWidthCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_DISPLAY_HEIGHT_ENUMERATION: {
					HyadesDisplayHeightEnumeration hyadesDisplayHeightEnumeration = (HyadesDisplayHeightEnumeration)theEObject;
					Object result = caseHyadesDisplayHeightEnumeration(hyadesDisplayHeightEnumeration);
					if (result == null) result = caseCFGPsudoEnumeration(hyadesDisplayHeightEnumeration);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION: {
					HyadesDisplayWidthEnumeration hyadesDisplayWidthEnumeration = (HyadesDisplayWidthEnumeration)theEObject;
					Object result = caseHyadesDisplayWidthEnumeration(hyadesDisplayWidthEnumeration);
					if (result == null) result = caseCFGPsudoEnumeration(hyadesDisplayWidthEnumeration);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_DISPLAY_NUMBER_CATEGORY: {
					HyadesDisplayNumberCategory hyadesDisplayNumberCategory = (HyadesDisplayNumberCategory)theEObject;
					Object result = caseHyadesDisplayNumberCategory(hyadesDisplayNumberCategory);
					if (result == null) result = caseCFGCategory(hyadesDisplayNumberCategory);
					if (result == null) result = caseCMNNamedElement(hyadesDisplayNumberCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_DATABASE_CATEGORY: {
					HyadesDatabaseCategory hyadesDatabaseCategory = (HyadesDatabaseCategory)theEObject;
					Object result = caseHyadesDatabaseCategory(hyadesDatabaseCategory);
					if (result == null) result = caseCFGCategory(hyadesDatabaseCategory);
					if (result == null) result = caseCMNNamedElement(hyadesDatabaseCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_DATABASE_VERSION_CATEGORY: {
					HyadesDatabaseVersionCategory hyadesDatabaseVersionCategory = (HyadesDatabaseVersionCategory)theEObject;
					Object result = caseHyadesDatabaseVersionCategory(hyadesDatabaseVersionCategory);
					if (result == null) result = caseCFGCategory(hyadesDatabaseVersionCategory);
					if (result == null) result = caseCMNNamedElement(hyadesDatabaseVersionCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_DATABASE_ENUMERATION: {
					HyadesDatabaseEnumeration hyadesDatabaseEnumeration = (HyadesDatabaseEnumeration)theEObject;
					Object result = caseHyadesDatabaseEnumeration(hyadesDatabaseEnumeration);
					if (result == null) result = caseCFGPsudoEnumeration(hyadesDatabaseEnumeration);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_MACHINE_INSTANCE: {
					CFGMachineInstance cfgMachineInstance = (CFGMachineInstance)theEObject;
					Object result = caseCFGMachineInstance(cfgMachineInstance);
					if (result == null) result = caseCMNNodeInstance(cfgMachineInstance);
					if (result == null) result = caseCFGLocation(cfgMachineInstance);
					if (result == null) result = caseCFGConfigurableObject(cfgMachineInstance);
					if (result == null) result = caseCMNNamedElement(cfgMachineInstance);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_MACHINE_CONSTRAINT: {
					CFGMachineConstraint cfgMachineConstraint = (CFGMachineConstraint)theEObject;
					Object result = caseCFGMachineConstraint(cfgMachineConstraint);
					if (result == null) result = caseCMNNodeType(cfgMachineConstraint);
					if (result == null) result = caseCFGLocation(cfgMachineConstraint);
					if (result == null) result = caseCFGConfigurableObject(cfgMachineConstraint);
					if (result == null) result = caseCMNNamedElement(cfgMachineConstraint);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT: {
					CFGConfigurableObject cfgConfigurableObject = (CFGConfigurableObject)theEObject;
					Object result = caseCFGConfigurableObject(cfgConfigurableObject);
					if (result == null) result = caseCMNNamedElement(cfgConfigurableObject);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_HOSTNAME_CATEGORY: {
					HyadesHostnameCategory hyadesHostnameCategory = (HyadesHostnameCategory)theEObject;
					Object result = caseHyadesHostnameCategory(hyadesHostnameCategory);
					if (result == null) result = caseCFGCategory(hyadesHostnameCategory);
					if (result == null) result = caseCMNNamedElement(hyadesHostnameCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_WINDOWS_DOMAIN_CATEGORY: {
					HyadesWindowsDomainCategory hyadesWindowsDomainCategory = (HyadesWindowsDomainCategory)theEObject;
					Object result = caseHyadesWindowsDomainCategory(hyadesWindowsDomainCategory);
					if (result == null) result = caseCFGCategory(hyadesWindowsDomainCategory);
					if (result == null) result = caseCMNNamedElement(hyadesWindowsDomainCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_USERNAME_CATEGORY: {
					HyadesUsernameCategory hyadesUsernameCategory = (HyadesUsernameCategory)theEObject;
					Object result = caseHyadesUsernameCategory(hyadesUsernameCategory);
					if (result == null) result = caseCFGCategory(hyadesUsernameCategory);
					if (result == null) result = caseCMNNamedElement(hyadesUsernameCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_SERVICE_PACK_CATEGORY: {
					HyadesServicePackCategory hyadesServicePackCategory = (HyadesServicePackCategory)theEObject;
					Object result = caseHyadesServicePackCategory(hyadesServicePackCategory);
					if (result == null) result = caseCFGCategory(hyadesServicePackCategory);
					if (result == null) result = caseCMNNamedElement(hyadesServicePackCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_MAJOR_VERSION_CATEGORY: {
					HyadesMajorVersionCategory hyadesMajorVersionCategory = (HyadesMajorVersionCategory)theEObject;
					Object result = caseHyadesMajorVersionCategory(hyadesMajorVersionCategory);
					if (result == null) result = caseCFGCategory(hyadesMajorVersionCategory);
					if (result == null) result = caseCMNNamedElement(hyadesMajorVersionCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_MINOR_VERSION_CATEGORY: {
					HyadesMinorVersionCategory hyadesMinorVersionCategory = (HyadesMinorVersionCategory)theEObject;
					Object result = caseHyadesMinorVersionCategory(hyadesMinorVersionCategory);
					if (result == null) result = caseCFGCategory(hyadesMinorVersionCategory);
					if (result == null) result = caseCMNNamedElement(hyadesMinorVersionCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_SERVICE_PACK_ENUMERATION: {
					HyadesServicePackEnumeration hyadesServicePackEnumeration = (HyadesServicePackEnumeration)theEObject;
					Object result = caseHyadesServicePackEnumeration(hyadesServicePackEnumeration);
					if (result == null) result = caseCFGPsudoEnumeration(hyadesServicePackEnumeration);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_ARTIFACT_LOCATION_PAIR: {
					CFGArtifactLocationPair cfgArtifactLocationPair = (CFGArtifactLocationPair)theEObject;
					Object result = caseCFGArtifactLocationPair(cfgArtifactLocationPair);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_MACHINE: {
					CFGMachine cfgMachine = (CFGMachine)theEObject;
					Object result = caseCFGMachine(cfgMachine);
					if (result == null) result = caseCFGLocation(cfgMachine);
					if (result == null) result = caseCFGConfigurableObject(cfgMachine);
					if (result == null) result = caseCMNNamedElement(cfgMachine);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.CFG_PSUDO_ENUMERATION: {
					CFGPsudoEnumeration cfgPsudoEnumeration = (CFGPsudoEnumeration)theEObject;
					Object result = caseCFGPsudoEnumeration(cfgPsudoEnumeration);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case Common_ConfigurationPackage.HYADES_PASSWORD_CATEGORY: {
					HyadesPasswordCategory hyadesPasswordCategory = (HyadesPasswordCategory)theEObject;
					Object result = caseHyadesPasswordCategory(hyadesPasswordCategory);
					if (result == null) result = caseCFGCategory(hyadesPasswordCategory);
					if (result == null) result = caseCMNNamedElement(hyadesPasswordCategory);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				default: return defaultCase(theEObject);
			}
		}
		return defaultCase(theEObject);
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Location</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Location</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGLocation(CFGLocation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGClass(CFGClass object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGOperation(CFGOperation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Artifact</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Artifact</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGArtifact(CFGArtifact object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGInstance(CFGInstance object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Comparable Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Comparable Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGComparableProperty(CFGComparableProperty object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Property Group</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Property Group</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGPropertyGroup(CFGPropertyGroup object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGCategory(CFGCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Operating System Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Operating System Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesOperatingSystemEnumeration(HyadesOperatingSystemEnumeration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Operating System Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Operating System Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesOperatingSystemCategory(HyadesOperatingSystemCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Processor Type Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Processor Type Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesProcessorTypeCategory(HyadesProcessorTypeCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Memory Size Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Memory Size Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesMemorySizeCategory(HyadesMemorySizeCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Processor Speed Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Processor Speed Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesProcessorSpeedCategory(HyadesProcessorSpeedCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Processor Type Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Processor Type Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesProcessorTypeEnumeration(HyadesProcessorTypeEnumeration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Browser Type Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Browser Type Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesBrowserTypeCategory(HyadesBrowserTypeCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Browser Version Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Browser Version Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesBrowserVersionCategory(HyadesBrowserVersionCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Browser Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Browser Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesBrowserEnumeration(HyadesBrowserEnumeration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Processor Number Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Processor Number Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesProcessorNumberCategory(HyadesProcessorNumberCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Display Color Depth Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Display Color Depth Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesDisplayColorDepthCategory(HyadesDisplayColorDepthCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Display Color Depth Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Display Color Depth Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesDisplayColorDepthEnumeration(HyadesDisplayColorDepthEnumeration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Display Height Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Display Height Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesDisplayHeightCategory(HyadesDisplayHeightCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Display Width Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Display Width Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesDisplayWidthCategory(HyadesDisplayWidthCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Display Height Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Display Height Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesDisplayHeightEnumeration(HyadesDisplayHeightEnumeration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Display Width Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Display Width Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesDisplayWidthEnumeration(HyadesDisplayWidthEnumeration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Display Number Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Display Number Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesDisplayNumberCategory(HyadesDisplayNumberCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Database Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Database Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesDatabaseCategory(HyadesDatabaseCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Database Version Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Database Version Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesDatabaseVersionCategory(HyadesDatabaseVersionCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Database Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Database Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesDatabaseEnumeration(HyadesDatabaseEnumeration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Machine Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Machine Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGMachineInstance(CFGMachineInstance object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Machine Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Machine Constraint</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGMachineConstraint(CFGMachineConstraint object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Configurable Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Configurable Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGConfigurableObject(CFGConfigurableObject object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Hostname Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Hostname Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesHostnameCategory(HyadesHostnameCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Windows Domain Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Windows Domain Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesWindowsDomainCategory(HyadesWindowsDomainCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Username Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Username Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesUsernameCategory(HyadesUsernameCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Service Pack Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Service Pack Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesServicePackCategory(HyadesServicePackCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Major Version Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Major Version Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesMajorVersionCategory(HyadesMajorVersionCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Minor Version Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Minor Version Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesMinorVersionCategory(HyadesMinorVersionCategory object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Service Pack Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Service Pack Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesServicePackEnumeration(HyadesServicePackEnumeration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Artifact Location Pair</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Artifact Location Pair</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGArtifactLocationPair(CFGArtifactLocationPair object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Machine</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Machine</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGMachine(CFGMachine object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CFG Psudo Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CFG Psudo Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCFGPsudoEnumeration(CFGPsudoEnumeration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Hyades Password Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Hyades Password Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHyadesPasswordCategory(HyadesPasswordCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CMN Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CMN Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCMNNamedElement(CMNNamedElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVRProperty(BVRProperty object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CMN Node Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CMN Node Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCMNNodeInstance(CMNNodeInstance object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CMN Node Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CMN Node Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCMNNodeType(CMNNodeType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object)
	{
		return null;
	}

} //Common_ConfigurationSwitch
