/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;
import java.util.ListIterator;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>DPL Equivalence Class</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLEquivalenceClassImpl#getRecords <em>Records</em>}</li>
 * </ul>
 * </p>
 * 
 * @extends IDatapoolEquivalenceClass
 * @generated NOT
 */
public class DPLEquivalenceClassImpl 
            extends CMNNamedElementImpl 
            implements DPLEquivalenceClass, IDatapoolEquivalenceClass
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached value of the '{@link #getRecords() <em>Records</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecords()
	 * @generated
	 * @ordered
	 */
	protected EList records = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DPLEquivalenceClassImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_DatapoolPackage.eINSTANCE.getDPLEquivalenceClass();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRecords()
	{
		if (records == null) {
			records = new EObjectContainmentEList(DPLRecord.class, this, Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORDS);
		}
		return records;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORDS:
					return ((InternalEList)getRecords()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__ID:
				return getId();
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DESCRIPTION:
				return getDescription();
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__NAME:
				return getName();
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORDS:
				return getRecords();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__ID:
				setId((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__NAME:
				setName((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORDS:
				getRecords().clear();
				getRecords().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORDS:
				getRecords().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS__RECORDS:
				return records != null && !records.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	//beginning of non-generated classes
	
	//org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass methods
	
	/**
	 * Construct a new record with an appropriate number of elements for the 
	 * active datapool.  The number of elements equals the number of
	 * {@link IDatapool#getVariableCount() variables} in the datapool.  
	 *  
	 * @see #constructRecord(Object[])
	 * @see	IDatapool#getVariableCount()
	 * @see	#insertRecord(IDatapoolRecord,int)
	 * @see	#appendRecord(IDatapoolRecord)
	 * @see	#replaceRecord(IDatapoolRecord,int)
	 */
	public IDatapoolRecord constructRecord() 
	{
		return constructRecord(null);
	}
	
	/**
	 * Construct a new record with an appropriate number of elements for the 
	 * active datapool.  The number of elements equals the number of
	 * {@link IDatapool#getVariableCount() variables} in the datapool.  The supplied
	 * values will be padded or truncated to match the number of variables
	 * available.  The supplied values may be <code>null</code> in which 
	 * case all elements in the returned record will be <code>null</code>.
	 * 
	 * @param	elements	The initial values (XML fragments) defined for the record or
	 *						<code>null</code> if no initial values are desired.
	 * 
	 * @see	IDatapool#getVariableCount()
	 * @see	#insertRecord(IDatapoolRecord,int)
	 * @see	#appendRecord(IDatapoolRecord)
	 * @see	#replaceRecord(IDatapoolRecord,int)
	 */
	public IDatapoolRecord constructRecord(Object[] elements)
	{	
		//create new record
		DPLRecord rec = Common_DatapoolFactory.eINSTANCE.createDPLRecord();
		
		//get variables
		DPLDatapool datapool = (DPLDatapool)this.eContainer;
		if (datapool == null) 
			return null;		
		java.util.List variables = datapool.getDatapoolSpec().getVariables();
		
		ListIterator it = variables.listIterator();
		int elementIndex = 0;
		while (it.hasNext())
		{
			DPLCell newCell = Common_DatapoolFactory.eINSTANCE.createDPLCell();
			newCell.setVariable((DPLVariable) it.next());
			rec.getCells().add(newCell);	
			if(elements != null && elementIndex < elements.length)
			{
				newCell.setValue((String)elements[elementIndex++]);  
			}
			else
			{
				newCell.setValue(null);
			}			
		}
	
		return (org.eclipse.hyades.edit.datapool.IDatapoolRecord)rec;
	}
	
	/**
	 * Insert the specified record before the zero based record index.
	 * Any attempt to insert the same record into a datapool multiple times
	 * will result in an appropriate exception.
	 * 
	 * @param	data			The new record.
	 * @param	beforeRecord	The zero based record index to insert the new record before.
	 * 
	 * @see	#appendRecord(IDatapoolRecord)
	 * @see	#replaceRecord(IDatapoolRecord,int)
	 * @see	#removeRecord(int)
	 */
	public void insertRecord(IDatapoolRecord data, int beforeRecord)
	{

		this.insertRecordDoNotNotify(data, beforeRecord);
		
		//notify datapool listener
		DPLDatapool dp = (DPLDatapool)this.eContainer();		
		IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
		if (l != null)
			l.recordAdded((IDatapool)dp,
						   dp.getEquivalenceClasses().indexOf(this), 
						   beforeRecord);
		
	}
	
	/**
	 * Helper function
	 * Insert the specified record before the zero based record index.
	 * Do not notify listeners.
	 * 
	 * @param	data			The new record.
	 * @param	beforeRecord	The zero based record index to insert the new record before.
	 * 
	 */
	public void insertRecordDoNotNotify(IDatapoolRecord data, int beforeRecord)
	{
		ListIterator recIter = this.getRecords().listIterator();
		while(recIter.hasNext()) {
			if (((DPLRecord)recIter.next()).equals(data))
				throw new DatapoolException (
						   "Attempt to enter duplicate records into an equivalence class");
			                     
		}			
		this.getRecords().add(beforeRecord, data);		
	}	
	
	/**
	 * Append the specified record to the end of the datapool.
	 * Any attempt to insert the same Record into a datapool multiple times
	 * will result in an appropriate exception.
	 * 
	 * @param	record	The new record.
	 * 
	 * @see	#insertRecord(IDatapoolRecord,int)
	 * @see	#replaceRecord(IDatapoolRecord,int)
	 * @see	#removeRecord(int)
	 */
	public void appendRecord(IDatapoolRecord record)
	{		
		this.insertRecord(record, this.getRecords().size());
	}
	
	/**
	 * Update the specified record with the supplied data.  This method 
	 * simulates {@link #removeRecord(int) removeRecord} followed by 
	 * {@link #insertRecord(IDatapoolRecord,int) insertRecord} without the need
	 * to perform both calls.  The specified record index is zero
	 * based.  Any attempt to replace a record in the datapool with 
	 * a record already in the datapool will result in an appropriate
	 * exception.
	 * 
	 * @param	data			The new record data.
	 * @param	recordIndex		The zero based record index to update the new record data into.
	 * 
	 * @see	#insertRecord(IDatapoolRecord,int)
	 * @see	#appendRecord(IDatapoolRecord)
	 * @see	#removeRecord(int)
	 */
	public void replaceRecord(IDatapoolRecord data, int recordIndex)
	{
		this.removeRecordDoNotNotify(recordIndex);
		this.insertRecordDoNotNotify(data, recordIndex);
		
		//notify datapool listener
		DPLDatapool dp = (DPLDatapool)this.eContainer();		
		IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
		if (l != null)
			l.recordChanged((IDatapool)dp,
						   dp.getEquivalenceClasses().indexOf(this), 
						   recordIndex);		
		
	}
	
	/**
	 * Remove the specified record.
	 * 
	 * @param	recordIndex		The zero based record index of the record to remove.
	 * 
	 * @see	#insertRecord(IDatapoolRecord,int)
	 * @see	#appendRecord(IDatapoolRecord)
	 * @see	#replaceRecord(IDatapoolRecord,int)
	 */
	public IDatapoolRecord removeRecord(int recordIndex)
	{
		IDatapoolRecord removedRecord = this.removeRecordDoNotNotify(recordIndex);
		 		
		//notify datapool listener
		DPLDatapool dp = (DPLDatapool)this.eContainer();		
		IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
		if (l != null)
			l.recordRemoved((IDatapool)dp,
						   dp.getEquivalenceClasses().indexOf(this), 
						   recordIndex);
						   
		return removedRecord;
	}
	
	/**
	 * Helper function
	 * Remove the specified record. Do not notify listener.
	 * 
	 * @param	recordIndex		The zero based record index of the record to remove.
	 * 
	 */
	protected IDatapoolRecord removeRecordDoNotNotify(int recordIndex)
	{
		IDatapoolRecord removedRecord = (IDatapoolRecord)this.getRecords().remove(recordIndex);
		return removedRecord;
	}	
	
	/**
	 * Move the specified record.
	 * 
	 * @param	sourceRecordIndex	The zero based record index of the record to move.
	 * @param	targetRecordIndex	The reord index marking the target location for
	 *							    the move action.
	 * 
	 * @see	#insertRecord(IDatapoolRecord,int)
	 * @see	#appendRecord(IDatapoolRecord)
	 * @see	#replaceRecord(IDatapoolRecord,int)
	 */
	public void moveRecord(int sourceRecordIndex, int targetRecordIndex)
	{
		IDatapoolRecord rec = this.removeRecordDoNotNotify(sourceRecordIndex);
		this.insertRecordDoNotNotify(rec, targetRecordIndex);
		
		//notify datapool listener
		DPLDatapool dp = (DPLDatapool)this.eContainer();		
		IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
		if (l != null)
			l.recordMoved((IDatapool)dp,
						   dp.getEquivalenceClasses().indexOf(this), 
						   sourceRecordIndex,
						   targetRecordIndex);
		
	}
		
	/**
	 * Inform the equivalence class of a new order for records.  The current record index
	 * is specified in the array, with the index into the array expressing
	 * the desired order.  So if {3, 4, 2, 1, 0} is passed in, the third record
	 * if moved to the first position, the fourth to the second and so on.
	 * <p>
	 * If the specified set of records is the wrong length or contains redundant 
	 * record references an appropriate exception is thrown.
	 * 
	 * @param	recordOrder	The desired order for the records in the equivalence class.
	 */
	public void reorder(int[] recordOrder)
	{
		
		java.util.LinkedList list = new java.util.LinkedList();
		
		if (recordOrder.length != this.getRecordCount())
		{
			throw new DatapoolException("Record reordering attempt with wrong number of records specified");
		}
		
		int i;
		for (i = 0; i < recordOrder.length; i++)
		{
			list.add(this.getRecords().get(recordOrder[i]));
		}
		
		this.getRecords().clear();
		
		ListIterator it = list.listIterator();
		
		while (it.hasNext())
		{
			this.insertRecordDoNotNotify((IDatapoolRecord)it.next(), this.getRecords().size());
		
		}
		
		//notify datapool listener  
		DPLDatapool dp = (DPLDatapool)this.eContainer();		
		IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
		int equivalenceClassIndex = dp.getEquivalenceClasses().indexOf(this);
		if (l != null)
			l.equivalenceClassReordered((IDatapool)dp, equivalenceClassIndex);
	}
	
	//org.eclipse.hyades.execution.runtime.datapool.IDatapoolEquivalenceClass methods

	
	/**
	 * The number of records in the equivalence class.
	 * 
	 * @return	The number of records in the equivalence class.
	 */
	public int getRecordCount()
	{
		return this.getRecords().size();
	}
	
	/**
	 * Access to the record contents at the specified zero based record index.
	 * 
	 * @param	record		The record contents at the specified zero based record index.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord getRecord(int record)
	{
		return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord)
				this.getRecords().get(record);	
	}

	/**
	 * Access to the {@link IDatapool datapool} that is the parent of this equivalence
	 * class.
	 * 
	 * @return	The {@link IDatapool datapool} that is the parent of this equivalence
	 *			class.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapool getDatapool()
	{
		return (org.eclipse.hyades.execution.runtime.datapool.IDatapool)this.eContainer();
	}

	public void setName(String name)
	{
		super.setName(name);

		//notify datapool listener  
		DPLDatapool dp = (DPLDatapool)this.eContainer();	
		if(dp == null)
			return;	
		IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
		if (l != null)
			l.equivalenceClassChanged((IDatapool)dp, 
									  dp.getEquivalenceClasses().indexOf(this));		
	}

} //DPLEquivalenceClassImpl
