/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * A test invocation is an action that invokes another test.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface ITestComponentInvocation extends IAction {	

	/**
	 * Returns the test component that is associated with this invocation.
	 * 
	 * <p>This reference is unidirectional
	 * 
	 * @return ITestComponent
	 */
	public ITestComponent getInvokedTestComponent();

	/**
	 * Returns the test component implementor that is associated with this invocation.
	 * 
	 * @return IImplementor
	 */
	public IImplementor getInvokedImplementor();
	
	/**
	 * Returns the name of the test component implementor that is associated 
	 * with this invocation.
	 * 
	 * @return IImplementor
	 */
	public String getInvokedImplementorName();

	/**
	 * Sets the test component and implementor for this invocation.
	 * 
	 * <p>The reference is unidirectional
	 * 
	 * @param test
	 */
	public void setInvokedTestComponent(ITestComponent component, 
		IImplementor implementor);
		
	/**
	 * Sets the test component and implementor (by name) for this invocation.
	 * 
	 * <p>The reference is unidirectional
	 * 
	 * @param test
	 */
	public void setInvokedTestComponent(ITestComponent component, 
		String implementorName);
	
}
