/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.fragments.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.BVRInteractionConstraint;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperand;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;
import org.eclipse.hyades.models.common.testprofile.TPFDefaultApplication;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Interaction Operand</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionOperandImpl#getInteractionFragments <em>Interaction Fragments</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionOperandImpl#getInteractionConstraint <em>Interaction Constraint</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionOperandImpl#getCombinedFragment <em>Combined Fragment</em>}</li>
 * </ul>
 * </p>
 *
 * @extends IBlock
 * @generated NOT
 */
public class BVRInteractionOperandImpl extends BVRInteractionFragmentImpl implements BVRInteractionOperand, IBlock
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached value of the '{@link #getInteractionFragments() <em>Interaction Fragments</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionFragments()
	 * @generated
	 * @ordered
	 */
	protected EList interactionFragments = null;

	/**
	 * The cached value of the '{@link #getInteractionConstraint() <em>Interaction Constraint</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionConstraint()
	 * @generated
	 * @ordered
	 */
	protected BVRInteractionConstraint interactionConstraint = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVRInteractionOperandImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInteractionFragments()
	{
		if (interactionFragments == null) {
			interactionFragments = new EObjectContainmentEList(BVRInteractionFragment.class, this, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_FRAGMENTS);
		}
		return interactionFragments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteractionConstraint getInteractionConstraint()
	{
		return interactionConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInteractionConstraint(BVRInteractionConstraint newInteractionConstraint, NotificationChain msgs)
	{
		BVRInteractionConstraint oldInteractionConstraint = interactionConstraint;
		interactionConstraint = newInteractionConstraint;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_CONSTRAINT, oldInteractionConstraint, newInteractionConstraint);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInteractionConstraint(BVRInteractionConstraint newInteractionConstraint)
	{
		if (newInteractionConstraint != interactionConstraint) {
			NotificationChain msgs = null;
			if (interactionConstraint != null)
				msgs = ((InternalEObject)interactionConstraint).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_CONSTRAINT, null, msgs);
			if (newInteractionConstraint != null)
				msgs = ((InternalEObject)newInteractionConstraint).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_CONSTRAINT, null, msgs);
			msgs = basicSetInteractionConstraint(newInteractionConstraint, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_CONSTRAINT, newInteractionConstraint, newInteractionConstraint));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRCombinedFragment getCombinedFragment()
	{
		if (eContainerFeatureID != Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT) return null;
		return (BVRCombinedFragment)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCombinedFragment(BVRCombinedFragment newCombinedFragment)
	{
		if (newCombinedFragment != eContainer || (eContainerFeatureID != Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT && newCombinedFragment != null)) {
			if (EcoreUtil.isAncestor(this, newCombinedFragment))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newCombinedFragment != null)
				msgs = ((InternalEObject)newCombinedFragment).eInverseAdd(this, Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS, BVRCombinedFragment.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newCombinedFragment, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT, newCombinedFragment, newCombinedFragment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__LIFELINES:
					return ((InternalEList)getLifelines()).basicAdd(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__MESSAGES:
					return ((InternalEList)getMessages()).basicAdd(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DEFAULT_APPLICATION:
					if (defaultApplication != null)
						msgs = ((InternalEObject)defaultApplication).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DEFAULT_APPLICATION, null, msgs);
					return basicSetDefaultApplication((TPFDefaultApplication)otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__LIFELINES:
					return ((InternalEList)getLifelines()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__GENERAL_ORDERINGS:
					return ((InternalEList)getGeneralOrderings()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__MESSAGES:
					return ((InternalEList)getMessages()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION:
					return eBasicSetContainer(null, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__PROPERTIES:
					return ((InternalEList)getProperties()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DEFAULT_APPLICATION:
					return basicSetDefaultApplication(null, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_FRAGMENTS:
					return ((InternalEList)getInteractionFragments()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_CONSTRAINT:
					return basicSetInteractionConstraint(null, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT:
					return eBasicSetContainer(null, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS, BVRInteraction.class, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS, BVRCombinedFragment.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__ID:
				return getId();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DESCRIPTION:
				return getDescription();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__NAME:
				return getName();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__LIFELINES:
				return getLifelines();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__GENERAL_ORDERINGS:
				return getGeneralOrderings();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__MESSAGES:
				return getMessages();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION:
				return getInteraction();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__PROPERTIES:
				return getProperties();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DEFAULT_APPLICATION:
				return getDefaultApplication();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_FRAGMENTS:
				return getInteractionFragments();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_CONSTRAINT:
				return getInteractionConstraint();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT:
				return getCombinedFragment();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__ID:
				setId((String)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__NAME:
				setName((String)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__LIFELINES:
				getLifelines().clear();
				getLifelines().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__GENERAL_ORDERINGS:
				getGeneralOrderings().clear();
				getGeneralOrderings().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__MESSAGES:
				getMessages().clear();
				getMessages().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION:
				setInteraction((BVRInteraction)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DEFAULT_APPLICATION:
				setDefaultApplication((TPFDefaultApplication)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_FRAGMENTS:
				getInteractionFragments().clear();
				getInteractionFragments().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_CONSTRAINT:
				setInteractionConstraint((BVRInteractionConstraint)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT:
				setCombinedFragment((BVRCombinedFragment)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__LIFELINES:
				getLifelines().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__GENERAL_ORDERINGS:
				getGeneralOrderings().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__MESSAGES:
				getMessages().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION:
				setInteraction((BVRInteraction)null);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__PROPERTIES:
				getProperties().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DEFAULT_APPLICATION:
				setDefaultApplication((TPFDefaultApplication)null);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_FRAGMENTS:
				getInteractionFragments().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_CONSTRAINT:
				setInteractionConstraint((BVRInteractionConstraint)null);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT:
				setCombinedFragment((BVRCombinedFragment)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__LIFELINES:
				return lifelines != null && !lifelines.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__GENERAL_ORDERINGS:
				return generalOrderings != null && !generalOrderings.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__MESSAGES:
				return messages != null && !messages.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION:
				return getInteraction() != null;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__DEFAULT_APPLICATION:
				return defaultApplication != null;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_FRAGMENTS:
				return interactionFragments != null && !interactionFragments.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_CONSTRAINT:
				return interactionConstraint != null;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT:
				return getCombinedFragment() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IBlock#getActions()
	 */
	public List getActions() {
		return getInteractionFragments();
	}

} //BVRInteractionOperandImpl
