/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponent;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Test Component</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestComponentImpl#getBehaviors <em>Behaviors</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestComponentImpl#getTestSuite <em>Test Suite</em>}</li>
 * </ul>
 * </p>
 *
 * @extends ITestComponent
 * @generated NOT
 */
public class TPFTestComponentImpl extends CFGClassImpl implements TPFTestComponent, ITestComponent
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached value of the '{@link #getBehaviors() <em>Behaviors</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBehaviors()
	 * @generated
	 * @ordered
	 */
	protected EList behaviors = null;

	/**
	 * The cached value of the '{@link #getDatapools() <em>Datapools</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatapools()
	 * @generated
	 * @ordered
	 */
	protected EList datapools = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFTestComponentImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_TestprofilePackage.eINSTANCE.getTPFTestComponent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getBehaviors()
	{
		if (behaviors == null) {
			behaviors = new EObjectContainmentWithInverseEList(TPFBehavior.class, this, Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS, Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT);
		}
		return behaviors;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTestSuite getTestSuite()
	{
		if (eContainerFeatureID != Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE) return null;
		return (TPFTestSuite)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTestSuite(TPFTestSuite newTestSuite)
	{
		if (newTestSuite != eContainer || (eContainerFeatureID != Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE && newTestSuite != null)) {
			if (EcoreUtil.isAncestor(this, newTestSuite))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTestSuite != null)
				msgs = ((InternalEObject)newTestSuite).eInverseAdd(this, Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS, TPFTestSuite.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newTestSuite, Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE, newTestSuite, newTestSuite));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDatapools()
	{
		if (datapools == null) {
			datapools = new EObjectResolvingEList(DPLDatapool.class, this, Common_TestprofilePackage.TPF_TEST_COMPONENT__DATAPOOLS);
		}
		return datapools;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__OPERATIONS:
					return ((InternalEList)getOperations()).basicAdd(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__ARTIFACTS:
					return ((InternalEList)getArtifacts()).basicAdd(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANCES:
					return ((InternalEList)getInstances()).basicAdd(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANTIATIONS:
					return ((InternalEList)getInstantiations()).basicAdd(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS:
					return ((InternalEList)getBehaviors()).basicAdd(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__OPERATIONS:
					return ((InternalEList)getOperations()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__ARTIFACTS:
					return ((InternalEList)getArtifacts()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANCES:
					return ((InternalEList)getInstances()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANTIATIONS:
					return ((InternalEList)getInstantiations()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS:
					return ((InternalEList)getBehaviors()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE:
					return eBasicSetContainer(null, Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS, TPFTestSuite.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__ID:
				return getId();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__DESCRIPTION:
				return getDescription();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__NAME:
				return getName();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__OPERATIONS:
				return getOperations();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__ARTIFACTS:
				return getArtifacts();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANCES:
				return getInstances();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANTIATIONS:
				return getInstantiations();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS:
				return getBehaviors();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE:
				return getTestSuite();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__DATAPOOLS:
				return getDatapools();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__ID:
				setId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__NAME:
				setName((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__OPERATIONS:
				getOperations().clear();
				getOperations().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__ARTIFACTS:
				getArtifacts().clear();
				getArtifacts().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANCES:
				getInstances().clear();
				getInstances().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANTIATIONS:
				getInstantiations().clear();
				getInstantiations().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS:
				getBehaviors().clear();
				getBehaviors().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE:
				setTestSuite((TPFTestSuite)newValue);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__DATAPOOLS:
				getDatapools().clear();
				getDatapools().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__OPERATIONS:
				getOperations().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__ARTIFACTS:
				getArtifacts().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANCES:
				getInstances().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANTIATIONS:
				getInstantiations().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS:
				getBehaviors().clear();
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE:
				setTestSuite((TPFTestSuite)null);
				return;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__DATAPOOLS:
				getDatapools().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__OPERATIONS:
				return operations != null && !operations.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__ARTIFACTS:
				return artifacts != null && !artifacts.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANCES:
				return instances != null && !instances.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__INSTANTIATIONS:
				return instantiations != null && !instantiations.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS:
				return behaviors != null && !behaviors.isEmpty();
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE:
				return getTestSuite() != null;
			case Common_TestprofilePackage.TPF_TEST_COMPONENT__DATAPOOLS:
				return datapools != null && !datapools.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	private TPFBehavior getDeployableBehavior()
	{
		// This method currently takes the first behavior of the TestComponent, since every
		// behavior should point to the same deployable entity.
		List behaviors = getBehaviors();
		if ( !behaviors.isEmpty() )
			return (TPFBehaviorImpl) behaviors.get(0);
		else
			return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getLocation()
	 */
	public String getLocation() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			return behavior.getLocation();
		}
		else 
		{
			return "";
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getOwner()
	 */
	public ITest getOwner() {
		return (TPFTestSuiteImpl)getTestSuite();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getResource()
	 */
	public String getResource() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			return behavior.getResource();
		}
		else 
		{
			return "";
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setLocation(java.lang.String)
	 */
	public void setLocation(String location) {
		return;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setResource(java.lang.String)
	 */
	public void setResource(String resource) {
		List behaviors = getBehaviors();
		Iterator iter = behaviors.iterator();
		
		while ( iter.hasNext() )
		{
			TPFBehaviorImpl behavior = (TPFBehaviorImpl)iter.next();
			behavior.setResource(resource);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestComponent#getImplementors()
	 */
	public List getImplementors() {
		return getBehaviors();
	}

} //TPFTestComponentImpl
