/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.TreeViewerFrameSource;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

/**
 * Frame source for tree navigators, which uses <code>TreeFrame</code> to capture
 * the state of the tree viewer.
 * 
 * <p>This implementation is based on the 
 * {@link org.eclipse.ui.views.navigator.NavigatorFrameSource} class.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class TreeNavigatorFrameSource 
extends TreeViewerFrameSource
{
	private ITreeNavigator treeNavigator;

	/**
	 * Constructor for TreeNavigatorFrameSource
	 * @param viewer
	 */
	public TreeNavigatorFrameSource(ITreeNavigator treeNavigator)
	{
		super(treeNavigator.getTreeViewer());
		this.treeNavigator = treeNavigator;
	}
	
	/**
	 * Returns the tree navigator this frame source is associated with.
	 * @return ITreeNavigator
	 */
	protected ITreeNavigator getTreeNavigator()
	{
		return treeNavigator;
	}

	/**
	 * Returns a new frame.  This implementation extends the super implementation
	 * by setting the frame's tool tip text to show the full path for the input
	 * element.
	 * @param input
	 * @return TreeFrame
	 */
	protected TreeFrame createFrame(Object input)
	{
		TreeFrame frame = super.createFrame(input);
		frame.setName(treeNavigator.getFrameName(input));
		frame.setToolTipText(treeNavigator.getFrameToolTipText(input));
		return frame;
	}

	/**
	 * Also updates the navigator's title.
	 * @param TreeFrame
	 */
	protected void frameChanged(TreeFrame frame)
	{
		Object input = frame.getInput();
		if(input instanceof IResource)
		{
			IProject project = ((IResource)input).getProject();
	
			if (project != null && project.isOpen() == false)
			{
				MessageDialog.openInformation(treeNavigator.getViewSite().getShell(), ResourceNavigatorMessages.getString("NavigatorFrameSource.closedProject.title"),			ResourceNavigatorMessages.format("NavigatorFrameSource.closedProject.message", new Object[]{project.getName()}));
				treeNavigator.getFrameList().back();
				return;
			}
		}
		
		super.frameChanged(frame);
		treeNavigator.updateTitle();
	}
}
