package org.eclipse.hyades.logging.parsers;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

public final class ParserConstants {

    public final static String FILE_SEPARATOR = System.getProperty("file.separator");

    public final static char FILE_SEPARATOR_CHARACTER = FILE_SEPARATOR.charAt(0);

    public final static String LINE_SEPARATOR = System.getProperty("line.separator");

    public final static String HYADES_VERSION = "0.2.0";

    public final static String REMOTE_LOG_LOADER_AGENT_NAME = "Remote Log Loader IRemoteEntity";

    public final static String REMOTE_LOG_LOADER_ERROR_AGENT_NAME = "Remote Log Loader Error IRemoteEntity";

    public final static String REMOTE_LOG_LOADER_RAC_APPLICATION = "RemoteLogParserLoader";

    public final static String REMOTE_LOG_LOADER_CLASS = "com.ibm.etools.logging.parsers.RemoteLogParserLoader";

    public final static String APACHE_HTTP_SERVER_ERROR_LOG_PARSER_NAME = "Apache HTTP Server V1.3.26 error log";
    public final static String APACHE_HTTP_SERVER_ERROR_LOG_PARSER_VERSION = HYADES_VERSION;

    public final static String APACHE_HTTP_SERVER_ACCESS_LOG_PARSER_NAME = "Apache HTTP Server V1.3.26 access log";
    public final static String APACHE_HTTP_SERVER_ACCESS_LOG_PARSER_VERSION = HYADES_VERSION;

    public final static String HOST_ID_FORMAT_IPV4 = "IPV4";
    public final static String HOST_ID_FORMAT_IPV6 = "IPV6";
    public final static String MESSAGE_ARRAY_SIZE_KEY = "array_size";
    public final static String FILE_PATH_KEY = "file_path";
    public final static String APACHE_VERSION_KEY = "APACHE_VERSION";
    public final static String APACHE_HTTP_SERVER = "Apache HTTP Server";
    public final static String LOCALE_EN_US = "en-US";
    public final static short CBE_SEVERITY_1 = 50;
    public final static short CBE_SEVERITY_2 = 30;
    public final static short CBE_SEVERITY_3 = 10;

    public final static String APACHE_COMPONENT_TYPE = "ApacheHTTPServer";

    public final static String APACHE_COMPONENT_ID_TYPE = "ProductName";

    /**
     * Message - Attribute name for extendedDataElement for CBE
     */
    public final static String MESSAGE_EXTENDED_DATA_ELEMENT = "message";

    /**
     * Constant for the XML DateTime format (e.g. CBE's creationTime).
     */
    public final static String XML_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    /**
     * Constant for String "Unknown".
     */
    public final static String UNKNOWN = "Unknown";

    /**
     * Constant for String "Not Applicable".
     */
    public final static String NOT_APPLICABLE = "Not Applicable";

    /**
     * Constant for String "None".
     */
    public final static String NONE = "None";

    /**
     * Constant for String "file".
     */
    public final static String FILE = "file";

    /**
     * Constant for String "client".
     */
    public final static String CLIENT = "client";

    /**
     * Constant for String ".000000".
     */
    public final static String SIX_ZERO = ".000000";

    /**
     * Constant for Apache access log's time stamp format.
     */
    public final static String APACHE_ACCESS_TIME_STAMP_FORMAT = "dd/MMM/yyyy:HH:mm:ss";

    /**
     * Constant for Apache error log's time stamp format.
     */
    public final static String APACHE_ERROR_TIME_STAMP_FORMAT = "EEE MMM d HH:mm:ss yyyy";

    /**
     * Constant for String "category".
     */
    public final static String CATEGORY = "category";

    /**
     * Constant for String "CGI debugging output".
     */
    public final static String CGI = "CGI_debugging_output";

    /**
     * Constant for String "warn".
     */
    public final static String WARN_STRING = "warn";

    /**
     * Constant for String "error".
     */
    public final static String ERROR_STRING = "error";

    /**
     * Constant for String "alert".
     */
    public final static String ALERT_STRING = "alert";

    /**
     * Constant for String "crit".
     */
    public final static String CRIT_STRING = "crit";

    /**
     * Constant for String "emerg".
     */
    public final static String EMERG_STRING = "emerg";

    /**
     * Constant for an internal reasoning scope of a situation type.
     */
    public final static String INTERNAL_REASONING_SCOPE = "INTERNAL";

    /**
     * Constant for an external reasoning scope of a situation type.
     */
    public final static String EXTERNAL_REASONING_SCOPE = "EXTERNAL";

    /**
     * Constant for a successful success disposition of a situation.
     */
    public final static String SUCCESSFUL_SUCCESS_DISPOSITION = "SUCCESSFUL";

    /**
     * Constant for a unsuccessful success disposition of a situation.
     */
    public final static String UNSUCCESSFUL_SUCCESS_DISPOSITION = "UNSUCCESSFUL";

    /**
     * Constant for a start situation category name of a situation.
     */
    public final static String START_SITUATION_CATEGORY_NAME = "StartSituation";

    /**
     * Constant for a restart initiated situation qualifier of a start situation.
     */
    public final static String RESTART_INITIATED_SITUATION_QUALIFIER = "RESTART INITIATED";

    /**
     * Constant for a start completed situation qualifier of a start situation.
     */
    public final static String START_COMPLETED_SITUATION_QUALIFIER = "START COMPLETED";

    /**
     * Constant for a start initiated situation qualifier of a start situation.
     */
    public final static String START_INITIATED_SITUATION_QUALIFIER = "START INITIATED";

    /**
     * Constant for a stop situation category name of a situation.
     */
    public final static String STOP_SITUATION_CATEGORY_NAME = "StopSituation";

    /**
     * Constant for a stop initiated situation qualifier of a stop situation.
     */
    public final static String STOP_INITIATED_SITUATION_QUALIFIER = "STOP INITIATED";

    /**
     * Constant for a abort initiated situation qualifier of a stop situation.
     */
    public final static String ABORT_INITIATED_SITUATION_QUALIFIER = "ABORT INITIATED";

    /**
     * Constant for a pause initiated situation qualifier of a stop situation.
     */
    public final static String PAUSE_INITIATED_SITUATION_QUALIFIER = "PAUSE INITIATED";

    /**
     * Constant for a stop completed situation qualifier of a stop situation.
     */
    public final static String STOP_COMPLETED_SITUATION_QUALIFIER = "STOP COMPLETED";

    /**
     * Constant for a connect situation category name of a situation.
     */
    public final static String CONNECT_SITUATION_CATEGORY_NAME = "ConnectSituation";

    /**
     * Constant for a report situation category name of a situation.
     */
    public final static String REPORT_SITUATION_CATEGORY_NAME = "ReportSituation";

    /**
     * Constant for a log report category of a report situation.
     */
    public final static String LOG_REPORT_CATEGORY = "LOG";

    /**
     * Constant for a performance report category of a report situation.
     */
    public final static String PERFORMANCE_REPORT_CATEGORY = "PERFORMANCE";

    /**
     * Constant for a security report category of a report situation.
     */
    public final static String SECURITY_REPORT_CATEGORY = "SECURITY";

    /**
     * Constant for a heartbeat report category of a report situation.
     */
    public final static String HEARTBEAT_REPORT_CATEGORY = "HEARTBEAT";

    /**
     * Constant for a status report category of a report situation.
     */
    public final static String STATUS_REPORT_CATEGORY = "STATUS";

    /**
     * Constant for a trace report category of a report situation.
     */
    public final static String TRACE_REPORT_CATEGORY = "TRACE";

    /**
     * Constant for a feature situation category name of a situation.
     */
    public final static String FEATURE_SITUATION_CATEGORY_NAME = "FeatureSituation";

    /**
     * Constant for an available feature disposition of a feature situation.
     */
    public final static String AVAILABLE_FEATURE_DISPOSITION = "AVAILABLE";

    /**
     * Constant for a not available feature disposition of a feature situation.
     */
    public final static String NOT_AVAILABLE_FEATURE_DISPOSITION = "NOT AVAILABLE";

    /**
     * Constant for a configure situation category name of a situation.
     */
    public final static String CONFIGURE_SITUATION_CATEGORY_NAME = "ConfigureSituation";

    /**
     * Constant for a dependency start situation category name of a situation.
     */
    public final static String DEPENDENCY_SITUATION_CATEGORY_NAME = "DependencySituation";

    /**
     * Constant for a met dependency disposition of a dependency situation.
     */
    public final static String MET_DEPENDENCY_DISPOSITION = "MET";

    /**
     * Constant for a not met dependency disposition of a dependency situation.
     */
    public final static String NOT_MET_DEPENDENCY_DISPOSITION = "NOT MET";

    /**
     * Constant for a create situation category name of a situation.
     */
    public final static String CREATE_SITUATION_CATEGORY_NAME = "CreateSituation";

    /**
     * Constant for a destroy situation category name of a situation.
     */
    public final static String DESTROY_SITUATION_CATEGORY_NAME = "DestroySituation";

    /**
     * Constant for an available situation category name of a situation.
     */
    public final static String AVAILABLE_SITUATION_CATEGORY_NAME = "AvailableSituation";

    /**
     * Constant for a startable operation disposition of a available situation.
     */
    public final static String STARTABLE_OPERATION_DISPOSITION = "STARTABLE";

    /**
     * Constant for a nonstartable operation disposition of a available situation.
     */
    public final static String NONSTARTABLE_OPERATION_DISPOSITION = "NONSTARTABLE";

    /**
     * Constant for a function process processing disposition of a available situation.
     */
    public final static String FUNCTION_PROCESS_PROCESSING_DISPOSITION = "FUNCTION_PROCESS";

    /**
     * Constant for a function block processing disposition of a available situation.
     */
    public final static String FUNCTION_BLOCK_PROCESSING_DISPOSITION = "FUNCTION_BLOCK";

    /**
     * Constant for a mgmt process processing disposition of a available situation.
     */
    public final static String MGMT_PROCESS_PROCESSING_DISPOSITION = "MGMTTASK_PROCESS";

    /**
     * Constant for a mgmt blocked processing disposition of a available situation.
     */
    public final static String MGMT_BLOCKED_PROCESSING_DISPOSITION = "MGMTTASK_BLOCKED";

    /**
     * Constant for an available availability disposition of a available situation.
     */
    public final static String AVAILABLE_AVAILABILITY_DISPOSITION = "AVAILABLE";

    /**
     * Constant for a not available availability disposition of a available situation.
     */
    public final static String NOT_AVAILABLE_AVAILABILITY_DISPOSITION = "NOT AVAILABLE";

    /**
     * Constant for a request situation category name of a situation.
     */
    public final static String REQUEST_SITUATION_CATEGORY_NAME = "RequestSituation";

    /**
     * Constant for a request initiated situation qualifier of a request situation.
     */
    public final static String REQUEST_INITIATED_SITUATION_QUALIFIER = "REQUEST INITIATED";

    /**
     * Constant for a request completed situation qualifier of a request situation.
     */
    public final static String REQUEST_COMPLETED_SITUATION_QUALIFIER = "REQUEST COMPLETED";

    /**
     * Constant for an other situation category name of a situation.
     */
    public final static String OTHER_SITUATION_CATEGORY_NAME = "OtherSituation";
}
