package org.eclipse.hyades.logging.core;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/** 
 * Interface for de-serializing XML fragments to the content of implementing <code>java.lang.Object</code>s.
 *  
 * 
 * @author		Richard Duggan
 * @author		Paul Slauenwhite
 * @version	March 7, 2003
 */
public interface IInternalizableFromXml {

    /**
     *	De-serializes an XML fragment to the content of the implementing <code>java.lang.Object</code>.
     *
     *	@param value The XML fragment to be de-serialized.
     */
    public void internalizeCanonicalXmlString(String value);

    /**
     *	De-serializes an XML document to the content of the implementing <code>java.lang.Object</code>.
     *
     *	@param value The XML document to be de-serialized.
     */
    public void internalizeCanonicalXmlDocString(String value);
}
