/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
/*
 * Created on Nov 14, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.execution.recorder.http.remote;
import java.io.*;
import javax.net.ssl.*;
import java.security.KeyStore;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;

/**
 * @author mdunn
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class SSLCheckClass {
	
	SSLSocket sslServer = null;
	SSLSocket spySocket = null;
	ClientSideReader csr = null;
	static final String SpySocketException = HttpRecResourceBundle.getInstance().getString("RECORDER_SSL_SPYSOCKET_EXCEPTION");
	static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");

	// a call here means the client has issued a CONNECT statement to this proxy server
	// we will attempt to open a separate secure connection to the requested server on the
	// requested port
	public SSLCheckClass(ClientSideReader thisCSR) {
		super();
		csr = thisCSR; 
		
	}
	public boolean createSSLSpyServerSocket(){	
	
		SSLSocketFactory ssf = null;
		try {
		// set up key manager to do server authentication
		SSLContext ctx;
		KeyManagerFactory kmf;
		KeyStore ks;
		char[] passphrase = "passphrase".toCharArray();
		String vendor = System.getProperty("java.vm.vendor");
	
		if ((vendor.indexOf("Sun")) >= 0){
			// The following to use Sun JVM
			ctx = SSLContext.getInstance("TLS");
			kmf = KeyManagerFactory.getInstance("SunX509");
		}
		else{
			// or use the following for the IBM JVM
			ctx = SSLContext.getInstance("SSL");
			kmf = KeyManagerFactory.getInstance("IbmX509");
		}
		
		ks = KeyStore.getInstance("jks");

		// TODO Need better place for testkeys file
		ks.load(new FileInputStream("C:\\testkeys"), passphrase);
		kmf.init(ks, passphrase);
		ctx.init(kmf.getKeyManagers(), null, null);
		ssf = ctx.getSocketFactory();
		
		spySocket = (SSLSocket)ssf.createSocket(csr.client,
				 "localhost", csr.client.getLocalPort(), true);
		spySocket.setUseClientMode(false);
		}
		catch (Exception e) {
			csr.packetWriter.writeRecorderMessage(2, "exception in creating SSL Spy Socket: " + e);
			csr.packetWriter.getAgentController().reportException(SpySocketException,e);
			return false;
		}
		
		return true;
	}	
	public boolean makeSecureConnection() {
		boolean isSecure = false;
			
		if ((connectToSecureServer(csr.destServer, csr.serverPort)) == true){
			if ((createSSLSpyServerSocket()) == true)
				csr.packetWriter.writeOpenConnectionInfo(csr.bSecure, 
						csr.iConnection, csr.destServer, csr.serverPort, csr.client, csr.httpServer, spySocket, sslServer);
			try {
				csr.to_client= spySocket.getOutputStream();
				csr.from_client = spySocket.getInputStream();
						
				// these are the decrypted streams
				csr.to_server = sslServer.getOutputStream();
				csr.from_server = sslServer.getInputStream();
				csr.bSecure = true;
				csr.serverReader = new ServerSideReader(csr.client,
													csr.httpServer,
													csr.from_server,
													csr.to_client,
													 csr.packetWriter,
													 csr.iConnection,
													 csr.bSecure,
													 spySocket.getReceiveBufferSize());
				csr.serverReader.start();
			} 
			catch (IOException e) {
				csr.packetWriter.writeRecorderMessage(2, "exception in creating SSL Spy Socket: " + e);
				csr.packetWriter.getAgentController().reportException(SpySocketException,e);
				return false;
			}
		}
		csr.bNoPrintToServer = true;
		//csr.bSecure = isSecure;
		//return isSecure;
		return csr.bSecure;
	}
	public boolean connectToSecureServer(String destStr, int port){
		try{
		
			SSLSocketFactory ssf = null;
			//TODO  use createSocket method that uses socket as input 
			TrustManager[] myTM = new TrustManager [] {new RecorderX509TrustManager() };
			SSLContext ctx = SSLContext.getInstance("SSL");
			ctx.init(null, myTM, null);
			ssf = ctx.getSocketFactory();			
			//sslServer = (SSLSocket)sslFact.createSocket(httpServer,destServer, serverPort,true);
			sslServer = (SSLSocket)ssf.createSocket(destStr, port);
			// when startHandshake returns, an SSL connection is
			// satisfied and handshaking is done transparently to this code
			sslServer.startHandshake();
		}
		catch (Exception e){
			csr.packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + e);
			csr.packetWriter.getAgentController().reportException(ClientSideReaderException,e);
			return false;
		}
		return true;
	}		

}
