package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The situationType specifies the type or category of the situation that caused 
 * the event to be reported. The categorization of situations facilitates the building 
 * of tools that focus on implementing the analysis and planning functions rather than 
 * on product-specific data formats.  The data type for this property is a complex type. 
 * The situation types or categories are defined below. SituationType is an abstract 
 * element that is used to define all supported situation types (i.e. StartSituation, 
 * StopSituation, etc).
 * 
 * The simplest way to understand the usefulness of categorization is by providing a use 
 * case.  For example, assume that a problem has been detected with component A. The 
 * first step in the root cause analysis might be to check to see if x was actually 
 * started, since it is known that A has a dependency on x. One approach to determine 
 * if x is running is to check the log file for x to see if it has started. The problem 
 * from a programmatic perspective is that there is not standard way to check the log files 
 * to see if x has started.  x might log Component x started or it might say, 
 * Change server state from starting to running.  The reality is that both of these messages 
 * provide the same information, but they provide it using different terminology, making it 
 * difficult for a program to use. Simple checks like this would be much easier if all components 
 * reported, for example, that they started. Writing code to check dependencies would be much 
 * easier and would be, largely, component independent. For example, if product A had dependencies 
 * on x and y, the code to check the status of x and the code to check the status of y 
 * would be the same, in both cases, it would look for a started message.
 * 
 * This is a REQUIRED property, that once it set it is not mutable, that is it MUST NOT be changed.
 * The following sections outline the well-known and acceptable values for the situationType.
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 */
public abstract interface ISituationType {

    /**
     * Returns the reasoningScope.
     * 
     * This property specifies the situation qualifiers that are representation 
     * of the parameters necessary to describe the situation.
     * The reasoningScope is a string with the following set of values:
     * 
     * START INITIATED
     * RESTART INITIATED
     * START COMPLETED
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned reasoningScope.
     * @since 1.0.1
     */
    public String getReasoningScope();

    /**
     * Sets the reasoningScope.
     * 
     * This property specifies the situation qualifiers that are representation 
     * of the parameters necessary to describe the situation.
     * The reasoningScope is a string with the following set of values:
     * 
     * START INITIATED
     * RESTART INITIATED
     * START COMPLETED
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param reasoningScope The reasoningScope to be set.
     * @since 1.0.1
     */
    public void setReasoningScope(String reasoningScope);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     */
    public void init();
}
