/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.local;

import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;

/**
 * @author rduggan
 */
public class JavaProcessExecutableObjectStub extends ExecutableObjectStub {

	public void setArgs(String args) {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{String.class}, new Object[]{args}, "setArgs");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}
	
	public String getArgs() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getArgs");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}
	
	public void setExe(String exe) {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{String.class}, new Object[]{exe}, "setExe");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}

	public String getExe() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getExe");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}
	
	public void setLocation(String loc) {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{String.class}, new Object[]{loc}, "setLocation");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}

	public String getLocation() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getLocation");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}

	public void setAgentData(String data) {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{String.class}, new Object[]{data}, "setAgentData");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}

	public String getAgentData() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getAgentData");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}
	
	public String getCommandLine() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getCommandLine");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}
}
