/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (8/23/00 4:43:37 PM)
 * @author: Richard K. DUggan
 */
public interface Options {

	/* Option Strings */
	public final static String OPTION_MONITOR_MODE          = "MONITOR_MODE";
	public final static String OPTION_CLASS_LOAD_DETAILS 	= "CLASS_LOAD_DETAILS";
	public final static String OPTION_COLLATION_VALUES 		= "COLLATION_VALUES";
	public final static String OPTION_CONTEXT_FLOW 			= "CONTEXT_FLOW";
	public final static String OPTION_EXCEPTION_TRACING 	    = "EXCEPTION_TRACING";
	public final static String OPTION_FILTERS 				= "FILTERS";
	public final static String OPTION_GC 					= "GC";
	public final static String OPTION_ID_STYLE 				= "ID_STYLE";
	public final static String OPTION_METHOD_COUNTS 		    = "METHOD_COUNTS";
	public final static String OPTION_OBJ_ALLOC_IS_ARRAY 	= "OBJ_ALLOC_IS_ARRAY";
	public final static String OPTION_OPTIONS 				= "OPTIONS";
	public final static String OPTION_TICKET				    = "TICKET";
	public final static String OPTION_TIMESTAMPS			    = "TIMESTAMPS";
	public final static String OPTION_TRACE_IDREFS			= "TRACE_IDREFS";
	public final static String OPTION_UNREFERENCED_SYMBOLS	= "UNREFERENCED_SYMBOLS";
	public final static String OPTION_STACK_INFORMATION		= "STACK_INFORMATION";
	public final static String OPTION_OBJ_REF_MODE			= "OBJ_REF_MODE";
	/* V5 additions */
	public final static String OPTION_TRACE_MODE				="TRACE_MODE";
	public final static String OPTION_TRACE_START_MODE		="TRACE_START_MODE";
	public final static String OPTION_BURST_MODE				="BURST_MODE";
	public final static String OPTION_BOUNDARY_DEPTH			="BOUNDARY_DEPTH";
	public static final String OPTION_BURST_INVOCATIONS		="BURST_INVOCATIONS";
	public static final String OPTION_BURST_SECONDS			="BURST_SECONDS";
	public static final String OPTION_ALLOCATION_INFORMATION	="ALLOCATION_INFORMATION";
	
			
	/* Option Values */
	public static final String OPTION_VALUE_ALL				= "all";
	public static final String OPTION_VALUE_TRUE			    = "true";
	public static final String OPTION_VALUE_FALSE			= "false";
	public static final String OPTION_VALUE_STATIC			= "static";
	public static final String OPTION_VALUE_RELOCATABLE		= "relocatable";
	public static final String OPTION_VALUE_STATICANDRELOCATABLE = "staticAndRelocatable";
	public static final String OPTION_VALUE_DEFAULT			= "default";
	public static final String OPTION_VALUE_NONE			    = "none";
	public static final String OPTION_VALUE_DELETES			= "deletes";
	public static final String OPTION_VALUE_DELETESANDMOVES   = "deletesAndMoves";
	public static final String OPTION_VALUE_NORMAL			= "normal";
	public static final String OPTION_VALUE_BOUNDARY		    = "boundary";
	public static final String OPTION_VALUE_CONTIGUOUS		= "contiguous";
	public static final String OPTION_VALUE_BOUNDARYANDCONTIGUOUS="boundaryAndContiguous";
	public static final String OPTION_VALUE_RESPECT_FILTER	= "respectFilter";	
	public static final String OPTION_VALUE_FILTER_OWNER	    = "filterOwner";	
	public static final String OPTION_VALUE_IGNORE_FILTER	= "ignoreFilter";	
	/* V5 Additions */
	public final static String OPTION_VALUE_NOOBJECTCORRELATION		="noObjectCorrelation";
	public static final String OPTION_VALUE_FILTER					="filter";
	public static final String OPTION_VALUE_TRIGGERSINGLETHREADED	="triggerSingleThreaded";
	public static final String OPTION_VALUE_TRIGGERMULTITHREADED		="triggerMultiThreaded";
	public static final String OPTION_VALUE_INVOCATIONS				="invocations";
	public static final String OPTION_VALUE_SECONDS					="seconds";
	public static final String OPTION_VALUE_SECONDSANDINVOCATIONS	="secondsAndInvocations";
	
	
					
	/* This option must be in place if the user has selected execution flow.
	 */
	public final static String[][] OPTIONS_EXECUTION_FLOW		=
					{
						{ OPTION_STACK_INFORMATION,			OPTION_VALUE_NORMAL},
						{ OPTION_TICKET,					OPTION_VALUE_TRUE }
					};

	/* This option must be used if the user has selected execution flow and some boundary information as well.
	 */
	public final static String[][] OPTIONS_EXECUTION_FLOW_BOUNDARY		=
					{
						{ OPTION_STACK_INFORMATION,			OPTION_VALUE_BOUNDARY},
						{ OPTION_TICKET,					OPTION_VALUE_TRUE }
					};



	/* This option must be in place if the user has selected that they do not want any execution behaviour at all.
	 */
	public final static String[][] OPTIONS_EXECUTION_FLOW_NONE =
					{
						{ OPTION_STACK_INFORMATION,         OPTION_VALUE_NONE},
						{ OPTION_TICKET,                    OPTION_VALUE_TRUE}
					};					
	
				
	/* This option must be in place if the user does not want object correlation information.
	 */	
	public final static String[][] OPTIONS_NO_INSTANCE_INFORMATION =
					{
						{OPTION_TRACE_MODE,					OPTION_VALUE_NOOBJECTCORRELATION },
						{OPTION_ALLOCATION_INFORMATION,		OPTION_VALUE_NONE}
					};

	public final static String[][] OPTIONS_ANALYZE_HEAP =
					{	
						{ OPTION_TRACE_MODE,				OPTION_VALUE_DEFAULT},
						{ OPTION_TICKET,					OPTION_VALUE_TRUE }
					};
					
	public final static String[][] OPTIONS_ANALYZE_HEAP_NONE =
					{	
						{OPTION_TRACE_MODE,					OPTION_VALUE_NOOBJECTCORRELATION },
						{OPTION_ALLOCATION_INFORMATION,		OPTION_VALUE_NONE}
					};

	/* This option must be in place if the user has selected Method Coverage but not EXECUTION_FLOW
	 */
	public final static String[][] OPTIONS_COVERAGE_NO_FLOW	=
					{
						{ OPTION_STACK_INFORMATION,			OPTION_VALUE_NORMAL},
						{ OPTION_METHOD_COUNTS,			    OPTION_VALUE_TRUE },
						{ OPTION_UNREFERENCED_SYMBOLS,		OPTION_VALUE_TRUE }
					};

	/* This option must be in place if the user has selected method coverage.
	 */
	public final static String[][] OPTIONS_COVERAGE	=
					{
						{ OPTION_METHOD_COUNTS,			    OPTION_VALUE_TRUE },
						{ OPTION_UNREFERENCED_SYMBOLS,		OPTION_VALUE_TRUE }
					};
					
	/* This option must be in place if the user has selected to observe threading events */
	  
	public final static String[][] OPTIONS_THREAD_EVENTS =
					{ 
						{ OPTION_MONITOR_MODE, OPTION_VALUE_ALL }
					};
}
