/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;

public class PropertyListCommand extends CommandElement implements Constants {

	protected Vector _properties=new Vector();

	public PropertyListCommand() {
		super();
		_tag = RA_PROPERTY_LIST;
	}

	public String[] getPropertyList() {
		int length = _properties.size();
		String[] results = new String[length];
		for(int i = 0; i < length; i++) {
			results[i] = ((RAString)_properties.elementAt(i)).getData();
		}
		return results;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		// Get the context value
		_context = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		// Read the number of properties
		long listLength = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		for(int i = 0; i < listLength; i++) {
			RAString property = new RAString("");
			current = Message.readRAStringFromBuffer(buffer, current, property);
			_properties.addElement(property);
		}
		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;
		current = Message.writeRALongToBuffer(buffer, current, _properties.size());
		for(int i = 0; i < _properties.size(); i++) {
			current=Message.writeRAStringToBuffer(buffer, current, ((RAString)_properties.elementAt(i)));
		}
		return current;
	}

	public int getSize() {
		int size = 0;

		size += sizeofLong; // tag
		size += sizeofLong; // context

		size += sizeofLong; // array size
		for(int i = 0; i < _properties.size(); i++) {
			size += ((RAString)_properties.elementAt(i)).getSize();
		}
		return size;
	}
}
