package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;

import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;

import javax.net.ssl.SSLContext;

public class SecureConnectionImpl extends ConnectionImpl {
	
	private boolean handshakeSuccess;

    public SecureConnectionImpl() {
        super();
    }

    public void connect(Node node, int port) throws IOException, SecureConnectionRequiredException, LoginFailedException, UntrustedAgentControllerException {
        _port = port;
        int offset = 0;
        InetAddress[] addrs = node.getAllInetAddresses();
        int protocolOffset = 0;
        
        /* Determine our acceptable protocols */
		String[] sslProtocols=node.getSecurityParameters().getEnabledProtocols();
		if(sslProtocols==null) {
			sslProtocols=new String[] {"SSL"};
		}
		
        do {
            /* Connect to the remote machine */
            try {
                /* Attach using SSL and initiate a handshake */
                SSLContext sslContext = SSLContext.getInstance(sslProtocols[protocolOffset]/*,node.getSecurityParameters().getSecurityProvider()*/);
                sslContext.init(node.getSecurityParameters().getKeystoreManager().getKeyManagers(), node.getSecurityParameters().getKeystoreManager().getTrustManagers(), null);

                if (sslContext == null) {
                    Security.addProvider(node.getSecurityParameters().getSecurityProvider());

                    _socket = SSLSocketFactory.getDefault().createSocket(addrs[offset], port);
                    ((SSLSocket) _socket).addHandshakeCompletedListener(new HandshakeCompletedListener() {
                        public void handshakeCompleted(HandshakeCompletedEvent e) {
                        	System.out.println("handshake complete");	
                        }
                    });

                    ((SSLSocket) _socket).startHandshake();
                }
                else {
                    _socket = sslContext.getSocketFactory().createSocket(addrs[offset], port);
                    ((SSLSocket) _socket).addHandshakeCompletedListener(new HandshakeCompletedListener() {
                        public void handshakeCompleted(HandshakeCompletedEvent e) {
							//System.out.println("handshake complete");	
                        }
                    });
                }
                
				String[] cyphers=node.getSecurityParameters().getEnabledCipherSuites();
				if(cyphers!=null) {
					((SSLSocket) _socket).setEnabledCipherSuites(node.getSecurityParameters().getEnabledCipherSuites());
				}
				else {
					((SSLSocket) _socket).setEnabledCipherSuites(((SSLSocket)_socket).getSupportedCipherSuites());
				}
				((SSLSocket) _socket).setUseClientMode(true);
                
				//((SSLSocket) _socket).startHandshake();

                /* The underlying JSSE code returns the SSL socket before all
                 * the SSL handshakes, including client authentication, are
                 * completed.  The handshake carries on, asynchronously, in
                 * the background. If the handshake fails then the socket is
                 * not usable. We synchronize things by calling getSession()
                 * on the SSL socket.  The thread calling getSession() is
                 * forced to wait until the underlying SSL handshake is completed,
                 *  and if the handshake fails then getSession() returns a null.
                 */
                SSLSession session = ((SSLSocket) _socket).getSession();

                /* If we could not establish a session we should throw an exception */
                if (session==null) {
                	//System.out.println("Handshake failed"); 
                    throw new UntrustedAgentControllerException();
                }
                if(session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
					throw new UntrustedAgentControllerException();
                }
				break;
            }
            catch (ConnectException e) {
                offset++;
                //System.out.println(e.getMessage());
                if (offset == addrs.length) {
                    throw e;
                }
                /* Reset protocol offset */
                protocolOffset = 0;
            }
            catch (NoSuchAlgorithmException e) {
                /* Try another protocol if there are any left */
                protocolOffset++;
                if (protocolOffset == sslProtocols.length) {
                    throw new ConnectException("Could not get an SSLContext. All protocol specifications were tried");
                }
            }
            catch (KeyManagementException e) {
                /* We need to handle this */
            }
        }
        while (offset < addrs.length);

        _node = node;
        this.init();
    }

}