/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.uml2sd.ui.load.BackgroundLoader;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * The main plugin class to be used in the desktop.
 */
public class SDViewerPlugin extends AbstractUIPlugin {

	public static final String LOADER_TAG = "uml2SDLoader"; //$NON-NLS-1$
	
	//The shared instance.
	private static SDViewerPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public SDViewerPlugin(IPluginDescriptor descriptor)
   {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle = descriptor.getResourceBundle(); 
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
		createLastLoaderIfAny(descriptor);
	}

	/**
	 * Loads the last loader again (if still here!)
	 */
	private void createLastLoaderIfAny(IPluginDescriptor descriptor)
	{
		IExtensionPoint iep	= descriptor.getExtensionPoint(LOADER_TAG);
		IExtension ie[] = iep.getExtensions();
		
		Preferences p = getPluginPreferences();
		String lastLoader = p.getString(LOADER_TAG);
		
		if (ie==null || lastLoader == null || lastLoader.length() == 0) return;
		for (int i = 0; i < ie.length; i++)
		{
			IExtension e = ie[i];
			IConfigurationElement c[] = e.getConfigurationElements();
			for (int j = 0; j < c.length; j++) {
				if (c[j].getName().equals(LOADER_TAG)) {
					String attr_class = c[j].getAttribute("class"); //$NON-NLS-1$
					
					if (lastLoader.equals(attr_class)) {
						try {
							Object obj = c[j].createExecutableExtension("class");//$NON-NLS-1$
							IUml2SDLoader l = (IUml2SDLoader)obj;
							LoadersManager.getLoadersManager().setCurrentLoader(l);
						} catch (CoreException e4) {
							System.err.println("Error 'uml2SDLoader' Extension point :"+e4);//$NON-NLS-1$
						} catch(Exception e5) {
							System.err.println("Error 'uml2SDLoader' Extension point :"+e5);//$NON-NLS-1$
						}
						return;
					}
				}
			}
		}
	}
	
	/**
	 * Saves the last loader in order to reload it on next session.
	 */
	public void setLastLoader(String id) {
		Preferences p = getPluginPreferences();
		p.setValue(LOADER_TAG, id);
	}
	
	public void shutdown() throws CoreException {
		BackgroundLoader.shutdown();
		super.shutdown();
	}
	
	/**
	 * Returns the shared instance.
	 */
	public static SDViewerPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= SDViewerPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}


	private static URL BASIC_URL=null;
	static
	{
		//URL to get images from plugins
		//perhaps we can found better code to load images ...
		//but at this time I know this: 
		try {
		BASIC_URL = new URL( "platform", "localhost", "plugin");//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch( Exception E ) {
			System.err.println(E);
		}
	}

	public static ImageDescriptor getResourceImage( String _name )
	{
		try {
		 URL url=new URL( BASIC_URL, "plugin/org.eclipse.hyades.uml2sd.ui/icons/"+_name);//$NON-NLS-1$
		 ImageDescriptor img = ImageDescriptor.createFromURL( url );
		return img ;
		} catch( Exception E ) {
					 System.err.println(E);
		}
		return null;
	}
	
	public static String getId()
	{
		return getDefault().getDescriptor().getUniqueIdentifier();
	}
}
