/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDGraphNodeSupporter;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.util.ContextIDs;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * This is the common dialog to define Find and/or Filter Criteria(s)
 */
public class SearchFilterDialog extends Dialog {
	
	/**
	 * viewer
	 */
	private SDView viewer = null;

	/**
	 * tab with the controls for a Criteria
	 */
	private TabFolder tab = null;
	
	/**
	 * Criteria updated by this dialog
	 */
	private Criteria criteria = null;	
	
	/**
	 * find/filter provider telling wich graph nodes are supported
	 */
	private ISDGraphNodeSupporter provider = null;
	
	/**
	 * okText is the text for the Ok button and title is the title of the dialog.<br>
	 * Both depend on the usage that is done of this dialog (find or filter).
	 */
	private String okText, title;
	
	 
	/**
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	public Control createDialogArea(Composite arg0) 
	{
		if (provider instanceof ISDFindProvider)
			WorkbenchHelp.setHelp(arg0,SDViewerPlugin.getId()+ContextIDs.UML2SDFIND);
		else if (provider instanceof ISDFilterProvider)
			WorkbenchHelp.setHelp(arg0,SDViewerPlugin.getId()+ContextIDs.UML2SDFILTER);
		return new TabContents(arg0,provider);
	}
	
	/**
	 * @param theView
	 * @param _provider
	 */
	public SearchFilterDialog (SDView view_, ISDGraphNodeSupporter provider_) {
		super (view_.getSDWidget().getShell());
		provider = provider_;
		viewer = view_;
		setShellStyle(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
	}
	
	
	/**
	 * Open the dialog box
	 */
	public int open()
	{
		create();
		if (criteria != null) {
			copyFromCriteria(criteria);
			criteria = null;
		}
		if (okText != null) {
			getButton(IDialogConstants.OK_ID).setText(okText);
		} else {
			getButton(IDialogConstants.OK_ID).setText(SDViewerPlugin.getResourceString("SEARCH_DIALOG_SEARCH_BUTTON")); //$NON-NLS-1$
		}
		if (title != null) {
			getShell().setText(title);
		} else {
			getShell().setText(SDViewerPlugin.getResourceString("SEARCH_DIALOG_TITLE")); //$NON-NLS-1$
		}
		getShell().pack();
		getShell().setLocation(getShell().getDisplay().getCursorLocation());
		return super.open();
	}
	
	/**
	 * Called when the dialog box ok button is pressed
	 * and call back the appropriate action provider (ISDFilterProvider or ISDFindProvider)
	 */
	public void okPressed()
	{
		criteria = new Criteria();
		TabContents content = null;
		if (tab == null)
			content = (TabContents)getDialogArea();
		else content = (TabContents)tab.getSelection()[0].getControl();
		copyToCriteria(content);
		super.close();
		if ((provider != null)&&(provider instanceof ISDFindProvider)) {
			((ISDFindProvider)provider).find(criteria);
		}
	}
	

	public Criteria getCriteria() {
		return criteria;
	}

	/**
	 * @param criteria_
	 */
	public void setCriteria(Criteria criteria_) {
		criteria = criteria_;
	}

	/**
	 * Get the current end-user settings from the dialog to a Criteria
	 * @param content
	 */
	public void copyToCriteria(TabContents content) {
		criteria.setLifeLineSelected(content.getLifelineButtonSelection());
		criteria.setSyncMessageSelected(content.getSynMessageButtonSelection());
		criteria.setSyncMessageReturnSelected(content.getSynMessageReturnButtonSelection());
		criteria.setAsyncMessageSelected(content.getAsynMessageButtonSelection());
		criteria.setAsyncMessageReturnSelected(content.getAsynMessageReturnButtonSelection());
		criteria.setStopSelected(content.getStopButtonSelection());
		criteria.setCaseSenstiveSelected(content.getCaseSensitiveSelection());
		criteria.setExpression(content.getSearchText());
	}

	/**
	 * Initialize the dialog with the settings of an existing Criteria<br>
	 * Criteria must not be null and the TabContents must has been created
	 * @param from
	 */
	public void copyFromCriteria(Criteria from) {
		TabContents content = (TabContents)getDialogArea();
		content.setLifelineButtonSelection(from.isLifeLineSelected());
		content.setSynMessageButtonSelection(from.isSyncMessageSelected());
		content.setSynMessageReturnButtonSelection(from.isSyncMessageReturnSelected());
		content.setAsynMessageButtonSelection(from.isAsyncMessageSelected());
		content.setAsynMessageReturnButtonSelection(from.isSyncMessageReturnSelected());
		content.setStopButtonSelection(from.isStopSelected());
		content.setCaseSensitiveSelection(from.isCaseSenstiveSelected());
		if (from.getExpression() != null) {
			content.setSearchText(from.getExpression());
		}
	}

	/**
	 * @param okText_
	 */
	public void setOkText(String okText_) {
		okText = okText_;
	}

	/**
	 * @param title_
	 */
	public void setTitle(String title_) {
		title = title_;
	}
}

