/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.drawings;


/**
 * @author sveyrier
 *
 */
public interface ISDPreferences {
	
	/**
	 * The link font with zoom preference name
	 */
	public static final String PREF_LINK_FONT = "PREF_LINK_FONT"; //$NON-NLS-1$
	/**
	 * The use gradient color preferences name
	 */
	public static final String PREF_USE_GRADIENT = "PREF_USE_GRADIENT"; //$NON-NLS-1$
	/**
	 * The lifeline spacing width preference name
	 */
	public static final String PREF_LIFELINE_WIDTH = "PREF_LIFELINE_WIDTH"; //$NON-NLS-1$
	/**
	 * The time compression bar font preference name
	 */
	public static final String PREF_TIME_COMP = "PREF_TIME_COMP"; //$NON-NLS-1$
	/**
	 * The lifeline font preference name
	 */
	public static final String PREF_LIFELINE = "PREF_LIFELINE"; //$NON-NLS-1$
	/**
	 * The frame font preference name
	 */
	public static final String PREF_FRAME = "PREF_FRAME"; //$NON-NLS-1$
	/**
	 * The frame name font preference name
	 */
	public static final String PREF_FRAME_NAME = "PREF_FRAME_NAME"; //$NON-NLS-1$
	/**
	 * The execution occurrence font preference name
	 */
	public static final String PREF_EXEC = "PREF_EXEC"; //$NON-NLS-1$
	/**
	 * The synchronous message font preference name
	 */
	public static final String PREF_SYNC_MESS = "PREF_SYNC_MESS"; //$NON-NLS-1$
	/**
	 * The synchronous message return font preference name
	 */
	public static final String PREF_SYNC_MESS_RET = "PREF_SYNC_MESS_RET"; //$NON-NLS-1$
	/**
	 * The asynchronous message font preference name
	 */
	public static final String PREF_ASYNC_MESS = "PREF_ASYNC_MESS"; //$NON-NLS-1$
	/**
	 * The asynchronous message return font preference name
	 */
	public static final String PREF_ASYNC_MESS_RET = "PREF_ASYNC_MESS_RET"; //$NON-NLS-1$
	
	/**
	 * Returns the background color for the given preference name (font preference name)
	 * @param prefId the preference nam
	 * @return the color
	 */	
	public IColor getBackGroundColor(String prefId);
	/**
	 * Returns the foreground color for the given preference name (font preference name)
	 * @param prefId
	 * @return the color
	 */
	public IColor getForeGroundColor(String prefId);
	
	/**
	 * Returns the font for the given preference name
	 * @param prefId the preference name
	 * @return the font 
	 */
	public IFont getFont(String prefId);
	
	/**
	 * Returns the time compression bar selection color
	 * @return
	 */
	public IColor getTimeCompressionSelectionColor();
	
	/**
	 * Returns the background color used to draw selection
	 * @return the color
	 */
	public IColor getBackGroundColorSelection();
	/**
	 * Returns the foreground color used to draw selection
	 * @return the color
	 */
	public IColor getForeGroundColorSelection();
	
	public boolean useGradienColor();
		
}
