/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.util;

import java.util.Comparator;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
/**
 * Synchrnous message comparator
 * Compare two syncMessages only taking into account 
 * the event occurrence when their appear.<br>
 * 
 * The message with the greater event occurrence is considered to 
 * be the greater.<br>
 * 
 * @author sveyrier
 *
 */
public class SortAsyncMessageComparator implements Comparator{
	
	/**
	 * Compares two synchronous syncMessages
	 * Returns 0 (equal) if one of the message is not synchrnous
	 * @return 1 if arg0 is greater, 0 if equal, -1 otherwise
	 */
	public int compare(Object arg0, Object arg1) {
		if (arg0 instanceof AsyncMessage && arg1 instanceof AsyncMessage)
		{
			AsyncMessage m1 = (AsyncMessage)arg0;
			AsyncMessage m2 = (AsyncMessage)arg1;
			int m1Min,m2Min;
			if (m1.getStartOccurrence()>m1.getEndOccurrence())
				m1Min=m1.getEndOccurrence();
			else m1Min=m1.getStartOccurrence();
			if(m2.getStartOccurrence()>m2.getEndOccurrence())
				m2Min=m2.getEndOccurrence();
			else m2Min=m2.getStartOccurrence();
			
			if (m1Min>m2Min)
				return 1;
			else if (m1Min == m2Min)
				return 0;
			else return -1;
		}
		else return 0;
	}

}
