/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.util;

import java.util.Comparator;

import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
/**
 * Synchrnous message comparator
 * Compare two syncMessages only taking into account 
 * the event occurrence when their appear.<br>
 * 
 * The message with the greater event occurrence is considered to 
 * be the greater.<br>
 * 
 * @author sveyrier
 *
 */
public class SortSyncMessageComparator implements Comparator{
	
	/**
	 * Compares two synchronous syncMessages
	 * Returns 0 (equal) if one of the message is not synchrnous
	 * @return 1 if arg0 is greater, 0 if equal, -1 otherwise
	 */
	public int compare(Object arg0, Object arg1) {
		if (arg0 instanceof SyncMessage && arg1 instanceof SyncMessage)
		{
			SyncMessage m1 = (SyncMessage)arg0;
			SyncMessage m2 = (SyncMessage)arg1;
			if (m1.getEventOccurrence()>m2.getEventOccurrence())
				return 1;
			else if (m1.getEventOccurrence() == m2.getEventOccurrence())
				return 0;
			else return -1;
		}
		else return 0;
	}

}
