/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ztest;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Stop;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
/**
 * @author sveyrier
 *
 */
public class ProtoLauncher {

	public static void main(String[] args) 
	{
		Device.DEBUG=true;
		final Display display = new Display ();
		Device.DEBUG=true;
		//Sleak sleak = new Sleak();
		//sleak.open();


		
		final Shell shell = new Shell (display);
		shell.setLayout(new FillLayout());
		
		final SDWidget v = new SDWidget(shell, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
		final Frame testFrame = new Frame();
		
		testFrame.setName("Sequence Diagram"); //$NON-NLS-1$
		
		Lifeline lifeline=new Lifeline();
		lifeline.setName("LifeLine " + 0); //$NON-NLS-1$
		testFrame.addLifeLine(lifeline);
		SyncMessage mn = new SyncMessage();
		lifeline.getNewEventOccurrence();
		mn.setStartLifeline(lifeline);
		mn.setName("test 1"); //$NON-NLS-1$
		testFrame.addMessage(mn);
		SyncMessage mn2 = new SyncMessage();
		lifeline.getNewEventOccurrence();
		mn2.setEndLifeline(lifeline);
		mn2.setName("test2"); //$NON-NLS-1$
		testFrame.addMessage(mn2);
		for (int i=1;i<10000;i++)
		{
			lifeline=new Lifeline();
			lifeline.setName("LifeLine " + i); //$NON-NLS-1$
			testFrame.addLifeLine(lifeline);

			SyncMessage m3 = new SyncMessage();
			testFrame.getLifeline(i-1).getNewEventOccurrence();
			m3.setStartLifeline(testFrame.getLifeline(i-1));
			m3.setEndLifeline(testFrame.getLifeline(i));
/*			((Lifeline)testFrame.getLifelines().get(0)).getNewOccurrenceIndex();
			m3.setStartLifeline((Lifeline)testFrame.getLifelines().get(0));
			m3.setEndLifeline((Lifeline)testFrame.getLifelines().get(0));
			m3.setStartOccurrence(4);
			m3.setEndOccurrence(7);*/
			m3.setName("Message "+i); //$NON-NLS-1$
			testFrame.addMessage(m3);
			
		}
		
		for (int i=testFrame.lifeLinesCount()-1; i > 0; i--)
		{
			SyncMessageReturn m = new SyncMessageReturn();
			testFrame.getLifeline(i).getNewEventOccurrence();
			m.setStartLifeline(testFrame.getLifeline(i));
			m.setEndLifeline(testFrame.getLifeline(i-1));
//			testFrame.addMessageReturn(m);
			testFrame.addMessage(m);
			m.setName("Message return "+i); //$NON-NLS-1$
		}
		
		for (int i=0;i<testFrame.lifeLinesCount();i++)
		{
			if (i>0)
			{
				ExecutionOccurrence occ= new ExecutionOccurrence();
				occ.setStartOccurrence(testFrame.getSyncMessage(i).getEventOccurrence()+1);
				occ.setEndOccurrence(testFrame.getSyncMessage(testFrame.syncMessageCount()-i).getEventOccurrence());
				testFrame.getLifeline(i).addExecution(occ);
			}
		}
		
		Stop s = new Stop();
		s.setEventOccurrence(testFrame.getLifeline(1).getNewEventOccurrence());
		testFrame.getLifeline(1).setStop(s);
		
		AsyncMessageReturn m = new AsyncMessageReturn();
		m.setStartLifeline(testFrame.getLifeline(1));
		m.setEndLifeline(testFrame.getLifeline(1));
		m.setStartOccurrence(6);
		m.setEndOccurrence(10);
		m.setName("Messsage test 1"); //$NON-NLS-1$
		testFrame.addMessage(m);
		
		SyncMessageReturn ma = new SyncMessageReturn();
		testFrame.getLifeline(2).getNewEventOccurrence();
		ma.setStartLifeline(testFrame.getLifeline(2));
		ma.setEndLifeline(testFrame.getLifeline(2));
		ma.setName("Message test 2"); //$NON-NLS-1$
		testFrame.addMessage(ma);
		
//		v.setFrame(testFrame);
		shell.setSize(800,800);
		shell.open ();
		while (!shell.isDisposed ()) 
		{
			if (!display.readAndDispatch ()) display.sleep ();
		}
		display.dispose ();
	}
}
