/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.probekit;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * 
 * <xs:documentation>
 *    See http://www.w3.org/XML/1998/namespace.html and
 *    http://www.w3.org/TR/REC-xml for information about this namespace.
 *   
 * 
 * <xs:documentation>This schema defines attributes and an attribute group
 *         suitable for use by
 *         schemas wishing to allow xml:base, xml:lang or xml:space attributes
 *         on elements they define.
 * 
 *         To enable this, such a schema must import this schema
 *         for the XML namespace, e.g. as follows:
 *         &lt;schema . . .&gt;
 *          . . .
 *          &lt;import namespace="http://www.w3.org/XML/1998/namespace"
 *                     schemaLocation="http://www.w3.org/2001/03/xml.xsd"/&gt;
 * 
 *         Subsequently, qualified reference to any of the attributes
 *         or the group defined below will have the desired effect, e.g.
 * 
 *         &lt;type . . .&gt;
 *          . . .
 *          &lt;attributeGroup ref="xml:specialAttrs"/&gt;
 *  
 *          will define a type which will schema-validate an instance
 *          element with any of those attributes
 * 
 * <xs:documentation>In keeping with the XML Schema WG's standard versioning
 *    policy, this schema document will persist at
 *    http://www.w3.org/2001/03/xml.xsd.
 *    At the date of issue it can also be found at
 *    http://www.w3.org/2001/xml.xsd.
 *    The schema document at that URI may however change in the future,
 *    in order to remain compatible with the latest version of XML Schema
 *    itself.  In other words, if the XML Schema namespace changes, the version
 *    of this document at
 *    http://www.w3.org/2001/xml.xsd will change
 *    accordingly; the version at
 *    http://www.w3.org/2001/03/xml.xsd will not change.
 *   
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.models.probekit.ProbekitFactory
 * @generated
 */
public interface ProbekitPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "probekit";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "platform:/resource/org.eclipse.hyades.models.probekit/src/model/probekit.xsd";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "probekit";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ProbekitPackage eINSTANCE = org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.ControlKeyTypeImpl <em>Control Key Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.ControlKeyTypeImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getControlKeyType()
	 * @generated
	 */
	int CONTROL_KEY_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_KEY_TYPE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_KEY_TYPE__VALUE = 1;

	/**
	 * The number of structural features of the the '<em>Control Key Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_KEY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.ControlNameTypeImpl <em>Control Name Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.ControlNameTypeImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getControlNameType()
	 * @generated
	 */
	int CONTROL_NAME_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_NAME_TYPE__LANG = 0;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_NAME_TYPE__TEXT = 1;

	/**
	 * The number of structural features of the the '<em>Control Name Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_NAME_TYPE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.DataType1Impl <em>Data Type1</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.DataType1Impl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getDataType1()
	 * @generated
	 */
	int DATA_TYPE1 = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE1__NAME = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE1__TYPE = 1;

	/**
	 * The number of structural features of the the '<em>Data Type1</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE1_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.DescriptionTypeImpl <em>Description Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.DescriptionTypeImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getDescriptionType()
	 * @generated
	 */
	int DESCRIPTION_TYPE = 3;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION_TYPE__LANG = 1;

	/**
	 * The number of structural features of the the '<em>Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION_TYPE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.DocumentRootImpl <em>Document Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.DocumentRootImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getDocumentRoot()
	 * @generated
	 */
	int DOCUMENT_ROOT = 4;

	/**
	 * The feature id for the '<em><b>Mixed</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MIXED = 0;

	/**
	 * The feature id for the '<em><b>XMLNS Prefix Map</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XMLNS_PREFIX_MAP = 1;

	/**
	 * The feature id for the '<em><b>XSI Schema Location</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = 2;

	/**
	 * The feature id for the '<em><b>Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CODE = 3;

	/**
	 * The feature id for the '<em><b>Control Key</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CONTROL_KEY = 4;

	/**
	 * The feature id for the '<em><b>Control Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CONTROL_NAME = 5;

	/**
	 * The feature id for the '<em><b>Data</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DATA = 6;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DESCRIPTION = 7;

	/**
	 * The feature id for the '<em><b>Fragment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FRAGMENT = 8;

	/**
	 * The feature id for the '<em><b>Fragment At Class Scope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FRAGMENT_AT_CLASS_SCOPE = 9;

	/**
	 * The feature id for the '<em><b>Import</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__IMPORT = 10;

	/**
	 * The feature id for the '<em><b>Invocation Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__INVOCATION_OBJECT = 11;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__NAME = 12;

	/**
	 * The feature id for the '<em><b>Probe</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PROBE = 13;

	/**
	 * The feature id for the '<em><b>Probekit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PROBEKIT = 14;

	/**
	 * The feature id for the '<em><b>Static Field</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__STATIC_FIELD = 15;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TARGET = 16;

	/**
	 * The number of structural features of the the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT_FEATURE_COUNT = 17;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.FragmentType1Impl <em>Fragment Type1</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.FragmentType1Impl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getFragmentType1()
	 * @generated
	 */
	int FRAGMENT_TYPE1 = 5;

	/**
	 * The feature id for the '<em><b>Data</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FRAGMENT_TYPE1__DATA = 0;

	/**
	 * The feature id for the '<em><b>Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FRAGMENT_TYPE1__CODE = 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FRAGMENT_TYPE1__TYPE = 2;

	/**
	 * The number of structural features of the the '<em>Fragment Type1</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FRAGMENT_TYPE1_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.ImportTypeImpl <em>Import Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.ImportTypeImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getImportType()
	 * @generated
	 */
	int IMPORT_TYPE = 6;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPORT_TYPE__TEXT = 0;

	/**
	 * The number of structural features of the the '<em>Import Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPORT_TYPE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.InvocationObjectTypeImpl <em>Invocation Object Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.InvocationObjectTypeImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getInvocationObjectType()
	 * @generated
	 */
	int INVOCATION_OBJECT_TYPE = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_OBJECT_TYPE__NAME = 0;

	/**
	 * The number of structural features of the the '<em>Invocation Object Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_OBJECT_TYPE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.NameTypeImpl <em>Name Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.NameTypeImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getNameType()
	 * @generated
	 */
	int NAME_TYPE = 8;

	/**
	 * The feature id for the '<em><b>Lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_TYPE__LANG = 0;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_TYPE__TEXT = 1;

	/**
	 * The number of structural features of the the '<em>Name Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_TYPE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.ProbekitTypeImpl <em>Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitTypeImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getProbekitType()
	 * @generated
	 */
	int PROBEKIT_TYPE = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBEKIT_TYPE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBEKIT_TYPE__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Probe</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBEKIT_TYPE__PROBE = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBEKIT_TYPE__ID = 3;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBEKIT_TYPE__VERSION = 4;

	/**
	 * The number of structural features of the the '<em>Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBEKIT_TYPE_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl <em>Probe Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getProbeType()
	 * @generated
	 */
	int PROBE_TYPE = 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Control Key</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE__CONTROL_KEY = 2;

	/**
	 * The feature id for the '<em><b>Control Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE__CONTROL_NAME = 3;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE__TARGET = 4;

	/**
	 * The feature id for the '<em><b>Import</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE__IMPORT = 5;

	/**
	 * The feature id for the '<em><b>Fragment At Class Scope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE__FRAGMENT_AT_CLASS_SCOPE = 6;

	/**
	 * The feature id for the '<em><b>Fragment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE__FRAGMENT = 7;

	/**
	 * The feature id for the '<em><b>Invocation Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE__INVOCATION_OBJECT = 8;

	/**
	 * The feature id for the '<em><b>Static Field</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE__STATIC_FIELD = 9;

	/**
	 * The number of structural features of the the '<em>Probe Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_TYPE_FEATURE_COUNT = 10;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.StaticFieldTypeImpl <em>Static Field Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.StaticFieldTypeImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getStaticFieldType()
	 * @generated
	 */
	int STATIC_FIELD_TYPE = 11;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_FIELD_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_FIELD_TYPE__TYPE = 1;

	/**
	 * The number of structural features of the the '<em>Static Field Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATIC_FIELD_TYPE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.impl.TargetTypeImpl <em>Target Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.impl.TargetTypeImpl
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getTargetType()
	 * @generated
	 */
	int TARGET_TYPE = 12;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_TYPE__CLASS_NAME = 0;

	/**
	 * The feature id for the '<em><b>Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_TYPE__METHOD = 1;

	/**
	 * The feature id for the '<em><b>Package</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_TYPE__PACKAGE = 2;

	/**
	 * The feature id for the '<em><b>Signature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_TYPE__SIGNATURE = 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_TYPE__TYPE = 4;

	/**
	 * The number of structural features of the the '<em>Target Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_TYPE_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.DataType <em>Data Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.DataType
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getDataType()
	 * @generated
	 */
	int DATA_TYPE = 13;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.FragmentType <em>Fragment Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.FragmentType
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getFragmentType()
	 * @generated
	 */
	int FRAGMENT_TYPE = 14;

	/**
	 * The meta object id for the '<em>Data Type Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.DataType
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getDataTypeObject()
	 * @generated
	 */
	int DATA_TYPE_OBJECT = 15;

	/**
	 * The meta object id for the '<em>Fragment Type Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.FragmentType
	 * @see org.eclipse.hyades.models.probekit.impl.ProbekitPackageImpl#getFragmentTypeObject()
	 * @generated
	 */
	int FRAGMENT_TYPE_OBJECT = 16;


	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.ControlKeyType <em>Control Key Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Control Key Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.ControlKeyType
	 * @generated
	 */
	EClass getControlKeyType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.ControlKeyType#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.ControlKeyType#getName()
	 * @see #getControlKeyType()
	 * @generated
	 */
	EAttribute getControlKeyType_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.ControlKeyType#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.probekit.ControlKeyType#getValue()
	 * @see #getControlKeyType()
	 * @generated
	 */
	EAttribute getControlKeyType_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.ControlNameType <em>Control Name Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Control Name Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.ControlNameType
	 * @generated
	 */
	EClass getControlNameType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.ControlNameType#getLang <em>Lang</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lang</em>'.
	 * @see org.eclipse.hyades.models.probekit.ControlNameType#getLang()
	 * @see #getControlNameType()
	 * @generated
	 */
	EAttribute getControlNameType_Lang();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.ControlNameType#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see org.eclipse.hyades.models.probekit.ControlNameType#getText()
	 * @see #getControlNameType()
	 * @generated
	 */
	EAttribute getControlNameType_Text();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.DataType1 <em>Data Type1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Type1</em>'.
	 * @see org.eclipse.hyades.models.probekit.DataType1
	 * @generated
	 */
	EClass getDataType1();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.DataType1#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.DataType1#getName()
	 * @see #getDataType1()
	 * @generated
	 */
	EAttribute getDataType1_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.DataType1#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.DataType1#getType()
	 * @see #getDataType1()
	 * @generated
	 */
	EAttribute getDataType1_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.DescriptionType <em>Description Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Description Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.DescriptionType
	 * @generated
	 */
	EClass getDescriptionType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.DescriptionType#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.probekit.DescriptionType#getValue()
	 * @see #getDescriptionType()
	 * @generated
	 */
	EAttribute getDescriptionType_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.DescriptionType#getLang <em>Lang</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lang</em>'.
	 * @see org.eclipse.hyades.models.probekit.DescriptionType#getLang()
	 * @see #getDescriptionType()
	 * @generated
	 */
	EAttribute getDescriptionType_Lang();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.DocumentRoot <em>Document Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document Root</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot
	 * @generated
	 */
	EClass getDocumentRoot();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getMixed <em>Mixed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mixed</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getMixed()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_Mixed();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>XMLNS Prefix Map</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getXMLNSPrefixMap()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_XMLNSPrefixMap();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getXSISchemaLocation <em>XSI Schema Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>XSI Schema Location</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getXSISchemaLocation()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_XSISchemaLocation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getCode <em>Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Code</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getCode()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_Code();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getControlKey <em>Control Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Control Key</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getControlKey()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_ControlKey();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getControlName <em>Control Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Control Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getControlName()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_ControlName();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getData <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Data</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getData()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_Data();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Description</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getDescription()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_Description();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getFragment <em>Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Fragment</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getFragment()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_Fragment();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getFragmentAtClassScope <em>Fragment At Class Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fragment At Class Scope</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getFragmentAtClassScope()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_FragmentAtClassScope();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getImport <em>Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Import</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getImport()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_Import();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getInvocationObject <em>Invocation Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation Object</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getInvocationObject()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_InvocationObject();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getName()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_Name();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getProbe <em>Probe</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Probe</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getProbe()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_Probe();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getProbekit <em>Probekit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Probekit</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getProbekit()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_Probekit();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getStaticField <em>Static Field</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Static Field</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getStaticField()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_StaticField();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.DocumentRoot#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Target</em>'.
	 * @see org.eclipse.hyades.models.probekit.DocumentRoot#getTarget()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_Target();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.FragmentType1 <em>Fragment Type1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Fragment Type1</em>'.
	 * @see org.eclipse.hyades.models.probekit.FragmentType1
	 * @generated
	 */
	EClass getFragmentType1();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.FragmentType1#getData <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Data</em>'.
	 * @see org.eclipse.hyades.models.probekit.FragmentType1#getData()
	 * @see #getFragmentType1()
	 * @generated
	 */
	EReference getFragmentType1_Data();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.FragmentType1#getCode <em>Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Code</em>'.
	 * @see org.eclipse.hyades.models.probekit.FragmentType1#getCode()
	 * @see #getFragmentType1()
	 * @generated
	 */
	EAttribute getFragmentType1_Code();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.FragmentType1#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.FragmentType1#getType()
	 * @see #getFragmentType1()
	 * @generated
	 */
	EAttribute getFragmentType1_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.ImportType <em>Import Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Import Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.ImportType
	 * @generated
	 */
	EClass getImportType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.ImportType#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see org.eclipse.hyades.models.probekit.ImportType#getText()
	 * @see #getImportType()
	 * @generated
	 */
	EAttribute getImportType_Text();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.InvocationObjectType <em>Invocation Object Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Invocation Object Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.InvocationObjectType
	 * @generated
	 */
	EClass getInvocationObjectType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.InvocationObjectType#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.InvocationObjectType#getName()
	 * @see #getInvocationObjectType()
	 * @generated
	 */
	EAttribute getInvocationObjectType_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.NameType <em>Name Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Name Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.NameType
	 * @generated
	 */
	EClass getNameType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.NameType#getLang <em>Lang</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lang</em>'.
	 * @see org.eclipse.hyades.models.probekit.NameType#getLang()
	 * @see #getNameType()
	 * @generated
	 */
	EAttribute getNameType_Lang();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.NameType#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see org.eclipse.hyades.models.probekit.NameType#getText()
	 * @see #getNameType()
	 * @generated
	 */
	EAttribute getNameType_Text();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.ProbekitType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbekitType
	 * @generated
	 */
	EClass getProbekitType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.ProbekitType#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbekitType#getName()
	 * @see #getProbekitType()
	 * @generated
	 */
	EReference getProbekitType_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.ProbekitType#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Description</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbekitType#getDescription()
	 * @see #getProbekitType()
	 * @generated
	 */
	EReference getProbekitType_Description();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.ProbekitType#getProbe <em>Probe</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Probe</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbekitType#getProbe()
	 * @see #getProbekitType()
	 * @generated
	 */
	EReference getProbekitType_Probe();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.ProbekitType#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbekitType#getId()
	 * @see #getProbekitType()
	 * @generated
	 */
	EAttribute getProbekitType_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.ProbekitType#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbekitType#getVersion()
	 * @see #getProbekitType()
	 * @generated
	 */
	EAttribute getProbekitType_Version();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.ProbeType <em>Probe Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Probe Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType
	 * @generated
	 */
	EClass getProbeType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.ProbeType#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType#getName()
	 * @see #getProbeType()
	 * @generated
	 */
	EReference getProbeType_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.ProbeType#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Description</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType#getDescription()
	 * @see #getProbeType()
	 * @generated
	 */
	EReference getProbeType_Description();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.ProbeType#getControlKey <em>Control Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Control Key</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType#getControlKey()
	 * @see #getProbeType()
	 * @generated
	 */
	EReference getProbeType_ControlKey();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.ProbeType#getControlName <em>Control Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Control Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType#getControlName()
	 * @see #getProbeType()
	 * @generated
	 */
	EReference getProbeType_ControlName();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.ProbeType#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Target</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType#getTarget()
	 * @see #getProbeType()
	 * @generated
	 */
	EReference getProbeType_Target();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.ProbeType#getImport <em>Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Import</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType#getImport()
	 * @see #getProbeType()
	 * @generated
	 */
	EReference getProbeType_Import();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.ProbeType#getFragmentAtClassScope <em>Fragment At Class Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fragment At Class Scope</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType#getFragmentAtClassScope()
	 * @see #getProbeType()
	 * @generated
	 */
	EAttribute getProbeType_FragmentAtClassScope();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.ProbeType#getFragment <em>Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Fragment</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType#getFragment()
	 * @see #getProbeType()
	 * @generated
	 */
	EReference getProbeType_Fragment();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.ProbeType#getInvocationObject <em>Invocation Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation Object</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType#getInvocationObject()
	 * @see #getProbeType()
	 * @generated
	 */
	EReference getProbeType_InvocationObject();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.ProbeType#getStaticField <em>Static Field</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Static Field</em>'.
	 * @see org.eclipse.hyades.models.probekit.ProbeType#getStaticField()
	 * @see #getProbeType()
	 * @generated
	 */
	EReference getProbeType_StaticField();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.StaticFieldType <em>Static Field Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Static Field Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.StaticFieldType
	 * @generated
	 */
	EClass getStaticFieldType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.StaticFieldType#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.probekit.StaticFieldType#getValue()
	 * @see #getStaticFieldType()
	 * @generated
	 */
	EAttribute getStaticFieldType_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.StaticFieldType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.StaticFieldType#getType()
	 * @see #getStaticFieldType()
	 * @generated
	 */
	EAttribute getStaticFieldType_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.TargetType <em>Target Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Target Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.TargetType
	 * @generated
	 */
	EClass getTargetType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.TargetType#getClassName <em>Class Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Class Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.TargetType#getClassName()
	 * @see #getTargetType()
	 * @generated
	 */
	EAttribute getTargetType_ClassName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.TargetType#getMethod <em>Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Method</em>'.
	 * @see org.eclipse.hyades.models.probekit.TargetType#getMethod()
	 * @see #getTargetType()
	 * @generated
	 */
	EAttribute getTargetType_Method();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.TargetType#getPackage <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Package</em>'.
	 * @see org.eclipse.hyades.models.probekit.TargetType#getPackage()
	 * @see #getTargetType()
	 * @generated
	 */
	EAttribute getTargetType_Package();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.TargetType#getSignature <em>Signature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Signature</em>'.
	 * @see org.eclipse.hyades.models.probekit.TargetType#getSignature()
	 * @see #getTargetType()
	 * @generated
	 */
	EAttribute getTargetType_Signature();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.TargetType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.TargetType#getType()
	 * @see #getTargetType()
	 * @generated
	 */
	EAttribute getTargetType_Type();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.probekit.DataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Data Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.DataType
	 * @generated
	 */
	EEnum getDataType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.probekit.FragmentType <em>Fragment Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Fragment Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.FragmentType
	 * @generated
	 */
	EEnum getFragmentType();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.hyades.models.probekit.DataType <em>Data Type Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Data Type Object</em>'.
	 * @see org.eclipse.hyades.models.probekit.DataType
	 * @model instanceClass="org.eclipse.hyades.models.probekit.DataType"
	 * @generated
	 */
	EDataType getDataTypeObject();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.hyades.models.probekit.FragmentType <em>Fragment Type Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Fragment Type Object</em>'.
	 * @see org.eclipse.hyades.models.probekit.FragmentType
	 * @model instanceClass="org.eclipse.hyades.models.probekit.FragmentType"
	 * @generated
	 */
	EDataType getFragmentTypeObject();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ProbekitFactory getProbekitFactory();

} //ProbekitPackage
