/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.probekit.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.models.probekit.ControlKeyType;
import org.eclipse.hyades.models.probekit.ControlNameType;
import org.eclipse.hyades.models.probekit.DescriptionType;
import org.eclipse.hyades.models.probekit.FragmentType1;
import org.eclipse.hyades.models.probekit.ImportType;
import org.eclipse.hyades.models.probekit.InvocationObjectType;
import org.eclipse.hyades.models.probekit.NameType;
import org.eclipse.hyades.models.probekit.ProbeType;
import org.eclipse.hyades.models.probekit.ProbekitPackage;
import org.eclipse.hyades.models.probekit.StaticFieldType;
import org.eclipse.hyades.models.probekit.TargetType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Probe Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl#getControlKey <em>Control Key</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl#getControlName <em>Control Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl#getTarget <em>Target</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl#getImport <em>Import</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl#getFragmentAtClassScope <em>Fragment At Class Scope</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl#getFragment <em>Fragment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl#getInvocationObject <em>Invocation Object</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.impl.ProbeTypeImpl#getStaticField <em>Static Field</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ProbeTypeImpl extends EObjectImpl implements ProbeType {
	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected EList name = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected EList description = null;

	/**
	 * The cached value of the '{@link #getControlKey() <em>Control Key</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getControlKey()
	 * @generated
	 * @ordered
	 */
	protected ControlKeyType controlKey = null;

	/**
	 * The cached value of the '{@link #getControlName() <em>Control Name</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getControlName()
	 * @generated
	 * @ordered
	 */
	protected EList controlName = null;

	/**
	 * The cached value of the '{@link #getTarget() <em>Target</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTarget()
	 * @generated
	 * @ordered
	 */
	protected EList target = null;

	/**
	 * The cached value of the '{@link #getImport() <em>Import</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImport()
	 * @generated
	 * @ordered
	 */
	protected EList import_ = null;

	/**
	 * The default value of the '{@link #getFragmentAtClassScope() <em>Fragment At Class Scope</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFragmentAtClassScope()
	 * @generated
	 * @ordered
	 */
	protected static final String FRAGMENT_AT_CLASS_SCOPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFragmentAtClassScope() <em>Fragment At Class Scope</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFragmentAtClassScope()
	 * @generated
	 * @ordered
	 */
	protected String fragmentAtClassScope = FRAGMENT_AT_CLASS_SCOPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getFragment() <em>Fragment</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFragment()
	 * @generated
	 * @ordered
	 */
	protected EList fragment = null;

	/**
	 * The cached value of the '{@link #getInvocationObject() <em>Invocation Object</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvocationObject()
	 * @generated
	 * @ordered
	 */
	protected InvocationObjectType invocationObject = null;

	/**
	 * The cached value of the '{@link #getStaticField() <em>Static Field</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStaticField()
	 * @generated
	 * @ordered
	 */
	protected StaticFieldType staticField = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProbeTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ProbekitPackage.eINSTANCE.getProbeType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getName() {
		if (name == null) {
			name = new EObjectContainmentEList(NameType.class, this, ProbekitPackage.PROBE_TYPE__NAME);
		}
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDescription() {
		if (description == null) {
			description = new EObjectContainmentEList(DescriptionType.class, this, ProbekitPackage.PROBE_TYPE__DESCRIPTION);
		}
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ControlKeyType getControlKey() {
		return controlKey;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetControlKey(ControlKeyType newControlKey, NotificationChain msgs) {
		ControlKeyType oldControlKey = controlKey;
		controlKey = newControlKey;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE_TYPE__CONTROL_KEY, oldControlKey, newControlKey);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setControlKey(ControlKeyType newControlKey) {
		if (newControlKey != controlKey) {
			NotificationChain msgs = null;
			if (controlKey != null)
				msgs = ((InternalEObject)controlKey).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE_TYPE__CONTROL_KEY, null, msgs);
			if (newControlKey != null)
				msgs = ((InternalEObject)newControlKey).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE_TYPE__CONTROL_KEY, null, msgs);
			msgs = basicSetControlKey(newControlKey, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE_TYPE__CONTROL_KEY, newControlKey, newControlKey));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getControlName() {
		if (controlName == null) {
			controlName = new EObjectContainmentEList(ControlNameType.class, this, ProbekitPackage.PROBE_TYPE__CONTROL_NAME);
		}
		return controlName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getTarget() {
		if (target == null) {
			target = new EObjectContainmentEList(TargetType.class, this, ProbekitPackage.PROBE_TYPE__TARGET);
		}
		return target;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getImport() {
		if (import_ == null) {
			import_ = new EObjectContainmentEList(ImportType.class, this, ProbekitPackage.PROBE_TYPE__IMPORT);
		}
		return import_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getFragmentAtClassScope() {
		return fragmentAtClassScope;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFragmentAtClassScope(String newFragmentAtClassScope) {
		String oldFragmentAtClassScope = fragmentAtClassScope;
		fragmentAtClassScope = newFragmentAtClassScope;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE_TYPE__FRAGMENT_AT_CLASS_SCOPE, oldFragmentAtClassScope, fragmentAtClassScope));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getFragment() {
		if (fragment == null) {
			fragment = new EObjectContainmentEList(FragmentType1.class, this, ProbekitPackage.PROBE_TYPE__FRAGMENT);
		}
		return fragment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InvocationObjectType getInvocationObject() {
		return invocationObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInvocationObject(InvocationObjectType newInvocationObject, NotificationChain msgs) {
		InvocationObjectType oldInvocationObject = invocationObject;
		invocationObject = newInvocationObject;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE_TYPE__INVOCATION_OBJECT, oldInvocationObject, newInvocationObject);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInvocationObject(InvocationObjectType newInvocationObject) {
		if (newInvocationObject != invocationObject) {
			NotificationChain msgs = null;
			if (invocationObject != null)
				msgs = ((InternalEObject)invocationObject).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE_TYPE__INVOCATION_OBJECT, null, msgs);
			if (newInvocationObject != null)
				msgs = ((InternalEObject)newInvocationObject).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE_TYPE__INVOCATION_OBJECT, null, msgs);
			msgs = basicSetInvocationObject(newInvocationObject, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE_TYPE__INVOCATION_OBJECT, newInvocationObject, newInvocationObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StaticFieldType getStaticField() {
		return staticField;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStaticField(StaticFieldType newStaticField, NotificationChain msgs) {
		StaticFieldType oldStaticField = staticField;
		staticField = newStaticField;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE_TYPE__STATIC_FIELD, oldStaticField, newStaticField);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStaticField(StaticFieldType newStaticField) {
		if (newStaticField != staticField) {
			NotificationChain msgs = null;
			if (staticField != null)
				msgs = ((InternalEObject)staticField).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE_TYPE__STATIC_FIELD, null, msgs);
			if (newStaticField != null)
				msgs = ((InternalEObject)newStaticField).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE_TYPE__STATIC_FIELD, null, msgs);
			msgs = basicSetStaticField(newStaticField, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE_TYPE__STATIC_FIELD, newStaticField, newStaticField));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ProbekitPackage.PROBE_TYPE__NAME:
					return ((InternalEList)getName()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE_TYPE__DESCRIPTION:
					return ((InternalEList)getDescription()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE_TYPE__CONTROL_KEY:
					return basicSetControlKey(null, msgs);
				case ProbekitPackage.PROBE_TYPE__CONTROL_NAME:
					return ((InternalEList)getControlName()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE_TYPE__TARGET:
					return ((InternalEList)getTarget()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE_TYPE__IMPORT:
					return ((InternalEList)getImport()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE_TYPE__FRAGMENT:
					return ((InternalEList)getFragment()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE_TYPE__INVOCATION_OBJECT:
					return basicSetInvocationObject(null, msgs);
				case ProbekitPackage.PROBE_TYPE__STATIC_FIELD:
					return basicSetStaticField(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProbekitPackage.PROBE_TYPE__NAME:
				return getName();
			case ProbekitPackage.PROBE_TYPE__DESCRIPTION:
				return getDescription();
			case ProbekitPackage.PROBE_TYPE__CONTROL_KEY:
				return getControlKey();
			case ProbekitPackage.PROBE_TYPE__CONTROL_NAME:
				return getControlName();
			case ProbekitPackage.PROBE_TYPE__TARGET:
				return getTarget();
			case ProbekitPackage.PROBE_TYPE__IMPORT:
				return getImport();
			case ProbekitPackage.PROBE_TYPE__FRAGMENT_AT_CLASS_SCOPE:
				return getFragmentAtClassScope();
			case ProbekitPackage.PROBE_TYPE__FRAGMENT:
				return getFragment();
			case ProbekitPackage.PROBE_TYPE__INVOCATION_OBJECT:
				return getInvocationObject();
			case ProbekitPackage.PROBE_TYPE__STATIC_FIELD:
				return getStaticField();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProbekitPackage.PROBE_TYPE__NAME:
				getName().clear();
				getName().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE_TYPE__DESCRIPTION:
				getDescription().clear();
				getDescription().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE_TYPE__CONTROL_KEY:
				setControlKey((ControlKeyType)newValue);
				return;
			case ProbekitPackage.PROBE_TYPE__CONTROL_NAME:
				getControlName().clear();
				getControlName().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE_TYPE__TARGET:
				getTarget().clear();
				getTarget().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE_TYPE__IMPORT:
				getImport().clear();
				getImport().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE_TYPE__FRAGMENT_AT_CLASS_SCOPE:
				setFragmentAtClassScope((String)newValue);
				return;
			case ProbekitPackage.PROBE_TYPE__FRAGMENT:
				getFragment().clear();
				getFragment().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE_TYPE__INVOCATION_OBJECT:
				setInvocationObject((InvocationObjectType)newValue);
				return;
			case ProbekitPackage.PROBE_TYPE__STATIC_FIELD:
				setStaticField((StaticFieldType)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProbekitPackage.PROBE_TYPE__NAME:
				getName().clear();
				return;
			case ProbekitPackage.PROBE_TYPE__DESCRIPTION:
				getDescription().clear();
				return;
			case ProbekitPackage.PROBE_TYPE__CONTROL_KEY:
				setControlKey((ControlKeyType)null);
				return;
			case ProbekitPackage.PROBE_TYPE__CONTROL_NAME:
				getControlName().clear();
				return;
			case ProbekitPackage.PROBE_TYPE__TARGET:
				getTarget().clear();
				return;
			case ProbekitPackage.PROBE_TYPE__IMPORT:
				getImport().clear();
				return;
			case ProbekitPackage.PROBE_TYPE__FRAGMENT_AT_CLASS_SCOPE:
				setFragmentAtClassScope(FRAGMENT_AT_CLASS_SCOPE_EDEFAULT);
				return;
			case ProbekitPackage.PROBE_TYPE__FRAGMENT:
				getFragment().clear();
				return;
			case ProbekitPackage.PROBE_TYPE__INVOCATION_OBJECT:
				setInvocationObject((InvocationObjectType)null);
				return;
			case ProbekitPackage.PROBE_TYPE__STATIC_FIELD:
				setStaticField((StaticFieldType)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProbekitPackage.PROBE_TYPE__NAME:
				return name != null && !name.isEmpty();
			case ProbekitPackage.PROBE_TYPE__DESCRIPTION:
				return description != null && !description.isEmpty();
			case ProbekitPackage.PROBE_TYPE__CONTROL_KEY:
				return controlKey != null;
			case ProbekitPackage.PROBE_TYPE__CONTROL_NAME:
				return controlName != null && !controlName.isEmpty();
			case ProbekitPackage.PROBE_TYPE__TARGET:
				return target != null && !target.isEmpty();
			case ProbekitPackage.PROBE_TYPE__IMPORT:
				return import_ != null && !import_.isEmpty();
			case ProbekitPackage.PROBE_TYPE__FRAGMENT_AT_CLASS_SCOPE:
				return FRAGMENT_AT_CLASS_SCOPE_EDEFAULT == null ? fragmentAtClassScope != null : !FRAGMENT_AT_CLASS_SCOPE_EDEFAULT.equals(fragmentAtClassScope);
			case ProbekitPackage.PROBE_TYPE__FRAGMENT:
				return fragment != null && !fragment.isEmpty();
			case ProbekitPackage.PROBE_TYPE__INVOCATION_OBJECT:
				return invocationObject != null;
			case ProbekitPackage.PROBE_TYPE__STATIC_FIELD:
				return staticField != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (fragmentAtClassScope: ");
		result.append(fragmentAtClassScope);
		result.append(')');
		return result.toString();
	}

} //ProbeTypeImpl
