/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.probekit.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.hyades.models.probekit.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ProbekitFactoryImpl extends EFactoryImpl implements ProbekitFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProbekitFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case ProbekitPackage.CONTROL_KEY_TYPE: return createControlKeyType();
			case ProbekitPackage.CONTROL_NAME_TYPE: return createControlNameType();
			case ProbekitPackage.DATA_TYPE1: return createDataType1();
			case ProbekitPackage.DESCRIPTION_TYPE: return createDescriptionType();
			case ProbekitPackage.DOCUMENT_ROOT: return createDocumentRoot();
			case ProbekitPackage.FRAGMENT_TYPE1: return createFragmentType1();
			case ProbekitPackage.IMPORT_TYPE: return createImportType();
			case ProbekitPackage.INVOCATION_OBJECT_TYPE: return createInvocationObjectType();
			case ProbekitPackage.NAME_TYPE: return createNameType();
			case ProbekitPackage.PROBEKIT_TYPE: return createProbekitType();
			case ProbekitPackage.PROBE_TYPE: return createProbeType();
			case ProbekitPackage.STATIC_FIELD_TYPE: return createStaticFieldType();
			case ProbekitPackage.TARGET_TYPE: return createTargetType();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case ProbekitPackage.DATA_TYPE:
				return DataType.get(initialValue);
			case ProbekitPackage.FRAGMENT_TYPE:
				return FragmentType.get(initialValue);
			case ProbekitPackage.DATA_TYPE_OBJECT:
				return createDataTypeObjectFromString(eDataType, initialValue);
			case ProbekitPackage.FRAGMENT_TYPE_OBJECT:
				return createFragmentTypeObjectFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case ProbekitPackage.DATA_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case ProbekitPackage.FRAGMENT_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case ProbekitPackage.DATA_TYPE_OBJECT:
				return convertDataTypeObjectToString(eDataType, instanceValue);
			case ProbekitPackage.FRAGMENT_TYPE_OBJECT:
				return convertFragmentTypeObjectToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ControlKeyType createControlKeyType() {
		ControlKeyTypeImpl controlKeyType = new ControlKeyTypeImpl();
		return controlKeyType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ControlNameType createControlNameType() {
		ControlNameTypeImpl controlNameType = new ControlNameTypeImpl();
		return controlNameType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataType1 createDataType1() {
		DataType1Impl dataType1 = new DataType1Impl();
		return dataType1;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DescriptionType createDescriptionType() {
		DescriptionTypeImpl descriptionType = new DescriptionTypeImpl();
		return descriptionType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentRoot createDocumentRoot() {
		DocumentRootImpl documentRoot = new DocumentRootImpl();
		return documentRoot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FragmentType1 createFragmentType1() {
		FragmentType1Impl fragmentType1 = new FragmentType1Impl();
		return fragmentType1;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ImportType createImportType() {
		ImportTypeImpl importType = new ImportTypeImpl();
		return importType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InvocationObjectType createInvocationObjectType() {
		InvocationObjectTypeImpl invocationObjectType = new InvocationObjectTypeImpl();
		return invocationObjectType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NameType createNameType() {
		NameTypeImpl nameType = new NameTypeImpl();
		return nameType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProbekitType createProbekitType() {
		ProbekitTypeImpl probekitType = new ProbekitTypeImpl();
		return probekitType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProbeType createProbeType() {
		ProbeTypeImpl probeType = new ProbeTypeImpl();
		return probeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StaticFieldType createStaticFieldType() {
		StaticFieldTypeImpl staticFieldType = new StaticFieldTypeImpl();
		return staticFieldType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TargetType createTargetType() {
		TargetTypeImpl targetType = new TargetTypeImpl();
		return targetType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataType createDataTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (DataType)ProbekitFactory.eINSTANCE.createFromString(ProbekitPackage.eINSTANCE.getDataType(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDataTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return ProbekitFactory.eINSTANCE.convertToString(ProbekitPackage.eINSTANCE.getDataType(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FragmentType createFragmentTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (FragmentType)ProbekitFactory.eINSTANCE.createFromString(ProbekitPackage.eINSTANCE.getFragmentType(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertFragmentTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return ProbekitFactory.eINSTANCE.convertToString(ProbekitPackage.eINSTANCE.getFragmentType(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProbekitPackage getProbekitPackage() {
		return (ProbekitPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static ProbekitPackage getPackage() {
		return ProbekitPackage.eINSTANCE;
	}
} //ProbekitFactoryImpl
