/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.probekit.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.probekit.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.probekit.ProbekitPackage
 * @generated
 */
public class ProbekitSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static ProbekitPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProbekitSwitch() {
		if (modelPackage == null) {
			modelPackage = ProbekitPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		EClass theEClass = theEObject.eClass();
		if (theEClass.eContainer() == modelPackage) {
			switch (theEClass.getClassifierID()) {
				case ProbekitPackage.CONTROL_KEY_TYPE: {
					ControlKeyType controlKeyType = (ControlKeyType)theEObject;
					Object result = caseControlKeyType(controlKeyType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.CONTROL_NAME_TYPE: {
					ControlNameType controlNameType = (ControlNameType)theEObject;
					Object result = caseControlNameType(controlNameType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.DATA_TYPE1: {
					DataType1 dataType1 = (DataType1)theEObject;
					Object result = caseDataType1(dataType1);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.DESCRIPTION_TYPE: {
					DescriptionType descriptionType = (DescriptionType)theEObject;
					Object result = caseDescriptionType(descriptionType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.DOCUMENT_ROOT: {
					DocumentRoot documentRoot = (DocumentRoot)theEObject;
					Object result = caseDocumentRoot(documentRoot);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.FRAGMENT_TYPE1: {
					FragmentType1 fragmentType1 = (FragmentType1)theEObject;
					Object result = caseFragmentType1(fragmentType1);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.IMPORT_TYPE: {
					ImportType importType = (ImportType)theEObject;
					Object result = caseImportType(importType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.INVOCATION_OBJECT_TYPE: {
					InvocationObjectType invocationObjectType = (InvocationObjectType)theEObject;
					Object result = caseInvocationObjectType(invocationObjectType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.NAME_TYPE: {
					NameType nameType = (NameType)theEObject;
					Object result = caseNameType(nameType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.PROBEKIT_TYPE: {
					ProbekitType probekitType = (ProbekitType)theEObject;
					Object result = caseProbekitType(probekitType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.PROBE_TYPE: {
					ProbeType probeType = (ProbeType)theEObject;
					Object result = caseProbeType(probeType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.STATIC_FIELD_TYPE: {
					StaticFieldType staticFieldType = (StaticFieldType)theEObject;
					Object result = caseStaticFieldType(staticFieldType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ProbekitPackage.TARGET_TYPE: {
					TargetType targetType = (TargetType)theEObject;
					Object result = caseTargetType(targetType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				default: return defaultCase(theEObject);
			}
		}
		return defaultCase(theEObject);
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Control Key Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Control Key Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseControlKeyType(ControlKeyType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Control Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Control Name Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseControlNameType(ControlNameType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Data Type1</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Data Type1</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDataType1(DataType1 object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Description Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Description Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDescriptionType(DescriptionType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Document Root</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDocumentRoot(DocumentRoot object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Fragment Type1</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Fragment Type1</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseFragmentType1(FragmentType1 object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Import Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Import Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseImportType(ImportType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Invocation Object Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Invocation Object Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseInvocationObjectType(InvocationObjectType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Name Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseNameType(NameType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseProbekitType(ProbekitType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Probe Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Probe Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseProbeType(ProbeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Static Field Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Static Field Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseStaticFieldType(StaticFieldType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Target Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Target Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTargetType(TargetType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //ProbekitSwitch
