/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.DeleteUtil;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class PDContentProvider implements ITreeContentProvider
		   			  , IResourceChangeListener
{

  protected static Hashtable fMonitors = new Hashtable();
  private   IStatus error;
  private Object[] objList;

  protected PDProjectExplorer fViewer;

	class ResourceDeltaVisitor implements IResourceDeltaVisitor
	{
		public boolean visit(IResourceDelta delta) throws CoreException
		{
			IResource resource = delta.getResource();
			//skip workspace root
			if (resource.getType() == IResource.ROOT)
				return true;
				
			if (delta.getKind() == IResourceDelta.REMOVED)
			{
				if(resource instanceof IContainer)
				  removeDoc((IContainer)resource);
				return true;
			}
			else if (delta.getKind() == IResourceDelta.ADDED)
			{
				return false;
			}
			else if (delta.getKind() == IResourceDelta.CHANGED)
			{
				return true;
			}
									
			return true;
		}
	}

/**
 * Insert the method's description here.
 * Creation date: (3/22/2001 2:58:12 PM)
 * @param viewer com.ibm.etools.pd.core.PDProjectExplorer
 */
public PDContentProvider(PDProjectExplorer viewer)
{
	fViewer = viewer;
	UIPlugin.getPluginWorkbench().addResourceChangeListener(this);
	
}
/**
 * Insert the method's description here.
 * Creation date: (10/06/2000 12:54:50 PM)
 * @param container com.ibm.itp.core.api.resources.IContainer
 * @param monitor com.ibm.etools.perftrace.TRCMonitor
 */
public static void addMonitor(IResource container, TRCMonitor monitor)
{
	Object monitors = fMonitors.get(container);
	if(monitors == null)
	{
	   monitors = new ArrayList();
	   ((ArrayList)monitors).add(monitor);
	   
	   fMonitors.put(container, monitors);
	}
	else
	{
		if(!((ArrayList)monitors).contains(monitor))
		   ((ArrayList)monitors).add(monitor);
	}
	    	
}
  public void dispose()
  {
  	fMonitors.clear();
	UIPlugin.getPluginWorkbench().removeResourceChangeListener(this);
  	
  }
    
  public Object[] getChildren(Object elem)
  {
    final Object element = elem;
    
	org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable()
	{
		public void run() {			
			try
			{
			  if (element instanceof IProject)
				objList = getContainerMonitors((IProject) element);
			  else if (element instanceof IFolder)
				objList = getContainerMonitors((IFolder) element);		
			  else if(element instanceof TRCMonitor)
			    objList = getMonitorChildren((TRCMonitor) element);	
			  else if(element instanceof TRCNode)
			    objList = getNodeProcesses((TRCNode) element);	    
			  else if(element instanceof TRCProcessProxy)
			    objList = getProcessAgents((TRCProcessProxy) element);
			  else if(element instanceof TRCAgentProxy)
			    objList = null;
			  else if(element instanceof INavigatorItem)
			  	objList = null;
			}
			catch (Exception e)
			{
			  e.printStackTrace();
			}
		}
	});

	if(objList == null)
		objList = new Object[0];

	Object[] delegates = NavigatorExtensionUtil.getAllChildren(element, PDProjectExplorer.ID).toArray();
	Object[] finalList = new Object[objList.length + delegates.length];
	System.arraycopy(objList, 0, finalList, 0, objList.length);
	System.arraycopy(delegates, 0, finalList, objList.length, delegates.length);
	return finalList;
  }  
/**
 * Insert the method's description here.
 * Creation date: (10/06/2000 12:46:49 PM)
 * @param container com.ibm.itp.core.api.resources.IContainer
 */
private Object[] getContainerMonitors(IContainer res)
{
	return getContainerMonitorsArray(res).toArray();
}

private ArrayList getContainerMonitorsArray(IContainer res)
{
	ArrayList list = getContainerMonitors0(res);
	ArrayList result = new ArrayList();

	for(int idx=0; idx<list.size(); idx++)
	{
		Object obj = list.get(idx);
		if(obj instanceof TRCMonitor)
		{
			TRCMonitor monitor = (TRCMonitor) obj;
   	  	    result.add(monitor);	
		}
		else if(obj instanceof IContainer)
		{
			IContainer cont = (IContainer) obj;
	  	    result.add(cont);	
		}
	}

	return result;
}


/**
 * Insert the method's description here.
 * Creation date: (10/06/2000 12:46:49 PM)
 * @param container com.ibm.itp.core.api.resources.IContainer
 */
protected ArrayList getContainerMonitors0(IContainer res)
{
	ArrayList childList = new ArrayList(); 

	if(res == null || !res.exists())
	  return childList;
	  
	try {

		//get all folders	
		IResource[] rmembers = res.members();
		for(int idx=0; idx<rmembers.length; idx++)
		{
			IResource member = rmembers[idx];
			if(member== null || !member.exists())
			  continue;
			  
			if(member instanceof IFolder)
				childList.add(member);
		}
	}
	catch(Exception exc)
	{
		exc.printStackTrace();
	}
		
	//get mof objects	   	
	Object monitors = fMonitors.get(res); 

	if(monitors == null)
	{
		try {
			IResource[] members = res.members();
			for(int idx=0; idx<members.length; idx++)
			{
				IResource member = members[idx];
				if(member== null || !member.exists())
				  continue;
				  
				if(member instanceof IFile)
				{
					if(member.getFileExtension() != null
						&&  member.getFileExtension().equals(TraceConstants.MONITOR_EXT))
					{
						getMonitors(member, childList);
					}
				}
			}
		}
		catch(CoreException exc)
		{
			error = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, exc.toString(), exc);
		}	

		if(childList.size() > 0)
		{
			ArrayList v = new ArrayList();
			for(int i=0; i<childList.size(); i++)
			{
				Object obj = childList.get(i);
				if(obj instanceof TRCMonitor)
				   v.add(obj);
			}
				  
			if(v.size() > 0) 
				fMonitors.put(res, v);
			
		}
			
		return childList;
	}

	for(int idx=0; idx<((ArrayList)monitors).size(); idx++)
		childList.add(((ArrayList)monitors).get(idx));		

	
	if(childList == null || childList.size() == 0)
	  return new ArrayList();

	return childList;  
}
  public Object[] getElements(Object elem)
  {
	    final Object element = elem;
	    
		org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable()
		{
			public void run() {			
				try
				{
				  if(element instanceof IWorkspace)
					objList = ((IWorkspace) element).getRoot().getProjects();	  		
				  else if(element instanceof IWorkspaceRoot)
					objList = ((IWorkspaceRoot)element).getProjects();	  
				}
				catch (Exception e)
				{
				  e.printStackTrace();
				}
			}
		});

		if(objList == null)
			objList = new Object[0];

		Object[] delegates = NavigatorExtensionUtil.getAllChildren(element, PDProjectExplorer.ID).toArray();
		Object[] finalList = new Object[objList.length + delegates.length];
		System.arraycopy(objList, 0, finalList, 0, objList.length);
		System.arraycopy(delegates, 0, finalList, objList.length, delegates.length);
		return finalList;
  }  
/**
 * Insert the method's description here.
 * Creation date: (09/29/2000 12:52:12 PM)
 * @param monitor com.ibm.etools.perftrace.TRCMonitor
 */
protected Object[] getMonitorChildren(TRCMonitor monitor)
{
	return getMonitorChildren0(monitor).toArray();	
}
/**
 * Insert the method's description here.
 * Creation date: (09/29/2000 12:52:12 PM)
 * @param monitor com.ibm.etools.perftrace.TRCMonitor
 */
protected ArrayList getMonitorChildren0(TRCMonitor monitor)
{	
	ArrayList list = new ArrayList();

	try {	
		Iterator i = monitor.getNodes().iterator();
		while (i.hasNext())
		{
			TRCNode node = (TRCNode)i.next();
			if(node.eIsProxy())
				continue;
//			//*** adding support for multiple files
//		  	SaveUtil.addDocument(node.eResource());

	  	    list.add(node);	  	
		}
	}
	catch(Exception exc)
	{
		return list;
	}
		
	return list;	
}
/**
 * Insert the method's description here.
 * Creation date: (10/06/2000 1:38:51 PM)
 * @return java.util.Vector
 */
public static ArrayList getMonitors()
{
	Enumeration list = fMonitors.elements();

	ArrayList v = new ArrayList();
	while(list.hasMoreElements())
	{
	   ArrayList monitors = (ArrayList) list.nextElement();
	   for(int idx=0; idx<monitors.size(); idx++)
	   {
		   v.add(monitors.get(idx));
	   }
	   	
	}
	
	return v;
}
/**
 * Insert the method's description here.
 * Creation date: (10/06/2000 1:38:51 PM)
 * @return java.util.Vector
 */
public static ArrayList getMonitors(IContainer container)
{
	Object monitors = fMonitors.get(container);
	if(monitors == null)
	  return new ArrayList();

	return (ArrayList)monitors;  
}
private void getMonitors(IResource member, ArrayList childList)
{
	ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();					
	Resource res = null;
	try
	{
	  String monPath = member.getFullPath().toString();	
	   String name = monPath;

		   res = resourceSet.getResource(URI.createURI("platform:/resource"+ name), true);
		
//System.out.println("trace file " + name); 
		// populate monitors ...
		EList ext = res.getContents();
		Iterator i = ext.iterator();
		while (i.hasNext())
		{
			Object obj = i.next();
			if (obj instanceof TRCMonitor)
		 	  childList.add(obj);		               
		} 
	   
//	   //*** adding support for multiple files	   
//	   if(res != null)
//		  SaveUtil.addDocument(res);
		  
	}
	catch (Exception e) {
	   String msg = "Exception caught while loading " + member.getFullPath().toOSString() + " document: " + e;
	   error = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, e.toString(), e);	   

	   e.printStackTrace();
	   
	   return;
	}
}
  /**
 * Insert the method's description here.
 * Creation date: (09/29/2000 12:54:35 PM)
 * @return java.util.Enumeration
 * @param node com.ibm.etools.perftrace.TRCNode
 */
protected Object[] getNodeProcesses(TRCNode node)
{
	return getNodeProcesses0(node).toArray();

}/**
 * Insert the method's description here.
 * Creation date: (09/29/2000 1:12:27 PM)
 * @return java.util.Enumeration
 * @param agent com.ibm.etools.perftrace.TRCAgentProxy
 */ 
  /**
 * Insert the method's description here.
 * Creation date: (09/29/2000 12:54:35 PM)
 * @return java.util.Enumeration
 * @param node com.ibm.etools.perftrace.TRCNode
 */
protected ArrayList getNodeProcesses0(TRCNode node)
{
	ArrayList list = new ArrayList();

	try {
		Iterator i = node.getProcessProxies().iterator();
		while (i.hasNext())
		{
			TRCProcessProxy process = (TRCProcessProxy)i.next();
			if(process.eIsProxy())
				continue;
//			//*** adding support for multiple files
//		  	SaveUtil.addDocument(process.eResource());

			list.add(process);			  	
		}
	}
	catch(Exception exc)
	{
		return list;
	}
	

	return list;

}/**
 * Insert the method's description here.
 * Creation date: (09/29/2000 1:12:27 PM)
 * @return java.util.Enumeration
 * @param agent com.ibm.etools.perftrace.TRCAgent
 */ 
  public Object getParent(Object element)
  {
	return null;
  }  
protected Object[] getProcessAgents(TRCProcessProxy process)
{
	return getProcessAgents0(process).toArray();
}/**
 * Invokes this object's procedure.  Progress can be reported using the
 * progress monitor.
 *
 * @param monitor the progress monitor to use to display progress
 * @exception com.ibm.itp.common.OperationFailedException
 */ 
protected ArrayList getProcessAgents0(TRCProcessProxy process)
{
	ArrayList list = new ArrayList();

	try {
		
		Object[] agents = process.getAgentProxies().toArray();
		for(int idx=0; idx<agents.length; idx++)
		{
			TRCAgentProxy agent = (TRCAgentProxy) agents[idx];	
			if(agent.eIsProxy())
				continue;

//			//*** adding support for multiple files
//		  	SaveUtil.addDocument(agent.getAgent().eResource());

		    list.add(agent);	  	
		}
	}
	catch(Exception exc)
	{
		return list;
	}	
	
	return list;
}
  public boolean hasChildren(Object element)
  {
	  return (getChildren(element).length > 0);
  }  
  public void inputChanged(Viewer viewer,	Object oldInput, Object newInput)
  {
  }  
  public boolean isDeleted(Object element)
  {
	if (element instanceof IResource) 
	  return ((IResource) element).exists();
	return false;
  }  
/**
 * Insert the method's description here.
 * Creation date: (10/06/2000 1:00:19 PM)
 * @param container com.ibm.itp.core.api.resources.IContainer
 */
public static void removeContainer(IContainer container)
{
	fMonitors.remove(container);
}
/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 7:09:56 PM)
 * @param res org.eclipse.core.resources.IContainer
 */
private void removeDoc(IContainer res)
{
	removeContainer(res);

	try {
		DeleteUtil.deleteContainer(res,true);
	}
	catch (Exception e)
	{
		e.printStackTrace();
	}
}
/**
 * Insert the method's description here.
 * Creation date: (10/06/2000 12:55:23 PM)
 * @param container com.ibm.itp.core.api.resources.IContainer
 * @param monitor com.ibm.etools.perftrace.TRCMonitor
 */
public static void removeMonitor(IContainer container, TRCMonitor monitor)
{
	if(container == null)
	  return;
	  
	removeMonitor(container.getFullPath().toOSString(), monitor);
}

public static void removeMonitor(String strPath, TRCMonitor monitor)
{
	IPath path = new Path(strPath);

	IWorkspaceRoot root = UIPlugin.getPluginWorkbench().getRoot();	
	IResource res = root.findMember(path);	
	if(res == null)
	  return;
	  
	Object monitors = fMonitors.get(res);
	if(monitors == null)
	  return;

	((ArrayList)monitors).remove(monitor);  
}

/**
 * Insert the method's description here.
 * Creation date: (10/06/2000 1:32:26 PM)
 */
public static void resetMonitors()
{
	fMonitors.clear();
}
/**
 * Notifies this content provider that some resource changes have happened
 * on the platform, and that the content provider should update 
 */
public void resourceChanged(IResourceChangeEvent event)
{
	IWorkspace workbench = UIPlugin.getPluginWorkbench();
	
	if (event.getType() == IResourceChangeEvent.POST_CHANGE
		&& event.getSource() instanceof IWorkspace)
	{

		IResource resource = event.getResource();
		IResourceDelta delta = event.getDelta();

		try {
			ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
			delta.accept(visitor);
		}
		catch(Exception exc)
		{
			exc.printStackTrace();
		}
		
		Control ctrl = fViewer.getControl();
		if (ctrl != null && !ctrl.isDisposed()) {
			// Do a sync exec, not an async exec, since the resource delta
			// must be traversed in this method.  It is destroyed
			// when this method returns.
			ctrl.getDisplay().syncExec(new Runnable() {
				public void run()
				{					
					fViewer.refresh();
				}
			});
		}
		
	}
}

}
