/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;

/*
* CONTEXT_ID trce0000 for Monitors (trace projects) view
*/

public class PDProjectViewer extends TreeViewer
{  	
	private boolean _refresh = true;
/**
 * Insert the method's description here.
 * Creation date: (11/13/2000 6:10:22 PM)
 * @return com.ibm.etools.logging.tracing.client.RAClientEngine
 */

  public void setRefresh(boolean refresh)
  {
  	_refresh = refresh;
  }
  
  public PDProjectViewer(Composite parent)
  {
	super(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		this.getControl(),
		UIPlugin.getPluginId()+".trce0000");
	
  }      

public void createSelectedNodeChildren()
{
	Tree _tree = (Tree)getControl();
	Item[] sels = getSelection(_tree);
	if(sels != null)
		super.createChildren(sels[0]);
		
		
}
/**
 * Insert the method's description here.
 * Creation date: (10/02/2000 1:19:12 PM)
 * @return com.ibm.itp.core.api.resources.IFolder
 * @param selection java.lang.Object
 */
public IResource getSelectionFolder()
{
	return getSelectionFolder(getTreeSelection());
	
}

/**
 * Insert the method's description here.
 * Creation date: (10/02/2000 1:19:12 PM)
 * @return com.ibm.itp.core.api.resources.IFolder
 * @param selection java.lang.Object
 */
protected IResource getSelectionFolder(TreeItem selection)
{
	if(selection != null && selection.getData() != null)
	{
		Object data = selection.getData();
		if(data instanceof IResource)
		   return (IResource)data;
		   
		if(data instanceof EObject)
		{
			String strPath = TString.resourcePath(((EObject)data).eResource().getURI());
			return UIPlugin.getPluginWorkbench().getRoot().findMember((new Path(strPath)).removeLastSegments(1));
		}   
	}
	
	return null;	
}
/**
 * Insert the method's description here.
 * Creation date: (10/02/2000 1:19:12 PM)
 * @return com.ibm.itp.core.api.resources.IFolder
 * @param selection java.lang.Object
 */
public IProject getSelectionProject()
{
	TreeItem selection = getTreeSelection();
	
	if(selection != null && selection.getData() != null)
	{
		Object data = selection.getData();
		if(data instanceof IProject)
		   return (IProject)data;
		   
		if(data instanceof EObject)
		{
			String strPath = TString.resourcePath(((EObject)data).eResource().getURI());
			IResource member = UIPlugin.getPluginWorkbench().getRoot().findMember(strPath);
			if(member != null)
			   return member.getProject();
		}   
	}

	return null;	
}

public TRCMonitor getSelectionMonitor()
{
	TreeItem selection = getTreeSelection();
	
	while(selection != null)
	{
		if(selection.getData() != null && selection.getData() instanceof TRCAgentProxy)
		  return ((TRCAgentProxy)selection.getData()).getProcessProxy().getNode().getMonitor();
		if(selection.getData() != null && selection.getData() instanceof TRCProcessProxy)
		  return ((TRCProcessProxy)selection.getData()).getNode().getMonitor();
		if(selection.getData() != null && selection.getData() instanceof TRCNode)
		  return ((TRCNode)selection.getData()).getMonitor();  
		if(selection.getData() != null && selection.getData() instanceof TRCMonitor)
		  return (TRCMonitor)selection.getData();

		 selection = selection.getParentItem(); 
	}

	return null;	
}
/**
 * Insert the method's description here.
 * Creation date: (10/02/2000 1:29:08 PM)
 * @return com.ibm.swt.widgets.TreeItem
 */
public TreeItem getTreeSelection()
{
	Item[] sels = getSelection(getControl());
	if(sels.length > 0)
	  return (TreeItem)sels[0];

	return null;  

}

public Item[] getTreeSelections()
{
	Item[] sels = getSelection(getControl());
	if (sels.length > 0)
		return sels;

	return null;  

}

/**
 * Insert the method's description here.
 * Creation date: (09/26/2000 12:35:46 PM)
 * @param obj java.lang.Object
 */
public void selectObject(Object item)
{
	if(item == null)
	  return;
	  	 
	IWorkspaceRoot root = UIPlugin.getPluginWorkbench().getRoot();  	  
	refresh();
	if(item instanceof TRCMonitor)
	{
		TRCMonitor mon = (TRCMonitor)item;
		String path = TString.resourcePath(mon.eResource().getURI());
		if(path != null)
		{
			path = path.substring(0, path.length() - (new Path(path)).lastSegment().length());
			
			IResource res = root.findMember(path);
			if(path != null)
				setExpandedState(res, true);
		}
		
		select(mon);						
	}
	else if(item instanceof TRCNode)
	{
		TRCNode node = (TRCNode)item;
		String path = TString.resourcePath(node.eResource().getURI());
		if(path != null)
		{
			path = path.substring(0, path.length() - (new Path(path)).lastSegment().length());
			
			IResource res = root.findMember(path);
			if(path != null)
				setExpandedState(res, true);
		}
		
		setExpandedState(node.getMonitor(), true);
		select(node);						
	}
	else if(item instanceof TRCProcessProxy)
	{
		TRCProcessProxy prc = (TRCProcessProxy)item;
		String path = TString.resourcePath(prc.eResource().getURI());
		if(path != null)
		{
			path = path.substring(0, path.length() - (new Path(path)).lastSegment().length());
			
			IResource res = root.findMember(path);
			if(path != null)
				setExpandedState(res, true);
		}
		
		setExpandedState(prc.getNode().getMonitor(), true);
		setExpandedState(prc.getNode(), true);
		select(prc);						
	}
	else if(item instanceof TRCAgentProxy)
	{
		TRCAgentProxy agent = (TRCAgentProxy)item;
		String path = TString.resourcePath(agent.eResource().getURI());
		if(path != null)
		{
			path = path.substring(0, path.length() - (new Path(path)).lastSegment().length());
			
			IResource res = root.findMember(path);
			if(path != null)
				setExpandedState(res, true);
		}
		
		setExpandedState(agent.getProcessProxy().getNode().getMonitor(), true);
		setExpandedState(agent.getProcessProxy().getNode(), true);
		setExpandedState(agent.getProcessProxy(), true);
		select(agent);						
	}    
}

private void select(Object item)
{
	if(item == null)
	  return;
	  
	Tree _tree = (Tree)getControl();
	
	Item currentSelection = null;
	if(_tree.getSelectionCount()>0)
	{
		currentSelection = _tree.getSelection()[0];
		internalExpandToLevel(currentSelection,1);
	}
	else
	{
		TreeItem[] items = _tree.getItems();
		if(items.length > 0)
		{
			internalExpandToLevel(items[0],1);						
		}
	}
	
	Widget treeItem = doFindItem(item);

	if(treeItem == null || !(treeItem instanceof TreeItem))
	  return;
	 
	setSelection(new StructuredSelection(item), true);   
}

public void dispose()
{
}
}
