/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenLogAgentWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenNodeWizard;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;


/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TraceLogActionGroup extends NavigatorActionGroup {

	//protected INavigator fViewer; 
	protected DeleteAction fDeleteAction;
	protected OpenWizardAction fOpenLogAgentAction;
	protected OpenWizardAction fOpenNodeAction;
	protected SaveAction fSaveToFile;
	protected ToggleLinkingAction toggleLinkingAction;
	protected RefreshTreeAction fRefreshTree;
	protected RefreshFromLocalAction fRefreshLocal;	
	protected Separator fRefreshGrp;
	protected ActionGroup fImportActionGroup;
	protected Separator fAttachGrp;
	protected Separator fMonitorGrp;
	protected Separator fTerminateGrp;
	protected Separator fNewSnapshotGrp;
	protected Separator fGCGroup;	
		
	protected final String GROUP_ADD_VIEWS = "group.add.views";
		
	protected Map traceViewsMap;
	
	class ImportActionGroup extends ActionGroup
	{
		 private ImportResourcesAction fImportAction;
		 private ExportResourcesAction fExportAction;
		
		 /**
		  * Creates a new <code>ImportActionGroup</code>. The group 
		  * requires that the selection provided by the part's selection provider 
		  * is of type <code>org.eclipse.jface.viewers.IStructuredSelection</code>.
		  * 
		  * @param part the view part that owns this action group
		  */
		 public ImportActionGroup(INavigator part) {
			 IWorkbenchWindow workbench = part.getSite().getWorkbenchWindow();
			 fImportAction= new ImportResourcesAction(workbench);
			 fExportAction= new ExportResourcesAction(workbench);	
			PDPluginImages.setImageDescriptors(fImportAction, PDPluginImages.T_LCL, PDPluginImages.IMG_IMPORT);
			PDPluginImages.setImageDescriptors(fExportAction, PDPluginImages.T_LCL, PDPluginImages.IMG_EXPORT);
				 		
		 }
			
		 /* (non-Javadoc)
		  * Method declared in ActionGroup
		  */
		 public void fillContextMenu(IMenuManager menu) {
			 menu.appendToGroup(INavigatorContribution.GROUP_IMPORT, fImportAction);
			 menu.appendToGroup(INavigatorContribution.GROUP_IMPORT, fExportAction);
				
			 super.fillContextMenu(menu);
		 }	
	 }

	/*
	 * Constructor for TraceLogActionGroup
	 * @param logNavigator
	 */
	public TraceLogActionGroup(INavigator viewer)
	{
		super(viewer);
		
		//fViewer = viewer;
		//createActions();
		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#createActions()
	 */
	protected void createActions() {
		super.createActions();
		traceViewsMap = new HashMap();

		toggleLinkingAction = new ToggleLinkingAction(getNavigator(), UIPlugin.getResourceString("STR_LINK_VIEW")); 
		toggleLinkingAction.setToolTipText(UIPlugin.getResourceString("STR_LINK_VIEW_TIP")); 
		PDPluginImages.setImageDescriptors(toggleLinkingAction, PDPluginImages.T_LCL, PDPluginImages.IMG_LINK_WITH_VIEWER);
		
		fImportActionGroup = new ImportActionGroup(getNavigator());
		fNewSnapshotGrp = new Separator(TraceConstants.PROFILE_NEW_SNAPSHOT_GROUP);
		fGCGroup = new Separator(TraceConstants.PROFILE_GC_GROUP);		
		fRefreshGrp = new Separator(TraceConstants.PROFILE_REFRESH_GROUP);
		fAttachGrp = new Separator(TraceConstants.PROFILE_ATTACH_GROUP);
		fTerminateGrp = new Separator(TraceConstants.PROFILE_TERMINATE_GROUP);
		fRefreshTree = new RefreshTreeAction(getNavigator());		
		fMonitorGrp = new Separator(TraceConstants.PROFILE_MONITOR_GROUP);
		fSaveToFile = new SaveAction(getNavigator());
		fRefreshLocal = new RefreshFromLocalAction(getNavigator());
		fOpenLogAgentAction =
			new OpenWizardAction(
		getNavigator(),
				OpenLogAgentWizard.class,
				UIPlugin.getResourceString("PROPERTIES"));
		fOpenNodeAction =
			new OpenWizardAction(
		getNavigator(),
				OpenNodeWizard.class,
				UIPlugin.getResourceString("PROPERTIES"));
	
		fDeleteAction = new DeleteAction(getNavigator());
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#dispose()
	 */
	
	
	public void dispose()
	{	
		if(traceViewsMap!=null)
		{
			traceViewsMap.clear();
			traceViewsMap = null;
		}
			
	
		if (fImportActionGroup != null)
		{
				fImportActionGroup.dispose();
				fImportActionGroup = null;
		}
			
			deleteSeparators();
		
			deleteActions();
		
			super.dispose();
	}
		
	private void deleteSeparators()
	{
	   
		if(fAttachGrp != null)
		{
			fAttachGrp.dispose();
			fAttachGrp = null;
		}   
		if(fRefreshGrp != null)
		{
			fRefreshGrp.dispose();
			fRefreshGrp = null;
		}   
		if(fTerminateGrp != null)
		{
			fTerminateGrp.dispose();
			fTerminateGrp = null;
		}  
		if(fMonitorGrp != null)
		{
			fMonitorGrp.dispose();
			fMonitorGrp = null;
		}   
	
		if(fNewSnapshotGrp != null)
		{
			fNewSnapshotGrp.dispose();
			fNewSnapshotGrp = null;
		}   
		if(fGCGroup != null)
		{
			fGCGroup.dispose();
			fGCGroup = null;
		}   
	
	}

	private void deleteActions()
	{
	
		if (fSaveToFile != null)
		{
			fSaveToFile.dispose();
			fSaveToFile = null;
		}
		if (fDeleteAction != null)
		{
				fDeleteAction.dispose();
				fDeleteAction = null;
		}
		if (fOpenLogAgentAction != null)
		{
				fOpenLogAgentAction.dispose();
				fOpenLogAgentAction = null;
		}
		if (fOpenNodeAction != null)
		{
			fOpenNodeAction.dispose();
			fOpenNodeAction = null;
		}
		if (fRefreshLocal != null)
		{
			fRefreshLocal.dispose();
			fRefreshLocal = null;
		}
		if (fRefreshTree != null)
		{
			fRefreshTree.dispose();
			fRefreshTree = null;
		}
		if (toggleLinkingAction != null)
		{
			toggleLinkingAction.dispose();
			toggleLinkingAction= null;
		}
	}


	
	public void fillActionBars(IActionBars actionBars)
	{
		super.fillActionBars(actionBars);
		
		IMenuManager menu = actionBars.getMenuManager();
		menu.add(new Separator());
		menu.add(toggleLinkingAction);
		
		actionBars.updateActionBars();

		IToolBarManager toolbar = actionBars.getToolBarManager();		
		toolbar.add(new Separator());
		toolbar.add(toggleLinkingAction);
		
	}
	
	
	/**
	 * Returns true if the selections have the same type
	 * @param selection
	 * @return
	 */
	protected boolean areSameClass(IStructuredSelection selection) {
		
		if(selection == null || selection.isEmpty())
		  return true;
		  
		Class objClass = selection.getFirstElement().getClass();  
		Iterator iterator = selection.iterator();  
		while(iterator.hasNext())
		{
			if (!(objClass.equals(iterator.next().getClass()))) {
				return false;
			}
		}
		
		return true;
	}

	/**
	 * Returns the image descriptor from the eclipse UI plugin with the given relative 
	 * path.
	 * @return ImageDescriptor;
	 */
	public void handleDoubleClick(DoubleClickEvent event) {
		
		IStructuredSelection s = (IStructuredSelection) event.getSelection();
		Object obj = s.getFirstElement();

		if(obj == null || !(obj instanceof EObject))
		  return;

		if(obj instanceof TRCAgentProxy)
		{
			IAction[] actions = getViewMappingForType(((TRCAgentProxy)obj).getType());
			if(actions.length > 0 && actions[0] != null)
				actions[0].run();
		}
		if(obj instanceof CorrelationContainerProxy){
			if(((CorrelationContainerProxy)obj).getCorrelatedAgents().size()>0){
				TRCAgentProxy a = (TRCAgentProxy)((CorrelationContainerProxy)obj).getCorrelatedAgents().get(0);
				IAction[] actions = getViewMappingForType(a.getType());
				if(actions.length > 0 && actions[0] != null)
					actions[0].run();
			}
		}
	}

	/**
	 * Returns the list of actions available for this trace type
	 * @param type
	 */
	protected IAction[] getViewMappingForType(String type)
	{
		Object mapp = traceViewsMap.get(type);
    	
		if(mapp != null)
			return ((IAction[])mapp);
    	    
		IAssociationMappingRegistry registry = TraceAssociationManager.getTraceViewMappingRegistry();
		IAssociationMapping mapping = registry.getAssociationMapping(HyadesUIPlugin.EP_ANALYZER_EXTENSIONS);
		
		if(mapping == null)
		{
			IAction[] actions = new IAction[0];
			traceViewsMap.put(type, actions);
			
			return actions;
		}
    		    		  
		IAssociationDescriptor[] array = mapping.getAssociationDescriptors(type);
		IAction[] actions = new IAction[array.length];
		
		for(int idx=0; idx<array.length; idx++)
		{
			IAssociationDescriptor desc = array[idx];
				
			try {
					
				IAction action = (IAction)desc.createImplementationClassInstance();
				
				if(action != null)
				{
					action.setText(desc.getName());
					action.setImageDescriptor(desc.getImageDescriptor());
				
					actions[idx] = action;										
				}								
			} catch (Exception exc) {
				exc.printStackTrace();
			}
								
		}
		
		traceViewsMap.put(type, actions);
		return actions;
    	        	  
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#handleKeyPressed(org.eclipse.swt.events.KeyEvent)
	 */
	public void handleKeyPressed(KeyEvent event) {
		if(event.character == SWT.DEL && (event.stateMask == 0))
		{
			if(fDeleteAction.isEnabled())
				fDeleteAction.run();
		}
	}

	protected void updateActions(IStructuredSelection selection) {
		boolean saveEnabled = true;
		boolean deleteEnabled = true;
		
		if (selection.size() == 0)
			saveEnabled = deleteEnabled = false;
		
		Iterator i = selection.iterator();
		while (i.hasNext()) {
			Object next = i.next();
			if (next instanceof INavigatorItem) {
				INavigatorItem item = (INavigatorItem)next;
				if (!item.isSaveEnabled())
					saveEnabled = false;
				if (!item.isDeleteEnabled())
					deleteEnabled = false;
			}
		}
		
		fSaveToFile.setEnabled(saveEnabled);
		fDeleteAction.setEnabled(deleteEnabled);
	}
}
