/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import java.io.*;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;

public class TraceFileUI extends AbstractChangeable implements SelectionListener
{
	private Button _sentToFileCheckBox;
	private Label  _fileLabel;
	private Text   _file;
	private Button _browseLocation;
	private Label  _note;


public TraceFileUI() {
	super();
}

public Composite createControl(Composite parent)
{
	
	GridLayout layout;
	GridData   data;
		
	Composite result = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 3;
	layout.verticalSpacing=2;
	layout.marginHeight = 25;
	layout.verticalSpacing = 6;
	result.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	result.setLayoutData(data);
	
	_sentToFileCheckBox = new Button(result, SWT.CHECK);
	_sentToFileCheckBox.setText(UIPlugin.getResourceString("STR_SEND_TO_FILE"));
	_sentToFileCheckBox.setToolTipText(UIPlugin.getResourceString("STR_SEND_TO_FILE_TOOPTIP"));
	data = new GridData();
	data.horizontalSpan = 3;
	_sentToFileCheckBox.setLayoutData(data);

	_fileLabel = new Label(result, SWT.NULL);
	_fileLabel.setText(UIPlugin.getResourceString("PROFILE_FILE"));

	_file = new Text(result, SWT.BORDER);
	_file.setLayoutData(GridUtil.createHorizontalFill());

	_browseLocation = new Button(result, SWT.NULL);
	_browseLocation.setText(UIPlugin.getResourceString("BROWSE2"));

	_note = new Label(result, SWT.NULL);
	_note.setText(UIPlugin.getResourceString("PROFILE_FILE_NOTE"));
	data = new GridData();
	data.horizontalSpan = 3;
	_note.setLayoutData(data);
	
	_sentToFileCheckBox.addSelectionListener(this);
	_browseLocation.addSelectionListener(this);
	_file.addKeyListener(new KeyListener() {
		public void keyPressed(KeyEvent e) {
			changed();
		}
		
		public void keyReleased(KeyEvent e) {
			changed();
		}
	});
	
	initData();
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_sentToFileCheckBox,
		UIPlugin.getPluginId()+".sttf0000");

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_file,
		UIPlugin.getPluginId()+".sttf0001");
	
	return result;
}

public String getFile() 
{
	return _file.getText();
}
public void setFile(String file)
{
	_file.setText(file);
}
public Button getExternalBox()
{
	return _sentToFileCheckBox;
}
public Text getFileText()
{
	return _file;
}
public boolean getSelection()
{
	return _sentToFileCheckBox.getSelection();
}

private void initData()
{
	_sentToFileCheckBox.setSelection(false);
	setEnabled(false);
	_file.setText("");
}

public void setEnabled(boolean enable)
{
	_fileLabel.setEnabled(enable);
	_file.setEnabled(enable);
	_file.setEditable(enable);
	_browseLocation.setEnabled(enable);
	_note.setEnabled(enable);
}

public void setVisible(boolean enable)
{
	_sentToFileCheckBox.setVisible(enable);
	_fileLabel.setVisible(enable);
	_file.setVisible(enable);
	_browseLocation.setVisible(enable);
	_note.setVisible(enable);
}

private void showResourceDialog()
{
	Shell shell = UIPlugin.getActiveWorkbenchWindow().getShell();
	String osName = System.getProperty("os.name");

	FileDialog dlg = new FileDialog(shell);
	dlg.setFilterExtensions(new String[] {"*.trcxml","*"});
	dlg.open();

	String fileName = dlg.getFileName();
	//System.out.println(fileName);
	if(fileName != null && !fileName.equals(""))
	{

      if (fileName.indexOf(".")<0) fileName += ".trcxml";
	  String classpath = dlg.getFilterPath();
	  if ((osName != null) && (osName.startsWith("Windows")) && (classpath.endsWith(":")))
	  {
	 	classpath += "\\";
	  }

	  _file.setText(classpath+File.separator+fileName);
	  
	  /*
	  File tempFile = new File(_file.getText().trim());
	  if (tempFile.exists()) 
	  	if (!showOverWriteWarning()) ;;
	  */
	  	
	}       

		
}

public void widgetDefaultSelected(SelectionEvent e)
{}

public void widgetSelected(SelectionEvent e)
{
	if(e.widget == _sentToFileCheckBox)
		setEnabled(_sentToFileCheckBox.getSelection());
	else if(e.widget == _browseLocation)
		showResourceDialog();
	
	changed();
}

}
