/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

/*
* CONTEXT_ID opwp0003 for process id text field in open process wizard page
*/
/*
* CONTEXT_ID opwp0004 for host text field in open process wizard page
*/

public class TraceProcessUI
{
	protected TraceLocationUI _locationUI;
	protected LaunchProcessUI _processUI;
	protected Text  _processId;
	protected Text  _hostname;
/**
 * TraceOptionsUI constructor comment.
 */
public TraceProcessUI() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	Label label;
	GridData data;

	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=5;       
	content.setLayout(layout);
	GridData gd = GridUtil.createFill();
	content.setLayoutData(gd);

	_locationUI = new TraceLocationUI();
	_locationUI.createControl(content);
	_locationUI.setEnabled(false);

	new Label(content, SWT.NONE);
	
	_processUI = new LaunchProcessUI(); 
	Composite systemControl = _processUI.createControl(content);
	_processUI.enable(false, false, false, false,false);

	Composite group = new Composite(content, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 2;
	layout.verticalSpacing=5;       
	group.setLayout(layout);
	group.setLayoutData(GridUtil.createFill());

	label = new Label(group, SWT.SEPARATOR|SWT.HORIZONTAL);
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;
	label.setLayoutData(data); 
	
	label = new Label(group, SWT.NONE); 
	label.setText(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PROCESS_ID"));
	_processId = new Text(group, SWT.SINGLE | SWT.BORDER);
	_processId.setLayoutData(GridUtil.createHorizontalFill());

	label = new Label(group, SWT.NONE); 
	label.setText(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_HOST"));
	_hostname = new Text(group, SWT.SINGLE | SWT.BORDER);
	_hostname.setLayoutData(GridUtil.createHorizontalFill());       
			
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_processId,
		UIPlugin.getPluginId()+".opwp0003");  
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_hostname,
		UIPlugin.getPluginId()+".opwp0004"); 

	return content;
}
/**
 * Insert the method's description here.
 * Creation date: (8/14/2001 1:43:48 PM)
 * @return com.ibm.etools.pd.core.ui.LaunchProcessUI
 */
public LaunchProcessUI getLaunchProcessUI() {
	return _processUI;
}
/**
 * Insert the method's description here.
 * Creation date: (8/14/2001 1:43:10 PM)
 * @return com.ibm.etools.pd.core.ui.TraceLocationUI
 */
public TraceLocationUI getLocationUI() {
	return _locationUI;
}
/**
 * Insert the method's description here.
 * Creation date: (8/14/2001 1:14:45 PM)
 * @return org.eclipse.swt.widgets.Text
 */
public Text getNodeNameUI() {
	return _hostname;
}
/**
 * Insert the method's description here.
 * Creation date: (8/14/2001 1:14:45 PM)
 * @return org.eclipse.swt.widgets.Text
 */
public Text getProcessIdUI() {
	return _processId;
}
}
