/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;


import org.eclipse.hyades.trace.ui.internal.launcher.*;
import org.eclipse.debug.core.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.trace.ui.*;



/*
 * CONTEXT_ID top0001 for My application is too slow in profile options page
 * CONTEXT_ID top0002 for My application uses too much memory in profile options page
 * CONTEXT_ID top0003 for Collect execution flow information in profile options page
 * CONTEXT_ID top0004 for Show &instance level information in profile options page
 * CONTEXT_ID top0005 for Show execution flow details in profile options page
 * CONTEXT_ID top0006 for Show heap details in profile options page
 * CONTEXT_ID top0007 for Show execution flow graphical details in profile options page
 * CONTEXT_ID top0008 for Show execution statistic in profile options page
 * CONTEXT_ID top0009 for Boundary class depth: in profile options page
 * CONTEXT_ID top0010 for Automatically start monitoring in profile options page
 */

public class TraceProfileUI extends AbstractChangeable implements SelectionListener
, ModifyListener 
{
	
	private ProfileTab parentTab;
	
	private ProfileLimitsTab _plt;
	private ProfileDestinationTab _pdt;
	//private ProfileOptionsTab _pot;
	//private ProfileFiltersTab _pft;
	private ProfileOverviewTab _pot;
	
	
	private org.eclipse.swt.widgets.Listener _listener = new org.eclipse.swt.widgets.Listener() {
		public void handleEvent(org.eclipse.swt.widgets.Event event) {
			parentTab.update();
		}
	};



	public TraceProfileUI(ProfileTab par)   
	{
		super();
		parentTab = par;
		
		_plt = new ProfileLimitsTab(parentTab);
		_pdt = new ProfileDestinationTab(parentTab);
		//_pot = new ProfileOptionsTab(parentTab);
		//_pft = new ProfileFiltersTab(parentTab);
		_pot = new ProfileOverviewTab(parentTab);
	}
	
	public void modifyText(ModifyEvent event) {}
	
	public void widgetDefaultSelected(SelectionEvent event) { }
	
	public void widgetSelected(SelectionEvent event) {}

	
	public Composite createControl(Composite parent)
	{
		parent.setLayout(new FillLayout());
		TabFolder folder = new TabFolder(parent, SWT.TOP);
		
		TabItem item1 = new TabItem(folder, SWT.TOP);
		item1.setText(UIPlugin.getResourceString("TAB_NAME_OVERVIEW"));
		item1.setControl(_pot.createControl(folder));
		_pot.addListener(_listener);
		
		TabItem item2 = new TabItem(folder, SWT.TOP);
		item2.setText(UIPlugin.getResourceString("TAB_NAME_LIMITS"));
		item2.setImage(PDPluginImages.getImage(PDPluginImages.IMG_OPTIONS));
		item2.setControl(_plt.createControl(folder));
		_plt.addListener(_listener);
		
		TabItem item3 = new TabItem(folder, SWT.TOP);
		item3.setText(UIPlugin.getResourceString("TAB_NAME_DESTINATION"));
		item3.setImage(PDPluginImages.getImage(PDPluginImages.IMG_UI_FOLDER));
		item3.setControl(_pdt.createControl(folder));
		_pdt.addListener(_listener);

		return folder;
		
	} 
	public void initializeFrom(ILaunchConfiguration conf)
	{
		_plt.initializeFrom(conf);
		_pdt.initializeFrom(conf);
		_pot.initializeFrom(conf);
		//_pft.initializeFrom(conf);
	}
	
	public void activated(ILaunchConfigurationWorkingCopy conf)
	{
		_plt.initializeFrom(conf);
		_pdt.activated(conf);
		_pot.initializeFrom(conf);
		//_pft.activated(conf);
	}
	public void performApply(ILaunchConfigurationWorkingCopy wc, boolean initialize)
	{
		_plt.performApply(wc);
		_pdt.performApply(wc);
		_pot.performApply(wc, initialize);
		//_pft.performApply(wc);
	}
	
	public boolean isValid(ILaunchConfiguration conf)
	{
		return (_plt.isValid(conf) && _pdt.isValid(conf) && _pot.isValid(conf));
	}
	
}


