/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.debug.core.*;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.preference.*;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;

/**
 * @author znensi
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */

public class ProfileAttachDelegate extends ProfileLaunchDelegate
{
	public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException
	{						
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

		String hostName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
		int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt(HyadesConstants.LOCALHOST_PORT));
		String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(TraceConstants.TRACE_PROJECT_NAME));
		String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(TraceConstants.TRACE_MONITOR_NAME));
		String profileFile = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String) null);
		
		ProfilingSetsManager manager = ProfilingSetsManager.instance();		
		Vector options = manager.getOptions(conf);
		Vector agents = new Vector(getAgents(conf));

		PDCoreUtil.attach(hostName, agents, projectName, monitorName,String.valueOf(port), profileFile);
	}
	
	static List getNodeConfiguration(ILaunchConfiguration conf)
	{
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

		try
		{
			String host = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
			int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getDefaultInt(HyadesConstants.LOCALHOST_PORT));
			Enumeration enum = PDCoreUtil.getNodeConfiguration(host, port); 
			List list = new ArrayList();
			while (enum.hasMoreElements())
				list.add(enum.nextElement());
			return list;
		}
		catch (CoreException e)
		{
			e.printStackTrace();
			return null;
		}
	}

	static List getAgents(ILaunchConfiguration conf) {
		return getAgents(conf, getNodeConfiguration(conf));
	}
	
	static List getAgents(ILaunchConfiguration conf, List nodes)
	{
		List agents = new ArrayList();

		if (nodes != null) {
			try
			{
				Iterator iter = nodes.iterator();
				List list = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, (List)null);
				if (list != null)
				{
					Map map = createMap(list);
	
					Vector v = new Vector();
					while (iter.hasNext())
					{
						Process process = (Process)iter.next();
						String[] selected = (String[])map.get(process.getProcessId());
						if (selected != null)
						{
							for (int i = 0; i < selected.length; ++i)
								agents.add(process.getAgent(selected[i]));
						}
					}
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}

		return agents;
	}

	// parse and organize the agents in a more accessible data structure
	private static Map createMap(List list)
	{
		Map map = new HashMap();

		Iterator iter = list.iterator();
		while (iter.hasNext())
		{
			StringTokenizer tok = new StringTokenizer((String)iter.next(), ":");
			String pid = tok.nextToken();

			tok = new StringTokenizer(tok.nextToken(), ",");
			String[] agents = new String[tok.countTokens()];

			for (int i = 0; i < agents.length; ++i)
				agents[i] = tok.nextToken();
			map.put(pid, agents);
		}

		return map;
	}
}

