/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;

import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileFiltersUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.*;
/**
 * @author znensi
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ProfileFiltersTab {
	
	private TraceProfileFiltersUI _filtersUI;
	private ProfileTab parentTab;
	private StringBuffer filters;
	
	private String profilingTypeName;
		
	public ProfileFiltersTab(String parentName, ProfileTab pt)
	{
		_filtersUI = new TraceProfileFiltersUI();
		parentTab = pt;
		profilingTypeName = parentName;
		filters = new StringBuffer();
	}
	
	public ProfileFiltersTab(String parentName)
	{
		_filtersUI = new TraceProfileFiltersUI();
		filters = new StringBuffer();
		profilingTypeName = parentName;
	}
	
	public void setParentTab(ProfileTab pt)
	{
		parentTab = pt;
	}
	
	public Composite createControl(Composite parent)
	{
		return _filtersUI.createControl(parent);
	}
	
	public void addListener (Listener _listener)
	{
		_filtersUI.addListener(_listener);
	}
	

	public String getName()
	{
		return UIPlugin.getResourceString("TAB_NAME_FILTERS");
	}

	public Image getImage()
	{
		return PDPluginImages.getImage(PDPluginImages.IMG_FILTER);
	}
	
	public void activateFilters(FilterSetElement[] list)
	{
		
		FilterSetElement[] newList = order(list);

		//sends the list fo the TraceProfileFiltersUI to populate it's table
		_filtersUI.addFilterSets(newList);
	}
	
	private FilterSetElement[] order(FilterSetElement[] list)
	{
		//this method makes sure that the selected filter set is first in the list
		//if not, a blanks space will be created at the top of the filter set table
		
		//this array will contain the correctly ordered FilterSetElement list
		FilterSetElement[] newList = new FilterSetElement[list.length];
		//first make sure that enabled one is not already first
		
		if ((list.length > 0) && (!((FilterSetElement)list[0]).getEnabled()))
		{
			
			FilterSetElement elem = null;
			//first find enabled one
			for (int i = 0; i < list.length; i++)
			{
				//this is the enabled filter set
				elem = (FilterSetElement)list[i];
				if (elem.getEnabled())
				{
					//put it first in the list
					newList[0] = elem;
					break;
				}
			
			}
			int counter = 1;
			//not put all the others one in the list, just not in the first position
			for (int i = 0; i < list.length; i++)
			{
				if (!(((FilterSetElement)list[i]).getName().equals(elem.getName())))
				{
					newList[counter] = (FilterSetElement)list[i];
					counter++;
				}
				
				
			}
		} else newList = list;
		return newList;
		
	}
	
	
	public ArrayList getFilterSet()
	{
		return _filtersUI.getFilterSet();
	}
}
