/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.debug.core.*;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.hyades.trace.ui.launcher.*;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
/**
 * @author znensi
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */



public class ProfileLaunchDelegate extends AbstractJavaLaunchConfigurationDelegate
{
	public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException
	{
		boolean success = performProfilingTypesLaunch(conf);
		if(!success)
			return;
		
		ProfilingSetsManager manager = ProfilingSetsManager.instance();
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

		TraceArguments args = new TraceArguments(getMainTypeName(conf));
		args.setClassPath(getClasspathString(conf));
		args.setParameters(getProgramArguments(conf));
		args.setVMArguments(getVMArguments(conf));
		args.setEnvironmentVariable(manager.getEnvironmentVariables(conf));
		args.setAutoMonitoring(manager.getAutoMonitoring(conf));

		String hostName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
		int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt(HyadesConstants.LOCALHOST_PORT));
		String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(TraceConstants.TRACE_PROJECT_NAME));
		String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(TraceConstants.TRACE_MONITOR_NAME));
		
		args.setHostName(hostName);
		args.setPortNumber(port);
		
		if (conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false))
			args.setProfileFile(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null));

		ArrayList filters = manager.getFilters(conf);
		Vector options = manager.getOptions(conf);

		monitor.worked(5); // 5% done
		PDCoreUtil.launchTrace(args, 
				  filters, options, 
				  projectName, monitorName);
		//PDCoreUtil.launchTrace(args, filters, options, projectName, monitorName, launch, monitor);
		monitor.done(); // 100% done
	}

	protected boolean performProfilingTypesLaunch(ILaunchConfiguration config)
	{
		boolean success = true;
		
		ProfilingSetsManager manager = ProfilingSetsManager.instance();
		IProfilingSet set = ProfilingSetsManager.instance().getDefaultSet();
		if(set == null)
			return true;
		
		IProfilingSetType[] profilingTypes = new ProfilingSetType[manager.getProfilingTypes().size()];
		profilingTypes = (IProfilingSetType[])manager.getProfilingTypes().values().toArray(profilingTypes);
		
		List types = set.getProfilingTypes();
		for(int i = 0; i < profilingTypes.length; i++) {
			
			if(types.contains(profilingTypes[i].getId()))
			{
				IProfilingType type = profilingTypes[i].getProfilingType();
				final String msg = type.launch(config);
				if(msg != null)
				{
		            Display d = Display.getDefault();

		            d.asyncExec(new Runnable() {
		                    public void run() {
		                        //update ui
		    					MessageDialog.openError(Display.getDefault().getActiveShell(), "Launch Configuration error", msg);
		                    }
		                });
					
						return false;
				}
				
			}
		}
				
		return true;
	}
	
	protected String getClasspathString(ILaunchConfiguration conf) throws CoreException
	{
		
		String classPath = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, (String) null);


		if (classPath == null)
		{
			StringBuffer buf = new StringBuffer();
			String[] entries = getClasspath(conf);
			for (int i = 0; i < entries.length; ++i)
				buf.append(entries[i]);
			return buf.toString();
		}
		else
		{
			return classPath;
		}
	}
	
}

