/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.debug.core.*;
import org.eclipse.debug.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.jdt.launching.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class ProfileMainTab extends AbstractLaunchConfigurationTab
{
	private LaunchProcessUI _ui;
	private ProfileHostTab _hostTab;
	
	public ProfileMainTab(ProfileHostTab hostTab)
	{	
		_hostTab = hostTab;
	}

	public void createControl(Composite parent)
	{
		
		Composite content = new Composite(parent, SWT.NULL);
		setControl(content);
		content.setLayout(new GridLayout());
		createVerticalSpacer(content, 1);

		_ui = new LaunchProcessUI();
		_ui.createControl(content);
		_ui.enable(true, true, _hostTab.isLocal(), _hostTab.isLocal(), true);
		_ui.addListener(new Listener() {
			public void handleEvent(Event event)
			{
				// the values changed; update
				updateLaunchConfigurationDialog();
			}
		});
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy wc)
	{
		
	}

	public void initializeFrom(ILaunchConfiguration conf)
	{
		_ui.enable(true, true, _hostTab.isLocal(), _hostTab.isLocal(), true);
		try
		{
			String className = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
			String classPath = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, "");
			String programArgs = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
			String vmArgs = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");

			// environment variables
			ArrayList env = new ArrayList();
			Map map = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_ENVIRONMENT_VARIABLES, (Map) null);
			if (map != null)
			{
				Iterator iter = map.keySet().iterator();
				while (iter.hasNext())
				{
					String key = (String)iter.next();
					env.add(new EnvTableElement(key, (String)map.get(key)));
				}
			}

			_ui.setClassName(className);
			_ui.setClassPath(classPath);
			_ui.setProgramArgs(programArgs);
			_ui.setVMArgs(vmArgs);
			_ui.setEnvData(env);
		}
		catch (CoreException e)
		{
			e.printStackTrace();
		}
	}

	public void performApply(ILaunchConfigurationWorkingCopy wc)
	{
		wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, _ui.getClassName());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, _ui.getClassPath());
		wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, _ui.getParameters());
		wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, _ui.getVMArgs());
		// environment variables
		Map env = new HashMap();
		Iterator iter = _ui.getEnvData().iterator();
		while (iter.hasNext())
		{
			EnvTableElement e = (EnvTableElement)iter.next();
			env.put(e.name(), e.value());
		}

		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_ENVIRONMENT_VARIABLES, env);
	}

	public boolean isValid(ILaunchConfiguration config)
	{
		setErrorMessage(null);
		setMessage(null);

		if (_ui.getClassName().trim().length() == 0)
		{
			setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_MAIN"));
			return false;
		}
		//ZN
		if (_ui.getClassPath().trim().length() == 0)
		{
			setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_CLASSPATH"));
			return false;
		}
		

		return true;
	}

	public String getName()
	{
		return UIPlugin.getResourceString("TAB_NAME_MAIN");
	}

	public Image getImage()
	{
		return PDPluginImages.getImage(PDPluginImages.IMG_UI_CLASS);
	}
}
