/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

/**
 * @author znensi
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ProfileOverviewTab {
	
	private TraceProfileOverviewUI _overviewUI;
	
	
	public ProfileOverviewTab(ProfileTab pt)
	{
		_overviewUI = new TraceProfileOverviewUI(pt);
	}
	
	public Composite createControl(Composite parent)
	{
		return _overviewUI.createControl(parent);
	}
	
	public void addListener (Listener _listener)
	{
		_overviewUI.addListener(_listener);
	}
	
	
	public void initializeFrom(ILaunchConfiguration conf)
    {
		_overviewUI.initializeFrom(conf);
	 }

	   
	public void performApply(ILaunchConfigurationWorkingCopy wc)
	 {
		
		_overviewUI.performApply(wc);
	 }
	
	public void performApply(ILaunchConfigurationWorkingCopy wc, boolean initialize)
	{
		performApply(wc);
		if (initialize) initializeFrom(wc);
		
	}
	 
	public boolean isValid(ILaunchConfiguration conf)
	 {
	    return _overviewUI.isValid(conf);

   }

}
