/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;
import java.util.List;

import org.eclipse.debug.core.*;
import org.eclipse.debug.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileUI;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.launcher.*;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.WorkbenchHelp;

public class ProfileTab extends AbstractLaunchConfigurationTab
{
	private TraceProfileUI _profileUI;
	private ILaunchConfigurationDialog ILCD;

	public void update()
	{
		updateLaunchConfigurationDialog();
	}


	public void createControl(Composite parent)
	{
		Composite content = new Composite(parent, SWT.NULL);
		setControl(content);
		content.setLayout(new GridLayout());
		

		_profileUI = new TraceProfileUI(this);
		_profileUI.createControl(content);
		
		_profileUI.addListener(new Listener() {
					public void handleEvent(Event event)
					{
						// the values changed; update
						updateLaunchConfigurationDialog();
					}
				});
				


		WorkbenchHelp.setHelp(parent, UIPlugin.getPluginId() + ".pcwp0000");
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy wc)
	{
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		
		// Limits sub-tab defaults
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, store.getBoolean(TraceConstants.LIMIT_TRACE_INVOC_OPTION));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, store.getInt(TraceConstants.LIMIT_INVOC_NB));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, store.getBoolean(TraceConstants.LIMIT_TRACE_TIME_OPTION));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, store.getInt(TraceConstants.LIMIT_TIME_NB));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, store.getBoolean(TraceConstants.PROF_AUTO_MONITOR));

		// Destination sub-tab defaults
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(TraceConstants.TRACE_PROJECT_NAME));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString(TraceConstants.TRACE_MONITOR_NAME));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String) null);
		
		// Overview sub-tab defaults
		ProfilingSetsManager manager = ProfilingSetsManager.instance();
   	    Object[] sets = manager.getProfilingSets().values().toArray();
   	    
   	    if(sets.length > 0)
   	    {
   	    	IProfilingSet set = (IProfilingSet) sets[0];
   	    	
   		 	//set profiling types
   		 	List types = set.getProfilingTypes();
   		 	for(int i=0; i<types.size(); i++)
   		 	{
   	   		 	wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILINGTYPE+i, types.get(i).toString());
   		 		
   		 	}
   		 	//set attributes
   		 	Iterator options = set.getAttributes().values().iterator();
   		 	while(options.hasNext())
   		 	{
   		 		ProfilingAttribute option = (ProfilingAttribute)options.next();
   	   		 	wc.setAttribute(option.getName(), option.getValue());  
   		 	}   	    	
   	    }
   	    
   	    //initialize filters
   	    FilterSetElement felem = manager.getDefaultFilterSet();
		ArrayList attrs = felem.getChildren();
		StringBuffer filterStr = new StringBuffer();
		for(int idx=0; idx<attrs.size(); idx++)
		{
			FilterTableElement elem = (FilterTableElement) attrs.get(idx);
			filterStr.append(elem.getText());
			if(elem.getMethod().length() > 0)
				filterStr.append(":").append(elem.getMethod());
			filterStr.append(":").append(elem.getVisibility());
			filterStr.append("&");
		}
		
		String key = UIPlugin.getPluginId()+".SETFILTER";
		wc.setAttribute(key, filterStr.toString());
   	    

	}
	
	public void activated(ILaunchConfigurationWorkingCopy conf)
	{
		_profileUI.activated(conf);
	}

	public void initializeFrom(ILaunchConfiguration conf)
	{
		_profileUI.initializeFrom(conf);
	}

	public void performApply(ILaunchConfigurationWorkingCopy wc, boolean initialize)
	{
		_profileUI.performApply(wc, initialize);
	}
	
	public void performApply(ILaunchConfigurationWorkingCopy wc)
	{
		_profileUI.performApply(wc, false);
	}

	public boolean isValid(ILaunchConfiguration conf)
	{
		return _profileUI.isValid(conf);	
	}

	public String getName()
	{
		return UIPlugin.getResourceString("TAB_NAME_PROFILE");
	}

	public Image getImage()
	{
		return PDPluginImages.getImage(PDPluginImages.IMG_OPTIONS);
	}
	
	public void setErrorMessage(String msg)
	{
		super.setErrorMessage(msg);
	}
	
	public void setMessage(String msg)
	{
		super.setMessage(msg);
	}
}

